/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.Trace;
import com.streamscape.cli.ClientState;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.SerializerSupport;
import com.streamscape.omf.SerializerSupportException;
import com.streamscape.omf.xml.XSerializerException;
import com.streamscape.omf.xml.XSerializerRuntimeException;
import com.streamscape.omf.xml.xstream.converters.ConversionException;
import com.streamscape.omf.xml.xstream.mapper.CannotResolveClassException;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.repository.types.TypeNamingException;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sdo.DatagramPrototypeCacheImpl;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.FabricEventSinkFactory;
import com.streamscape.sdo.FabricEventSourceFactory;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.IAbstractEvent;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.security.cipher.DefaultCipherSuite;
import com.streamscape.sdo.security.cipher.EventDatagramCipherSuite;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricEventSinkException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.dispatcher.AbstractDatagramFactoryHelper;
import com.streamscape.sef.dispatcher.ReservedSubjects;
import com.streamscape.sef.utils.RepositoryUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class IAbstractDatagramFactory
extends AbstractDatagramFactoryHelper
implements DatagramFactory,
SerializerSupport {
    protected String factoryName = "";
    protected String ancestorType = "";
    protected long serialVersionUID = 9969000000302071L;
    protected String cipherSuite = DefaultCipherSuite.class.getName();
    protected List<String> supportedTypeModel = new ArrayList<String>();
    protected transient DatagramPrototypeCacheImpl prototypeCache;
    private transient Map<String, DatagramEntry> entries;

    protected IAbstractDatagramFactory(String factoryName, String ancestorType) {
        this.init(factoryName, ancestorType);
    }

    protected IAbstractDatagramFactory(String factoryName, String ancestorType, long serialVersionUID) {
        this.serialVersionUID = serialVersionUID;
        this.init(factoryName, ancestorType);
    }

    protected void init(String factoryName, String ancestorType) {
        this.factoryName = factoryName;
        this.ancestorType = ancestorType;
        this.initDatagramEntries();
        this.initSupportedModels();
    }

    protected void init() throws DatagramFactoryException {
        if (context == null) {
            throw new DatagramFactoryException(5072, "Initialization of " + this.factoryName + " failed. Cause: Fabric Context is 'null'.");
        }
        try {
            this.initSerializers();
        }
        catch (Exception exception) {
            throw new DatagramFactoryException(5072, (Throwable)exception);
        }
        this.initPrototypes();
    }

    protected final void initDatagramEntries() {
        this.entries = new HashMap<String, DatagramEntry>();
        this.addDatagramEntries();
    }

    protected abstract void addDatagramEntries();

    protected final void addDatagramEntry(ImmutableEventDatagram datagram, String description, String prototypeEventId) {
        this.entries.put(datagram.getClass().getSimpleName(), new DatagramEntry(datagram, description, prototypeEventId));
    }

    protected final void addDatagramEntry(ImmutableEventDatagram datagram, String description) {
        this.addDatagramEntry(datagram, description, "e.prototype." + datagram.getClass().getSimpleName());
    }

    protected final Map<String, DatagramEntry> getDatagramEntries() {
        if (this.entries == null) {
            this.initDatagramEntries();
        }
        return this.entries;
    }

    protected final void initSupportedModels() {
        for (DatagramEntry entry : this.getDatagramEntries().values()) {
            this.addSupportedModel(entry.getModel());
        }
    }

    protected void initPrototypes() throws DatagramFactoryException {
        try {
            if (SemanticObjectReferenceStore.lookupReferenceContext(this.getPrototypeNamespace()) == null) {
                SemanticObjectReferenceStore.beginXact();
                SemanticObjectReferenceStore.createSubcontextFromNamespace(this.getPrototypeNamespace());
                SemanticObjectReferenceStore.commitXact();
            }
            this.loadRegisteredPrototypes();
        }
        catch (DatagramFactoryException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new DatagramFactoryException(5072, (Throwable)exception);
        }
    }

    protected void initSerializers() throws FactoryManagerException, SerializerSupportException {
    }

    protected void setPrototypeCache(DatagramPrototypeCacheImpl prototypeCache) {
        this.prototypeCache = prototypeCache;
    }

    @Override
    public String getName() {
        return this.factoryName;
    }

    @Override
    public SemanticType getSemanticType() {
        SemanticType type = IAbstractDatagramFactory.createSemanticType(this.factoryName, this, false);
        type.setAncestorType("DatagramFactory");
        type.setDescription("Datagram Factory Type.");
        return type;
    }

    @Override
    public String getAncestorType() {
        return this.ancestorType;
    }

    @Override
    public String getPrototypeNamespace() {
        return "/sys/datagram/prototype/" + this.factoryName;
    }

    @Override
    public List<SemanticType> getSupportedTypes() {
        Vector<SemanticType> result = new Vector<SemanticType>();
        for (DatagramEntry entry : this.getDatagramEntries().values()) {
            this.addSemanticType(entry.datagram.getClass(), entry.description, result);
        }
        return result;
    }

    protected void doRegisterPrototype(String eventId, Prototype prototype, ImmutableEventDatagram event, boolean isSystem) throws DatagramFactoryException {
        this.checkRegistrationParameters(eventId, prototype, event, isSystem);
        event = this.prepareEventInstance(event, eventId);
        this.doRegisterPrototype(prototype, event);
    }

    protected void checkRegistrationParameters(String eventId, Prototype prototype, ImmutableEventDatagram event, boolean isSystem) throws DatagramFactoryException {
        if (!isSystem && SDOUtils.isSystemEventId(eventId)) {
            throw new DatagramFactoryException(5021, ErrorMessages.format("Event id [%1$s] is reserved for system purposes.", eventId));
        }
        this.checkPrototypeModel(prototype);
        this.checkSemanticType(prototype.getModelName(), event);
        if (this.prototypeCache.existsEventId(eventId)) {
            throw new DatagramFactoryException(5030, ErrorMessages.format("Event prototype [%1$s] already exists.", eventId));
        }
    }

    protected void checkSemanticType(String model, ImmutableEventDatagram event) throws DatagramFactoryException {
        SemanticType type = this.getSemanticType(event);
        if (!model.equals(type.getTypeName())) {
            throw new DatagramFactoryException(5034, "Prototype model '" + model + "' does not match datagram semantic type '" + type.getTypeName() + "'.");
        }
    }

    protected void doRegisterPrototype(Prototype prototype, ImmutableEventDatagram event) throws DatagramFactoryException {
        this.doRegisterPrototype(prototype, event, false);
    }

    protected void doRegisterPrototype(Prototype prototype, ImmutableEventDatagram event, boolean replace) throws DatagramFactoryException {
        try {
            SemanticObjectReferenceStore.beginXact();
            ReferenceContext ref = this.getPrototypeReferenceContext();
            SemanticObjectReferenceStore.setReferenceContext(ref);
            if (!replace) {
                if (SemanticObjectReferenceStore.existsBinding(prototype.getInstanceName())) {
                    RepositoryUtils.moveObjectToJunk(ref, prototype.toString());
                }
                SemanticObjectReferenceStore.bind(prototype.getInstanceName(), event);
                Trace.logDebug(this, "Prototype '" + String.valueOf(prototype) + "' registered with datagram factory '" + this.getName() + "'.");
            } else {
                this.updateEventPrototype(prototype, event);
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            throw new DatagramFactoryException(4000, (Throwable)exception);
        }
        catch (RepositoryException exception) {
            throw new DatagramFactoryException(4000, (Throwable)exception);
        }
    }

    protected ImmutableEventDatagram prepareEventInstance(ImmutableEventDatagram event, String eventId) throws DatagramFactoryException {
        try {
            if (event instanceof Exception) {
                this.initCause((Exception)((Object)event));
            }
            ImmutableEventDatagram result = event.clone();
            if (event instanceof IAbstractDataEvent) {
                ((IAbstractDataEvent)result).setEventId(eventId);
            } else if (event instanceof IAbstractEvent) {
                ((IAbstractEvent)result).setEventId(eventId);
            } else if (event instanceof IAbstractExceptionEvent) {
                ((IAbstractExceptionEvent)result).setEventId(eventId);
            } else {
                throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", event.getClass().getName()));
            }
            return result;
        }
        catch (SDOFormatException exception) {
            throw new DatagramFactoryException(5020, exception.getMessage());
        }
    }

    void initCause(Exception exception) {
        if (exception.getCause() == null) {
            try {
                exception.initCause(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    protected void unregisterPrototype(Prototype prototype) throws DatagramFactoryException {
        if (this.isClientContext("unregisterPrototype()")) {
            return;
        }
        this.checkPrototypeModel(prototype);
        try {
            if (RepositoryUtils.unbindObject(this.getPrototypeReferenceContext(), prototype.getInstanceName())) {
                Trace.logDebug(this, "Prototype '" + String.valueOf(prototype) + "' unregistered from datagram factory '" + this.getName() + "'.");
            }
        }
        catch (ObjectConfigurationException exception) {
            throw new DatagramFactoryException(4000, (Throwable)exception);
        }
    }

    protected void unregisterPrototype(String eventId) throws DatagramFactoryException {
        if (SDOUtils.isSystemEventId(eventId)) {
            throw new DatagramFactoryException(5021, ErrorMessages.format("Event id [%1$s] is reserved for system purposes.", eventId));
        }
        this.unregisterPrototype(this.getPrototype(eventId));
    }

    protected void addSupportedTypes() throws DatagramFactoryException {
        Trace.logDebug(this, "Adding supported semantic types.");
        try {
            for (SemanticType type : this.getSupportedTypes()) {
                TypeFactory.addSemanticType(type);
                Trace.logDebug(this, "Semantic type '" + type.getTypeName() + "' added.");
            }
        }
        catch (Exception exception) {
            throw new DatagramFactoryException(5072, (Throwable)exception);
        }
    }

    protected void loadRegisteredPrototypes() throws DatagramFactoryException, SDOException {
        if (this.isClientContext("loadRegisteredPrototypes()")) {
            return;
        }
        Trace.logDebug(this, "Loading registered prototypes for factory '" + this.getName() + "'.");
        try {
            SemanticObjectReferenceStore.beginXact();
            ReferenceContext ref = this.getPrototypeReferenceContext();
            SemanticObjectReferenceStore.setReferenceContext(ref);
            for (String instanceName : SemanticObjectReferenceStore.listBoundNames(null)) {
                ImmutableEventDatagram event = null;
                Prototype prototype = null;
                try {
                    Pair<ImmutableEventDatagram, Pair<String, String>> eventInfo = this.loadEventPrototype(instanceName);
                    event = (ImmutableEventDatagram)eventInfo.first;
                    Pair<SemanticType, Prototype> prototypeInfo = this.resolveEventPrototype(event, instanceName, (Pair)eventInfo.second);
                    prototype = (Prototype)prototypeInfo.second;
                    if (prototype.isValid()) {
                        this.checkSerialVersionUID((SemanticType)prototypeInfo.first, event, instanceName);
                    }
                    if (!SDOUtils.isSystemEventId(event.getEventId())) {
                        this.prototypeCache.addPrototype(this, prototype, event);
                    } else {
                        SemanticObjectReferenceStore.unbind(instanceName);
                    }
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    String artifact = null;
                    if (exception instanceof DatagramFactoryException && ((DatagramFactoryException)exception).getEventKey() != null) {
                        artifact = ((DatagramFactoryException)exception).getEventKey();
                    } else {
                        for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                            if (!(cause instanceof TFCacheException)) continue;
                            artifact = ((TFCacheException)cause).getArtifact();
                            break;
                        }
                    }
                    if (artifact != null) {
                        RepositoryUtils.moveObjectToJunk(ref, artifact);
                    }
                    prototype = null;
                }
                if (prototype == null || !prototype.isValid()) {
                    String eventId = event != null && event.getEventId() != null ? event.getEventId() : null;
                    Trace.logError(this, "Loading event prototype artifact '" + instanceName + "' failed." + (String)(eventId != null ? " Event id: '" + eventId + "'." : ""));
                }
                if (SemanticObjectReferenceStore.inXact()) continue;
                SemanticObjectReferenceStore.beginXact();
                SemanticObjectReferenceStore.setReferenceContext(ref);
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            throw new DatagramFactoryException(4000, "Loading registered event prototypes failed.", exception);
        }
        catch (Exception exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            if (exception instanceof DatagramFactoryException) {
                throw (DatagramFactoryException)exception;
            }
            throw new DatagramFactoryException(5072, "Loading registered event prototypes failed.", exception);
        }
    }

    private Pair<ImmutableEventDatagram, Pair<String, String>> loadEventPrototype(String instance) throws Exception {
        ImmutableEventDatagram event = null;
        Pair<Object, Object> error = null;
        try {
            event = (ImmutableEventDatagram)SemanticObjectReferenceStore.lookup(instance);
        }
        catch (Exception exception) {
            boolean isNewException = false;
            boolean suppressStackTrace = false;
            String dataType = null;
            String artifact = null;
            for (Throwable cause = exception.getCause(); cause != null; cause = cause.getCause()) {
                if (cause instanceof TFCacheException) {
                    artifact = ((TFCacheException)cause).getArtifact();
                } else if (cause instanceof XSerializerException) {
                    if (((XSerializerException)cause).getErrorCode() == 3022) {
                        throw IAbstractDatagramFactory.createException("Event model '" + artifact.substring(0, artifact.indexOf(".")) + "' not found.", null, artifact);
                    }
                } else if (cause instanceof XSerializerRuntimeException) {
                    suppressStackTrace = true;
                    if (((XSerializerRuntimeException)cause).getObject() instanceof ImmutableEventDatagram) {
                        event = (ImmutableEventDatagram)((XSerializerRuntimeException)cause).getObject();
                    }
                    if (event instanceof PayloadEvent) {
                        SemanticTypeCache cache = context.getSemanticTypeCache();
                        if (cause instanceof ConversionException) {
                            dataType = ((ConversionException)cause).get("class");
                            if (dataType != null && ((dataType = cache.resolveSemanticClass(dataType)) == null || dataType.equals("DataEvent") || dataType.equals("DeltaEvent") || dataType.equals("OpaqueEvent"))) {
                                event = null;
                            }
                        } else if (cause instanceof CannotResolveClassException) {
                            String string = dataType = cache.existsSemanticType(cause.getMessage()) ? cause.getMessage() : cache.resolveSemanticClass(cause.getMessage());
                            if (dataType == null) {
                                dataType = cause.getMessage();
                                error = new Pair<CallSite, String>((CallSite)((Object)("Payload semantic type '" + dataType + "' not found.")), dataType);
                            } else {
                                error = new Pair<CallSite, String>((CallSite)((Object)("Payload semantic type '" + dataType + "' not valid.")), dataType);
                            }
                            exception = IAbstractDatagramFactory.createException((String)error.first, null, artifact);
                        } else {
                            event = null;
                        }
                    }
                    if (!isNewException) {
                        exception = IAbstractDatagramFactory.createException(cause instanceof CannotResolveClassException ? "Class '" + cause.getMessage() + "' not found." : null, cause, artifact);
                        isNewException = true;
                    }
                }
                if (!suppressStackTrace) continue;
                cause.setStackTrace(new StackTraceElement[0]);
            }
            if (event == null || event.getEventId() == null) {
                throw exception;
            }
            if (error == null) {
                error = new Pair<String, Object>(Utils.formatException(exception, " "), dataType);
            }
            Trace.logException(this, exception, true);
        }
        return new Pair<ImmutableEventDatagram, Object>(event, error);
    }

    private static Exception createException(String message, Throwable cause, String artifact) {
        DatagramFactoryException result = message != null ? new DatagramFactoryException(5028, message) : new DatagramFactoryException(5028, cause);
        result.setEventKey(artifact);
        return result;
    }

    protected Pair<SemanticType, Prototype> resolveEventPrototype(ImmutableEventDatagram event, String instanceName, Pair<String, String> error) throws DatagramFactoryException {
        SemanticType type = this.getSemanticType(event);
        this.checkPrototypeModel(type, event);
        Prototype prototype = this.createPrototype(type.getTypeName(), instanceName, error);
        if (event instanceof PayloadEvent && ((PayloadEvent)((Object)event)).getPayloadClass() == null) {
            if (error != null && error.second != null) {
                SemanticType dataType = context.getSemanticTypeCache().lookupSemanticType((String)error.second);
                if (dataType != null && dataType.isValid()) {
                    Trace.logDebug(this, "Recreating event prototype [" + event.getEventId() + "].");
                    this.checkEventPrototype(dataType, prototype, event);
                    Trace.logInfo(this, "Event prototype [" + event.getEventId() + "] recreated.");
                    return new Pair<SemanticType, Prototype>(type, prototype);
                }
            } else if (!ReservedSubjects.isReserved(event.getEventId())) {
                DatagramFactoryException exception = new DatagramFactoryException(5039, "Event payload is null.");
                exception.setEventKey(prototype.toString());
                throw exception;
            }
        }
        if (event instanceof IAbstractDataEvent) {
            ((IAbstractDataEvent)event).resolveAnnotations();
        }
        return new Pair<SemanticType, Prototype>(type, prototype);
    }

    protected Prototype createPrototype(String model, String instance, Pair<String, String> error) throws DatagramFactoryException {
        try {
            Prototype result = new Prototype(model, instance);
            if (error != null) {
                IAbstractDatagramFactory.invalidatePrototype(result, (String)error.first, (String)error.second);
            }
            return result;
        }
        catch (TypeNamingException exception) {
            throw new DatagramFactoryException(5006, (Throwable)exception);
        }
    }

    private void checkSerialVersionUID(SemanticType type, ImmutableEventDatagram event, String instanceName) throws DatagramFactoryException, ObjectConfigurationException {
        if (type.getSerialVersionUID() != event.getSerialVersionUID()) {
            Trace.logDebug(this, "Warning: Serial Version mismatch for prototype '" + instanceName + "', Semantic Type '" + type.getTypeName() + "'. Synchronizing...");
            if (event instanceof IAbstractDataEvent) {
                ((IAbstractDataEvent)event).setSerialVersionUID(type.getSerialVersionUID());
            } else if (event instanceof IAbstractExceptionEvent) {
                ((IAbstractExceptionEvent)event).setSerialVersionUID(type.getSerialVersionUID());
            } else {
                throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", event.getClass().getName()));
            }
            SemanticObjectReferenceStore.unbind(instanceName);
            SemanticObjectReferenceStore.bind(instanceName, event);
        }
    }

    protected void addPrototype(Prototype prototype, ImmutableEventDatagram event) throws DatagramFactoryException {
        this.checkPrototypeNotNull(prototype);
        this.checkNotNull(event, "Event");
        if (this.prototypeCache.existsEventId(event.getEventId())) {
            throw new DatagramFactoryException(5030, ErrorMessages.format("Event prototype [%1$s] already exists.", event.getEventId()));
        }
        if (this.prototypeCache.existsPrototype(prototype)) {
            throw new DatagramFactoryException(5030, ErrorMessages.format("Event prototype [%1$s] already exists.", prototype.toString()));
        }
        this.prototypeCache.addPrototype(this, prototype, event);
    }

    protected void removePrototype(Prototype prototype) throws DatagramFactoryException {
        this.checkPrototypeNotNull(prototype);
        this.checkPrototypeModel(prototype);
        this.prototypeCache.removePrototype(prototype);
    }

    @Override
    public List<String> listPrototypeModels() {
        ArrayList<String> result = new ArrayList<String>(this.supportedTypeModel);
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean supportsModel(String type) {
        return this.supportedTypeModel.contains(type);
    }

    protected void addSupportedModel(String model) {
        this.supportedTypeModel.add(model);
    }

    @Override
    public boolean existsPrototype(String eventId) {
        Prototype prototype = this.prototypeCache.lookupPrototype(eventId);
        return prototype != null && this.ancestorType.equals(this.prototypeCache.doGetAncestor(prototype));
    }

    protected boolean existsPrototype(Prototype prototype) {
        return this.prototypeCache.existsPrototype(prototype);
    }

    @Override
    public List<String> listEventIds() {
        return this.prototypeCache.listEventIdsByAncestor(this.ancestorType);
    }

    protected List<Prototype> getPrototypes() {
        return this.prototypeCache.getPrototypesByAncestor(this.ancestorType);
    }

    protected boolean isPrototypeRegistered(Prototype prototype) throws DatagramFactoryException {
        if (this.isClientContext("isRegisteredPrototype()")) {
            return false;
        }
        this.checkPrototypeNotNull(prototype);
        try {
            return RepositoryUtils.existsObject(this.getPrototypeReferenceContext(), prototype.getInstanceName());
        }
        catch (ObjectConfigurationException exception) {
            throw new DatagramFactoryException(4000, (Throwable)exception);
        }
    }

    @Override
    public long getSerialVersionUID() {
        return this.serialVersionUID;
    }

    @Override
    public ImmutableEventDatagram newEventInstance(SemanticType type) throws DatagramFactoryException {
        this.checkPrototypeModel(type);
        return this.doNewEventInstanceFrom(this.getDatagramEntries().get((Object)type.getTypeName()).datagram, false);
    }

    @Override
    public ImmutableEventDatagram newEventInstance(String semanticType) throws DatagramFactoryException {
        SemanticType type = context.getSemanticTypeCache().lookupSemanticType(semanticType);
        if (type == null) {
            throw new DatagramFactoryException(5014, ErrorMessages.format("Semantic type [%1$s] does not exist.", semanticType));
        }
        return this.newEventInstance(type);
    }

    @Override
    public ImmutableEventDatagram newEventInstanceFrom(String eventId) throws DatagramFactoryException {
        ImmutableEventDatagram result = this.createEvent(eventId);
        this.resetEventInstance(result);
        return result;
    }

    protected void resetEventInstance(ImmutableEventDatagram event) {
        if (event instanceof IAbstractDataEvent) {
            ((IAbstractDataEvent)event).resetEventId();
        } else if (event instanceof IAbstractEvent) {
            ((IAbstractEvent)event).resetEventId();
        } else if (event instanceof IAbstractExceptionEvent) {
            ((IAbstractExceptionEvent)event).resetEventId();
        }
    }

    @Override
    public ImmutableEventDatagram newEventInstanceFrom(ImmutableEventDatagram event) throws DatagramFactoryException {
        return this.doNewEventInstanceFrom(event, true);
    }

    protected ImmutableEventDatagram doNewEventInstanceFrom(ImmutableEventDatagram event, boolean validate) throws DatagramFactoryException {
        this.validateEventModel(event, validate);
        ImmutableEventDatagram result = event.clone();
        if (event instanceof IAbstractDataEvent) {
            ((IAbstractDataEvent)result).reset(true);
            ((IAbstractDataEvent)result).resetEventId();
        } else if (event instanceof IAbstractEvent) {
            ((IAbstractEvent)result).reset(true);
            ((IAbstractEvent)result).resetEventId();
        } else if (event instanceof IAbstractExceptionEvent) {
            ((IAbstractExceptionEvent)result).reset(true);
            ((IAbstractExceptionEvent)result).resetEventId();
        } else {
            throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", event.getClass().getName()));
        }
        return result;
    }

    @Override
    public ImmutableEventDatagram createEvent(Prototype prototype) throws DatagramFactoryException {
        prototype = this.getPrototype(prototype);
        this.checkPrototype(prototype);
        return this.doCreateEvent(prototype);
    }

    @Override
    public ImmutableEventDatagram createEvent(String eventId) throws DatagramFactoryException {
        Prototype prototype = this.getPrototype(eventId);
        this.checkPrototype(prototype);
        return this.doCreateEvent(prototype);
    }

    protected void checkPrototype(Prototype prototype) throws DatagramFactoryException {
        this.checkPrototypeModel(prototype);
        if (!prototype.isValid()) {
            throw new DatagramFactoryException(5028, "Event prototype [" + String.valueOf(prototype) + "] is invalid.");
        }
    }

    protected ImmutableEventDatagram doCreateEvent(Prototype prototype) throws DatagramFactoryException {
        return this.prototypeCache.getEventPrototype(prototype);
    }

    @Override
    public ImmutableEventDatagram cloneEvent(ImmutableEventDatagram event) throws DatagramFactoryException {
        this.validateEventModel(event, true);
        ImmutableEventDatagram result = event.clone();
        try {
            FabricEventSinkFactory.reset(result);
        }
        catch (FabricEventSinkException exception) {
            throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", event.getClass().getName()));
        }
        return result;
    }

    private void validateEventModel(ImmutableEventDatagram event, boolean validate) throws DatagramFactoryException {
        if (validate) {
            SemanticType type = this.getSemanticType(event);
            this.checkPrototypeModel(type);
        }
    }

    public void setCipherSuiteName(EventDatagramCipherSuite cipherSuite) {
        this.cipherSuite = cipherSuite.getName();
    }

    @Override
    public EventDatagramCipherSuite getCipherSuite() throws DatagramFactoryException {
        if (this.cipherSuite == null) {
            throw new DatagramFactoryException(5004, "Cipher suite is null.");
        }
        try {
            return (EventDatagramCipherSuite)ClassUtils.createFromClassName((Object)this, this.cipherSuite, context.getSystemClassLoaderChain());
        }
        catch (UtilitiesException exception) {
            throw new DatagramFactoryException(5000, (Throwable)exception);
        }
    }

    protected boolean isClientContext(String methodName) throws SDORuntimeException {
        if (ClientState.isActive()) {
            Trace.logDebug(this, "Invocation of " + methodName + " in ClientContext.");
            return true;
        }
        return false;
    }

    protected void addSemanticType(Class eventClass, String description, List<SemanticType> result) {
        SemanticType type = IAbstractDatagramFactory.createSemanticType(eventClass.getSimpleName(), eventClass, false);
        type.setDescription(description);
        type.setAncestorType(this.ancestorType);
        result.add(type);
    }

    protected void setAcknowledgementSourceData(ImmutableEventDatagram sourceEvent, AcknowledgementEvent ackEvent) throws SecurityViolationException, SDOException, FabricEventSourceException {
        FabricEventSourceFactory.setSourceData(sourceEvent, ackEvent);
    }

    protected void checkNotNull(Object object, String objectName) throws DatagramFactoryException {
        if (object == null) {
            throw new DatagramFactoryException(5004, ErrorMessages.format("%1$s is null.", objectName));
        }
    }

    protected void checkPrototypeNotNull(Prototype prototype) throws DatagramFactoryException {
        this.checkNotNull(prototype, "Prototype");
    }

    protected void checkPrototypeModel(String model) throws DatagramFactoryException {
        if (!this.supportsModel(model)) {
            throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", model));
        }
    }

    protected void checkPrototypeModel(Prototype prototype) throws DatagramFactoryException {
        this.checkPrototypeModel(prototype.getModelName());
    }

    protected void checkPrototypeModel(SemanticType type) throws DatagramFactoryException {
        this.checkPrototypeModel(type.getTypeName());
    }

    protected void checkPrototypeModel(SemanticType type, ImmutableEventDatagram event) throws DatagramFactoryException {
        this.checkPrototypeModel(type);
    }

    protected Prototype getPrototype(String eventId) throws DatagramFactoryException {
        Prototype prototype = this.doLookupPrototype(eventId);
        if (prototype == null && (prototype = this.importPrototype(eventId)) == null) {
            throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", eventId));
        }
        return prototype;
    }

    @Override
    protected Prototype doLookupPrototype(String eventId) {
        return this.prototypeCache.doLookupPrototype(eventId);
    }

    protected Prototype getPrototype(Prototype prototype) throws DatagramFactoryException {
        Prototype result = this.prototypeCache.doLookupPrototype(prototype);
        if (result == null) {
            throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", result.toString()));
        }
        return result;
    }

    protected SemanticType getSemanticType(ImmutableEventDatagram event) throws DatagramFactoryException {
        SemanticType type = context.getSemanticTypeCache().lookupSemanticClass(event.getClass());
        if (type == null) {
            throw new DatagramFactoryException(5014, "Semantic type not found for class '" + event.getClass().getName() + "'.");
        }
        return type;
    }

    protected ReferenceContext getPrototypeReferenceContext() throws DatagramFactoryException, ObjectConfigurationException {
        ReferenceContext result = SemanticObjectReferenceStore.lookupReferenceContext(this.getPrototypeNamespace());
        if (result == null) {
            throw new DatagramFactoryException(4000, "Reference context '" + this.getPrototypeNamespace() + "' not found.");
        }
        return result;
    }

    protected Pair<Prototype, ImmutableEventDatagram> checkEventPrototype(SemanticType dataType, Prototype prototype, ImmutableEventDatagram event) {
        Pair<Prototype, ImmutableEventDatagram> result = new Pair<Prototype, ImmutableEventDatagram>(prototype, event);
        if (!dataType.isValid()) {
            this.resetData(event);
            IAbstractDatagramFactory.invalidatePrototype(prototype, "Payload class '" + dataType.getClassName() + "' not found.", dataType.getTypeName());
            if (event instanceof IAbstractDataEvent) {
                ((IAbstractDataEvent)event).invalidateAnnotations();
            }
            Trace.logInfo(this, "WARNING: Event prototype [" + event.getEventId() + "] invalidated.");
        } else {
            try {
                this.resetData(event, dataType);
                if (result.second instanceof IAbstractDataEvent) {
                    ((IAbstractDataEvent)result.second).resolveAnnotations();
                }
                this.doRegisterPrototype(prototype, event, true);
                IAbstractDatagramFactory.validatePrototype(prototype);
                Trace.logInfo(this, "Event prototype [" + event.getEventId() + "] validated.");
            }
            catch (Exception exception) {
                this.resetData(event);
                IAbstractDatagramFactory.invalidatePrototype(prototype, exception.toString(), dataType.getTypeName());
                Trace.logInfo(this, "WARNING: Event prototype [" + event.getEventId() + "] invalidated.");
            }
        }
        return result;
    }

    protected void resetData(ImmutableEventDatagram event) {
    }

    protected void resetData(ImmutableEventDatagram event, SemanticType dataType) throws Exception {
    }

    protected void removeSystemPrototypes(IAbstractDatagramFactory factory, DatagramPrototypeCacheImpl prototypeCache) throws Exception {
        for (DatagramEntry entry : this.getDatagramEntries().values()) {
            Prototype prototype = new Prototype(entry.getModel(), entry.getModel());
            if (prototypeCache.existsPrototype(prototype)) {
                prototypeCache.removePrototype(prototype);
            }
            this.unregisterPrototype(prototype);
        }
    }

    protected static final class DatagramEntry {
        ImmutableEventDatagram datagram;
        String description;
        String prototypeEventId;

        DatagramEntry(ImmutableEventDatagram datagram, String description, String prototypeEventId) {
            this.datagram = datagram;
            this.description = description;
            this.prototypeEventId = prototypeEventId;
        }

        public String getModel() {
            return this.datagram.getClass().getSimpleName();
        }

        public String getDescription() {
            return this.description;
        }

        public String getPrototypeEventId() {
            return this.prototypeEventId;
        }
    }
}

