/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.Trace;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.AnnotationManager;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.EventAnnotation;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.FabricEventSourceFactory;
import com.streamscape.sdo.IAbstractDataObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.ReferenceCounter;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.enums.PropertyType;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.security.AccessControl;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.utils.Utils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class IAbstractDataEvent
extends IAbstractDataObject
implements ImmutableEventDatagram {
    protected byte[] eventSource = null;
    protected String eventId = null;
    protected boolean durable = false;
    protected String eventKey = null;
    protected String eventGroupId = null;
    protected byte[] correlationId = null;
    protected byte[] saToken = null;
    protected String eventReplyTo = null;
    protected String eventForwardTo = null;
    protected long timeStamp = 0L;
    protected long eventExpiration = 0L;
    protected byte[] dataProtected = new byte[]{71};
    protected String principal = null;
    protected byte[] credential = null;
    protected AccessControl acl = DEFAULT_ACCESS_CONTROL;
    protected boolean coalesced = false;
    protected HashMap<String, Object> eventProperties = null;
    protected HashMap<String, EventAnnotation> eventAnnotations = null;
    protected transient boolean isFinal = false;
    protected transient ReferenceCounter metadataCounter = null;
    protected transient ReferenceCounter dataCounter = null;
    protected static final AccessControl DEFAULT_ACCESS_CONTROL = new AccessControl();

    protected IAbstractDataEvent() {
    }

    protected IAbstractDataEvent(String eventId) throws SDOFormatException {
        this.setEventId(eventId);
    }

    protected void assertState() throws SDORuntimeException {
        if (this.isCoalesced()) {
            throw new SDORuntimeException(ErrorMessages.format("Event [%1$s] is coalesced and cannot be modified.", this.eventId));
        }
    }

    protected void assertReadAccess() throws SecurityViolationException {
        if (this.isProtected()) {
            if (this.getReadAccess() == 27) {
                // empty if block
            }
            if (this.getReadAccess() == 24) {
                throw new SecurityViolationException(5041, "Event [" + this.eventId + "] is protected against reading.");
            }
            if (this.getReadAccess() == 25) {
                throw new RuntimeException("Feature unsupported.");
            }
            if (this.getReadAccess() == 26) {
                throw new RuntimeException("Feature unsupported.");
            }
        }
    }

    protected void assertWriteAccess() throws SecurityViolationException {
        if (this.isProtected() && this.getWriteAccess() != 37) {
            if (this.getWriteAccess() == 34) {
                throw new SecurityViolationException(5042, "Event [" + this.eventId + "] is protected against writing.");
            }
            if (this.getWriteAccess() == 35) {
                throw new RuntimeException("Feature unsupported.");
            }
            if (this.getWriteAccess() == 36) {
                throw new RuntimeException("Feature unsupported.");
            }
        }
    }

    protected void assertTransmitAccess() throws SecurityViolationException {
        if (this.isProtected()) {
            if (this.getTransmitAccess() == 45 || this.getTransmitAccess() == 44) {
                // empty if block
            }
            if (this.getTransmitAccess() == 47) {
                throw new RuntimeException("Feature unsupported.");
            }
            if (this.getTransmitAccess() == 46) {
                throw new RuntimeException("Feature unsupported.");
            }
        }
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    protected void setEventId(String eventId) throws SDOFormatException {
        this.assertState();
        SDOUtils.validateEventId(eventId);
        this.eventId = eventId;
    }

    void resetEventId() {
        this.eventId = null;
    }

    @Override
    public String getEventKey() {
        return this.eventKey;
    }

    protected void setEventKey(String key) {
        this.assertState();
        this.eventKey = key;
    }

    @Override
    public String getEventGroupId() {
        return this.eventGroupId;
    }

    protected void setEventGroupId(String group) {
        this.assertState();
        this.eventGroupId = group;
    }

    public String getCorrelationId() {
        return this.correlationId != null ? new String(this.correlationId) : null;
    }

    protected void setCorrelationId(String correlationId) {
        this.assertState();
        this.correlationId = correlationId != null ? correlationId.getBytes() : null;
    }

    public byte[] getCorrelationIdAsBytes() {
        return this.correlationId != null ? (byte[])this.correlationId.clone() : null;
    }

    protected void setCorrelationIdAsBytes(byte[] correlationId) {
        this.assertState();
        this.correlationId = correlationId;
    }

    public String getSecurityAssertionToken() {
        return this.saToken != null ? new String(this.saToken) : null;
    }

    protected void setSecurityAssertionToken(String token) {
        this.assertState();
        this.saToken = token != null ? token.getBytes() : null;
    }

    public byte[] getSecurityAssertionTokenAsBytes() {
        return this.saToken != null ? (byte[])this.saToken.clone() : null;
    }

    protected void setSecurityAssertionTokenAsBytes(byte[] token) {
        this.assertState();
        this.saToken = token;
    }

    protected void setReplyTo(String eventId) throws SDOFormatException {
        this.assertState();
        SDOUtils.validateEventId(eventId);
        this.eventReplyTo = eventId;
    }

    protected void resetReplyTo() {
        this.assertState();
        this.eventReplyTo = null;
    }

    public String getReplyTo() {
        return this.eventReplyTo;
    }

    protected void setForwardTo(String eventId) throws SecurityViolationException, SDOFormatException {
        this.assertState();
        this.assertTransmitAccess();
        SDOUtils.validateEventId(eventId);
        this.eventForwardTo = eventId;
    }

    public String getForwardTo() {
        return this.eventForwardTo;
    }

    @Override
    public Date getTimestamp() {
        return new Date(this.timeStamp);
    }

    public boolean isProtected() {
        return this.dataProtected[0] == 11;
    }

    protected synchronized void protect(String principal, byte[] credential, AccessControl ACL) throws SecurityViolationException, SDOException {
        this.assertState();
        if (this.dataProtected[0] == 11) {
            throw new SecurityViolationException(5024, "Event [" + this.eventId + "] is already protected.");
        }
        this.cloneMetadata();
        this.principal = principal;
        this.credential = credential;
        this.acl = ACL;
        this.dataProtected[0] = 11;
    }

    protected synchronized void unprotect(String principal, byte[] credential) throws SecurityViolationException, SDOException {
        this.assertState();
        if (this.dataProtected[0] != 71) {
            if (!this.principal.equals(principal)) {
                throw new SecurityViolationException(5025, "Principal '" + principal + "' is invalid.");
            }
            if (!Arrays.equals(this.credential, credential)) {
                throw new SecurityViolationException(5026, "Credential is invalid for principal '" + principal + "'.");
            }
            this.cloneMetadata();
            this.dataProtected[0] = 71;
        }
    }

    @Override
    public byte[] getEventSource() {
        return this.eventSource != null ? (byte[])this.eventSource.clone() : null;
    }

    protected void coalesce(FabricComponent source) throws SDOException, SDORuntimeException {
        this.coalesce(source.getFabricAddress());
    }

    protected synchronized void coalesce(FabricAddress sourceAddress) throws SDOException, SDORuntimeException {
        this.assertState();
        if (!this.isCoalescedAndReset()) {
            this.doCoalesce(sourceAddress);
        }
        this.coalesced = true;
    }

    protected void doCoalesce(FabricAddress sourceAddress) throws SDOException {
        if (this.isFinal) {
            this.removeInternalData();
        }
        this.isFinal = false;
        this.timeStamp = System.currentTimeMillis();
        this.eventSource = sourceAddress.toBinary();
    }

    protected boolean isCoalesced() {
        return this.coalesced;
    }

    protected boolean isCoalescedAndReset() {
        return this.timeStamp != 0L && this.eventSource != null;
    }

    protected void setFinal() {
        this.assertState();
        this.isFinal = true;
    }

    protected void removeInternalData() {
        this.eventAnnotations = null;
    }

    public AccessControl getPermissions() {
        return this.acl.clone();
    }

    public byte getReadAccess() {
        return this.acl.getReadAccess();
    }

    public byte getWriteAccess() {
        return this.acl.getWriteAccess();
    }

    @Override
    public byte getTransmitAccess() {
        return this.acl.getTransmitAccess();
    }

    protected void setDurable(boolean isDurable) {
        this.assertState();
        this.durable = isDurable;
    }

    @Override
    public boolean getDurable() {
        return this.durable;
    }

    protected synchronized void annotate() throws SDOException {
        this.assertState();
        if (!this.isCoalescedAndReset()) {
            this.doAnnotate();
        }
    }

    protected void doAnnotate() throws SDOException {
        try {
            if (this.eventAnnotations != null) {
                AnnotationManager annotationManager = FabricEventSourceFactory.getAnnotationManager();
                for (EventAnnotation annotation : this.eventAnnotations.values()) {
                    if (annotation.isValid()) {
                        Object value = annotationManager.getValueAtPath(annotation.getSDRPath(), this);
                        if (value == null) continue;
                        this.setAnnotatedProperty(annotation.getPropertyName(), value);
                        continue;
                    }
                    if (this.eventProperties == null || !EventPropertyValidator.isDefaultValue(this.eventProperties.get(annotation.getPropertyName()))) continue;
                    this.cloneMetadata();
                    this.eventProperties.remove(annotation.getPropertyName());
                }
            }
        }
        catch (SDOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new SDOException("Annotation of event [" + this.eventId + "] failed.", exception);
        }
    }

    protected void resolveAnnotations() {
        if (this.eventAnnotations != null) {
            for (EventAnnotation annotation : this.eventAnnotations.values()) {
                try {
                    PropertyType type = this.doGetPropertyType(annotation.getSDRPath());
                    annotation.setValid(true);
                }
                catch (SDOPropertyException exception) {
                    annotation.setValid(false);
                    Trace.logException(this, exception, false);
                    Trace.logError(this, "Annotation '" + annotation.getPropertyName() + "' is invalid" + this.inEventInfo());
                }
            }
        }
    }

    protected void invalidateAnnotations() {
        if (this.eventAnnotations != null) {
            for (EventAnnotation annotation : this.eventAnnotations.values()) {
                annotation.setValid(false);
            }
        }
    }

    protected void setEventObjectProperty(String propertyName, Object property) throws SDOException {
        if (property instanceof String) {
            this.setEventStringProperty(propertyName, (String)property);
        } else if (property instanceof Boolean || property instanceof Byte || property instanceof Short || property instanceof Integer || property instanceof Long || property instanceof Float || property instanceof Double || property instanceof BigDecimal) {
            this.setProperty(propertyName, property);
        } else {
            if (property == null) {
                throw new SDOFormatException("Null value of property '" + propertyName + "'" + this.inEventInfo());
            }
            throw new SDOFormatException("Invalid type of property '" + propertyName + "'" + this.inEventInfo());
        }
    }

    protected void setAnnotatedProperty(String name, Object value) throws SDOException {
        if (value instanceof String) {
            if (StringUtils.lengthUTF((String)value) - 2 > 65535) {
                throw new SDOFormatException("String property '" + name + "' too large" + this.inEventInfo());
            }
            this.doSetProperty(name, value);
        } else if (value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            this.doSetProperty(name, value);
        } else if (value instanceof BigInteger) {
            this.doSetProperty(name, new BigDecimal((BigInteger)value));
        } else if (value instanceof Enum) {
            this.doSetProperty(name, value.toString());
        } else {
            throw new SDOPropertyException("Invalid type of property '" + name + "'" + this.inEventInfo());
        }
    }

    public static boolean hasSuitableAnnotationType(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof BigInteger || value instanceof Enum;
    }

    public Object getEventObjectProperty(String propertyName) throws SDOException {
        this.checkPropertyName(propertyName);
        return this.eventProperties != null ? this.eventProperties.get(propertyName) : null;
    }

    public PropertyType getEventPropertyType(String propertyName) throws SDOException {
        Object propertyValue;
        this.checkPropertyName(propertyName);
        if (this.eventProperties != null && (propertyValue = this.getEventObjectProperty(propertyName)) != null) {
            return PropertyType.resolveType(propertyValue);
        }
        return null;
    }

    public boolean canConvertEventProperty(String propertyName, PropertyType propertyType) throws SDOException {
        this.checkPropertyName(propertyName);
        if (this.eventProperties != null) {
            try {
                EventPropertyValidator.checkValue(propertyType, this.getEventObjectProperty(propertyName));
                return true;
            }
            catch (SDOPropertyException exception) {
                return false;
            }
        }
        return false;
    }

    protected synchronized void removeEventProperty(String propertyName) throws SDOException {
        this.preparePropertyToChange(propertyName, "removed");
        if (this.eventProperties != null && this.eventProperties.containsKey(propertyName)) {
            if (this.isNormalEvent()) {
                throw new SDOPropertyException("Property '" + propertyName + "' cannot be removed" + this.fromEventInfo());
            }
            this.cloneMetadata();
            this.eventProperties.remove(propertyName);
        }
    }

    public boolean existsEventProperty(String propertyName) throws SDOException {
        this.checkPropertyName(propertyName);
        return this.eventProperties != null && this.eventProperties.containsKey(propertyName);
    }

    public Set<String> getEventPropertyNames() {
        return this.eventProperties != null ? new HashSet<String>(this.eventProperties.keySet()) : new HashSet();
    }

    protected void clearEventProperties() {
        this.assertState();
        this.eventProperties = null;
    }

    public boolean getEventBooleanProperty(String name) throws SDOException {
        return this.getProperty(name, Boolean.class);
    }

    public byte getEventByteProperty(String name) throws SDOException {
        return this.getProperty(name, Byte.class);
    }

    public short getEventShortProperty(String name) throws SDOException {
        return this.getProperty(name, Short.class);
    }

    public int getEventIntProperty(String name) throws SDOException {
        return this.getProperty(name, Integer.class);
    }

    public long getEventLongProperty(String name) throws SDOException {
        return this.getProperty(name, Long.class);
    }

    public float getEventFloatProperty(String name) throws SDOException {
        return this.getProperty(name, Float.class).floatValue();
    }

    public double getEventDoubleProperty(String name) throws SDOException {
        return this.getProperty(name, Double.class);
    }

    public BigDecimal getEventBigDecimalProperty(String name) throws SDOException {
        return this.getProperty(name, BigDecimal.class);
    }

    public String getEventStringProperty(String name) throws SDOException {
        return this.getProperty(name, String.class);
    }

    protected void setEventBooleanProperty(String name, boolean value) throws SDOException {
        this.setProperty(name, value);
    }

    protected void setEventByteProperty(String name, byte value) throws SDOException {
        this.setProperty(name, value);
    }

    protected void setEventShortProperty(String name, short value) throws SDOException {
        this.setProperty(name, value);
    }

    protected void setEventIntProperty(String name, int value) throws SDOException {
        this.setProperty(name, value);
    }

    protected void setEventLongProperty(String name, long value) throws SDOException {
        this.setProperty(name, value);
    }

    protected void setEventFloatProperty(String name, float value) throws SDOException {
        this.setProperty(name, Float.valueOf(value));
    }

    protected void setEventDoubleProperty(String name, double value) throws SDOException {
        this.setProperty(name, value);
    }

    protected void setEventBigDecimalProperty(String name, BigDecimal value) throws SDOException {
        this.setProperty(name, value);
    }

    protected void setEventBigDecimalProperty(String name, int precision, int scale) throws SDOException {
        this.preparePropertyToChange(name, "set");
        if (this.isNormalEvent()) {
            throw new SDOPropertyException("Event is not an event prototype.");
        }
        if (precision <= 0) {
            throw new SDOPropertyException("Precision must be a positive number.");
        }
        if (scale < 0) {
            throw new SDOPropertyException("Scale must not be a negative number.");
        }
        this.doSetProperty(name, EventPropertyValidator.makeBigDecimalTemplate(precision, scale));
    }

    protected synchronized void setEventStringProperty(String name, String value) throws SDOException {
        if (value == null) {
            throw new SDOFormatException("Null value of property '" + name + "'" + this.inEventInfo());
        }
        if (StringUtils.lengthUTF(value) - 2 > 65535) {
            throw new SDOFormatException("String property '" + name + "' too large" + this.inEventInfo());
        }
        Object preparedValue = this.preparePropertyToSet(name, value);
        this.doSetProperty(name, preparedValue);
    }

    protected synchronized void addAnnotation(String propertyName, String sdrPath) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.checkPropertyName(propertyName);
        if (sdrPath == null || sdrPath.length() == 0) {
            throw new SDOFormatException("Null or empty SDR path" + this.inEventInfo());
        }
        if (this.eventAnnotations != null && this.eventAnnotations.containsKey(propertyName)) {
            throw new SDOPropertyException("Annotated property '" + propertyName + "' already exists" + this.inEventInfo());
        }
        if ((this.eventProperties == null || !this.eventProperties.containsKey(propertyName)) && this.isNormalEvent()) {
            throw new SDOPropertyException("Property '" + propertyName + "' does not exist" + this.inEventInfo());
        }
        PropertyType propertyType = this.getPropertyType(sdrPath);
        this.checkEventAnnotationsExistence();
        this.eventAnnotations.put(propertyName, new EventAnnotation(propertyName, sdrPath));
        this.checkEventPropertiesExistence();
        this.doAddAnnotatedProperty(propertyName, propertyType, sdrPath);
    }

    protected void doAddAnnotatedProperty(String propertyName, PropertyType propertyType, String sdrPath) throws SDOPropertyException {
        Object value = null;
        if (propertyType != null) {
            value = this.eventProperties.get(propertyName);
            value = value != null ? EventPropertyValidator.checkValue(propertyType, value) : EventPropertyValidator.getDefaultValue(propertyType);
        }
        this.eventProperties.put(propertyName, value);
    }

    protected PropertyType getPropertyType(String sdrPath) throws SDOPropertyException {
        try {
            return this.doGetPropertyType(sdrPath);
        }
        catch (SDOPropertyException exception) {
            throw new SDOPropertyException(exception.getMessage(), exception.getCause());
        }
    }

    protected PropertyType doGetPropertyType(String sdrPath) throws SDOPropertyException {
        try {
            Class propertyClass = this.getPropertyClass(sdrPath);
            if (propertyClass.equals(Object.class)) {
                return null;
            }
            if (Enum.class.isAssignableFrom(propertyClass)) {
                return PropertyType.String;
            }
            return EventPropertyValidator.getPropertyType(propertyClass);
        }
        catch (Exception exception) {
            if (exception instanceof SDOPropertyException) {
                throw (SDOPropertyException)exception;
            }
            throw new SDOPropertyException(this.getInvalidSDRPathMessage(sdrPath), exception);
        }
    }

    protected Class getPropertyClass(String sdrPath) throws SDOPropertyException, TypeAnalyzerException {
        return TypeAnalyzerFactory.getInstance().createTypeAnalyzer().getFieldClass(this.getClass(), sdrPath);
    }

    protected String getInvalidSDRPathMessage(String sdrPath) throws SDOPropertyException {
        return "Invalid SDR path '" + sdrPath + "'.";
    }

    protected synchronized void removeAnnotation(String propertyName) throws SecurityViolationException, SDOException {
        this.assertState();
        this.assertWriteAccess();
        this.checkPropertyName(propertyName);
        if (this.eventAnnotations == null || !this.eventAnnotations.containsKey(propertyName)) {
            throw new SDOPropertyException("Annotated property '" + propertyName + "' does not exist" + this.inEventInfo());
        }
        if (this.eventProperties != null && this.eventProperties.containsKey(propertyName) && this.isNormalEvent()) {
            throw new SDOPropertyException("Property '" + propertyName + "' cannot be removed" + this.fromEventInfo());
        }
        this.cloneMetadata();
        this.eventAnnotations.remove(propertyName);
        if (this.eventProperties != null) {
            this.eventProperties.remove(propertyName);
        }
    }

    public Set<String> getAnnotatedProperties() throws SecurityViolationException {
        this.assertReadAccess();
        return this.eventAnnotations != null ? new HashSet<String>(this.eventAnnotations.keySet()) : new HashSet();
    }

    public boolean hasAnnotatedProperties() {
        return this.eventAnnotations != null && !this.eventAnnotations.isEmpty();
    }

    public EventAnnotation getAnnotation(String propertyName) throws SecurityViolationException, SDOException {
        this.assertReadAccess();
        this.checkPropertyName(propertyName);
        return this.eventAnnotations != null ? this.eventAnnotations.get(propertyName) : null;
    }

    protected void reset(boolean full) {
        this.coalesced = false;
        if (full) {
            this.timeStamp = 0L;
            this.eventSource = null;
        }
    }

    @Override
    public synchronized IAbstractDataEvent clone() {
        IAbstractDataEvent result = (IAbstractDataEvent)super.clone();
        if (this.metadataCounter == null) {
            result.metadataCounter = this.metadataCounter = new ReferenceCounter();
        }
        if (this.dataCounter == null) {
            result.dataCounter = this.dataCounter = new ReferenceCounter();
        }
        this.metadataCounter.increment();
        this.dataCounter.increment();
        return result;
    }

    protected synchronized void cloneMetadata() throws SDOException {
        if (this.metadataCounter != null && this.metadataCounter.getCounter() > 1L) {
            this.doCloneMetadata();
            this.metadataCounter.decrement();
            this.metadataCounter = null;
        }
    }

    private void doCloneMetadata() throws SDOException {
        this.dataProtected = this.dataProtected != null ? (byte[])this.dataProtected.clone() : null;
        this.eventProperties = this.eventProperties != null ? (HashMap)this.eventProperties.clone() : null;
        this.eventAnnotations = this.eventAnnotations != null ? (HashMap)this.eventAnnotations.clone() : null;
    }

    protected synchronized void cloneData() throws SDOException {
        if (this.dataCounter != null && this.dataCounter.getCounter() > 1L) {
            this.doCloneData();
            this.dataCounter.decrement();
            this.dataCounter = null;
        }
    }

    protected void cloneDataSafe() {
        try {
            this.cloneData();
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void doCloneData() throws SDOException {
        this.doCloneReturnData();
    }

    protected synchronized void cloneReturnData() throws SDOException {
        if (this.isProtected()) {
            if (this.getWriteAccess() == 37) {
                this.cloneData();
            } else {
                this.doCloneReturnData();
            }
        } else {
            this.cloneData();
        }
    }

    protected void cloneReturnDataSafe() {
        try {
            this.cloneReturnData();
        }
        catch (SDOException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected void doCloneReturnData() throws SDOException {
    }

    protected synchronized void resetDataCounter() {
        if (this.dataCounter != null && this.dataCounter.getCounter() > 1L) {
            this.dataCounter.decrement();
            this.dataCounter = null;
        }
    }

    protected void checkEventPropertiesExistence() throws SDOException {
        if (this.eventProperties == null) {
            this.eventProperties = new HashMap();
        } else {
            this.cloneMetadata();
        }
    }

    protected void checkEventAnnotationsExistence() throws SDOException {
        if (this.eventAnnotations == null) {
            this.eventAnnotations = new HashMap();
        } else {
            this.cloneMetadata();
        }
    }

    protected HashMap<String, EventAnnotation> getAnnotations() {
        return this.eventAnnotations;
    }

    protected void addAnnotationSafe(String propertyName, String sdrPath) throws SecurityViolationException, SDOException {
        if (this.eventAnnotations == null || !this.eventAnnotations.containsKey(propertyName)) {
            this.addAnnotation(propertyName, sdrPath);
        }
    }

    protected <T> T getProperty(String name, Class<T> type) throws SDOException {
        try {
            return EventPropertyValidator.checkValue(type, this.getEventObjectProperty(name));
        }
        catch (SDOPropertyException exception) {
            throw new SDOPropertyException("Invalid data type of property '" + name + "'" + this.inEventInfo(), exception);
        }
    }

    protected synchronized void setProperty(String name, Object value) throws SDOException {
        value = this.preparePropertyToSet(name, value);
        this.doSetProperty(name, value);
    }

    protected void preparePropertyToChange(String name, String operation) throws SDOException {
        this.assertState();
        this.checkPropertyName(name);
        if (this.eventAnnotations != null && this.eventAnnotations.containsKey(name)) {
            throw new SDOPropertyException("Annotated property '" + name + "' cannot be " + operation + " directly" + this.inEventInfo());
        }
    }

    protected Object preparePropertyToSet(String name, Object value) throws SDOException {
        this.preparePropertyToChange(name, "set");
        if (this.eventProperties != null && this.eventProperties.containsKey(name)) {
            Object oldValue = this.eventProperties.get(name);
            if (oldValue != null && !oldValue.getClass().equals(value.getClass())) {
                try {
                    return EventPropertyValidator.checkValue(PropertyType.resolveType(oldValue), value);
                }
                catch (SDOPropertyException exception) {
                    throw new SDOPropertyException("Invalid data type for property '" + name + "'" + this.inEventInfo());
                }
            }
        } else if (this.isNormalEvent()) {
            throw new SDOPropertyException("Property '" + name + "' does not exist" + this.inEventInfo());
        }
        return value;
    }

    protected void checkPropertyName(String name) throws SDOException {
        if (name == null || name.length() == 0) {
            throw new SDOFormatException("Invalid property name '" + name + "'" + this.inEventInfo());
        }
    }

    protected synchronized void doSetProperty(String name, Object value) throws SDOException {
        this.checkEventPropertiesExistence();
        this.eventProperties.put(name, this.updatePropertyValue(name, value));
    }

    Object updatePropertyValue(String name, Object value) {
        if (value instanceof BigDecimal && this.isNormalEvent()) {
            return this.updateBigDecimalPropertyValue(value, this.eventProperties.get(name));
        }
        return value;
    }

    private Object updateBigDecimalPropertyValue(Object value, Object oldValue) {
        if (value instanceof BigDecimal && this.isNormalEvent() && oldValue instanceof BigDecimal) {
            BigDecimal mask = (BigDecimal)oldValue;
            value = new BigDecimal(((BigDecimal)value).toPlainString(), new MathContext(EventPropertyValidator.getBigDecimalPrecision(mask))).setScale(mask.scale(), RoundingMode.HALF_UP);
        }
        return value;
    }

    protected boolean isNormalEvent() {
        return this.eventId != null && !this.eventId.startsWith("e.reply.") && !this.eventId.startsWith("e.sys.reply.");
    }

    protected long getTimeStamp() {
        return this.timeStamp;
    }

    protected void setTimeStamp(long timeStamp) {
        this.assertState();
        this.timeStamp = timeStamp;
    }

    protected void setEventExpiration(long expiration) {
        this.assertState();
        this.eventExpiration = expiration;
    }

    public long getEventExpiration() {
        return this.eventExpiration;
    }

    protected abstract Object getAcknowledgementData() throws SecurityViolationException, SDOException;

    protected String inEventInfo() {
        return this.inEventInfo(true);
    }

    protected String inEventInfo(boolean withDot) {
        return this.eventId != null ? " in event [" + this.eventId + "]." : (withDot ? "." : "");
    }

    protected String fromEventInfo() {
        return this.eventId != null ? " from event [" + this.eventId + "]." : ".";
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof IAbstractDataEvent && super.equals(other)) {
            IAbstractDataEvent otherEvent = (IAbstractDataEvent)other;
            return Arrays.equals(this.eventSource, otherEvent.eventSource) && Utils.equalsNullSafe(this.eventId, otherEvent.eventId) && this.durable == otherEvent.durable && Utils.equalsNullSafe(this.eventKey, otherEvent.eventKey) && Utils.equalsNullSafe(this.eventGroupId, otherEvent.eventGroupId) && Arrays.equals(this.correlationId, otherEvent.correlationId) && Arrays.equals(this.saToken, otherEvent.saToken) && Utils.equalsNullSafe(this.eventReplyTo, otherEvent.eventReplyTo) && Utils.equalsNullSafe(this.eventForwardTo, otherEvent.eventForwardTo) && this.timeStamp == otherEvent.timeStamp && this.eventExpiration == otherEvent.eventExpiration && Arrays.equals(this.dataProtected, otherEvent.dataProtected) && Utils.equalsNullSafe(this.principal, otherEvent.principal) && Arrays.equals(this.credential, otherEvent.credential) && Utils.equalsNullSafe(this.acl, otherEvent.acl) && this.coalesced == otherEvent.coalesced && this.equalsEventProperties(otherEvent.eventProperties) && this.equalsEventAnnotations(otherEvent.eventAnnotations);
        }
        return false;
    }

    protected boolean equalsEventProperties(HashMap<String, Object> otherEventProperties) {
        return this.eventProperties == otherEventProperties || this.eventProperties != null && otherEventProperties != null && this.eventProperties.size() == otherEventProperties.size() && this.eventProperties.entrySet().stream().allMatch(entry -> Utils.equalsNullSafe(entry.getValue(), otherEventProperties.get(entry.getKey())));
    }

    protected boolean equalsEventAnnotations(HashMap<String, EventAnnotation> otherEventAnnotations) {
        return this.eventAnnotations == otherEventAnnotations || this.eventAnnotations != null && otherEventAnnotations != null && this.eventAnnotations.size() == otherEventAnnotations.size() && this.eventAnnotations.entrySet().stream().allMatch(entry -> Utils.equalsNullSafe(entry.getValue(), otherEventAnnotations.get(entry.getKey())));
    }

    private HashMap<String, Object> getEventProperties() {
        return this.eventProperties;
    }

    private void setEventProperties(HashMap<String, Object> eventProperties) {
        if (eventProperties != null && eventProperties.size() > 0) {
            EventDatagram event = null;
            try {
                if (this.eventId != null && AbstractFabricContextFactory.hasContext()) {
                    event = EventDatagramFactory.getInstance().createEvent(this.eventId);
                }
            }
            catch (DatagramFactoryException datagramFactoryException) {
                // empty catch block
            }
            if (event != null) {
                for (Map.Entry<String, Object> entry : eventProperties.entrySet()) {
                    Object value = entry.getValue();
                    if (value != null) {
                        try {
                            PropertyType propertyType = event.getEventPropertyType(entry.getKey());
                            value = TypeFactory.convertPropertyValue(propertyType, value);
                            if (value instanceof BigDecimal) {
                                value = this.updateBigDecimalPropertyValue(value, event.getEventObjectProperty(entry.getKey()));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.eventProperties == null) {
                        this.eventProperties = new HashMap();
                    }
                    this.eventProperties.put(entry.getKey(), value);
                }
            } else {
                this.eventProperties = eventProperties;
            }
        } else {
            this.eventProperties = eventProperties;
        }
    }
}

