/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.sdo.AnnotationManager;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.IAbstractEvent;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SDORuntimeException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.exchange.FabricAddress;

public class FabricEventSourceFactory
extends AbstractFabricContextFactory {
    protected static ImmutableEventDatagram coalesce(ImmutableEventDatagram event, FabricComponent component) throws FabricEventSourceException {
        return FabricEventSourceFactory.coalesce(event, component.getFabricAddress());
    }

    protected static ImmutableEventDatagram coalesce(ImmutableEventDatagram event, FabricAddress componentAddress) throws FabricEventSourceException {
        try {
            if (event instanceof IAbstractDataEvent) {
                ((IAbstractDataEvent)event).annotate();
                ((IAbstractDataEvent)event).coalesce(componentAddress);
                return event;
            }
            if (event instanceof IAbstractEvent) {
                ((IAbstractEvent)event).coalesce(componentAddress);
                return event;
            }
            if (event instanceof IAbstractExceptionEvent) {
                ((IAbstractExceptionEvent)event).coalesce(componentAddress);
                return event;
            }
        }
        catch (SDORuntimeException exception) {
            throw new FabricEventSourceException(5010, exception.getMessage());
        }
        catch (Exception exception) {
            throw new FabricEventSourceException(5011, "Annotation of event [" + event.getEventId() + "] failed.", exception);
        }
        throw new FabricEventSourceException(5009, ErrorMessages.format("Unsupported datagram '%1$s'.", event.getClass().getName()));
    }

    protected static boolean isCoalesced(ImmutableEventDatagram event) throws FabricEventSourceException {
        if (event instanceof IAbstractDataEvent) {
            return ((IAbstractDataEvent)event).isCoalesced();
        }
        if (event instanceof IAbstractEvent) {
            return ((IAbstractEvent)event).isCoalesced();
        }
        if (event instanceof IAbstractExceptionEvent) {
            return ((IAbstractExceptionEvent)event).isCoalesced();
        }
        throw new FabricEventSourceException(5009, ErrorMessages.format("Unsupported datagram '%1$s'.", event.getClass().getName()));
    }

    protected static void setSourceData(ImmutableEventDatagram sourceEvent, AcknowledgementEvent ackEvent) throws SecurityViolationException, SDOException, FabricEventSourceException {
        if (sourceEvent instanceof IAbstractDataEvent) {
            ackEvent.setData(((IAbstractDataEvent)sourceEvent).getAcknowledgementData());
        } else if (sourceEvent instanceof IAbstractEvent) {
            ackEvent.setData(((IAbstractEvent)sourceEvent).getDataForAcknowledgement());
        } else {
            throw new FabricEventSourceException(5009, ErrorMessages.format("Unsupported datagram '%1$s'.", sourceEvent.getClass().getName()));
        }
    }

    protected static AnnotationManager getAnnotationManager() {
        return FabricEventSourceFactory.getContext().getAnnotationManager();
    }

    protected static void setEventId(ImmutableEventDatagram event, String eventId) throws SDOFormatException, FabricEventSourceException {
        if (event instanceof IAbstractDataEvent) {
            ((IAbstractDataEvent)event).setEventId(eventId);
        } else if (event instanceof IAbstractEvent) {
            ((IAbstractEvent)event).setEventId(eventId);
        } else if (event instanceof IAbstractExceptionEvent) {
            ((IAbstractExceptionEvent)event).setEventId(eventId);
        } else {
            throw new FabricEventSourceException(5009, ErrorMessages.format("Unsupported datagram '%1$s'.", event.getClass().getName()));
        }
    }

    protected static void resolveAnnotations(ImmutableEventDatagram event) {
        if (event instanceof IAbstractDataEvent) {
            ((IAbstractDataEvent)event).resolveAnnotations();
        }
    }
}

