/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.enums.PropertyType;
import java.math.BigDecimal;

public class EventPropertyValidator {
    public static <T> T checkValue(Class<T> propertyClass, Object propertyValue) throws SDOPropertyException {
        return (T)EventPropertyValidator.checkValue(EventPropertyValidator.getPropertyType(propertyClass), propertyValue);
    }

    public static Object checkValue(PropertyType propertyType, Object propertyValue) throws SDOPropertyException {
        switch (propertyType) {
            case Boolean: {
                return EventPropertyValidator.checkBooleanValue(propertyValue);
            }
            case Byte: {
                return EventPropertyValidator.checkByteValue(propertyValue);
            }
            case Short: {
                return EventPropertyValidator.checkShortValue(propertyValue);
            }
            case Integer: {
                return EventPropertyValidator.checkIntValue(propertyValue);
            }
            case Long: {
                return EventPropertyValidator.checkLongValue(propertyValue);
            }
            case Float: {
                return Float.valueOf(EventPropertyValidator.checkFloatValue(propertyValue));
            }
            case Double: {
                return EventPropertyValidator.checkDoubleValue(propertyValue);
            }
            case BigDecimal: {
                return EventPropertyValidator.checkBigDecimalValue(propertyValue);
            }
            case String: {
                return EventPropertyValidator.checkStringValue(propertyValue);
            }
        }
        throw new RuntimeException("Invalid PropertyType!");
    }

    public static boolean checkBooleanValue(Object propertyValue) throws SDOPropertyException {
        if (propertyValue == null) {
            throw new SDOPropertyException("Boolean property is null.");
        }
        if (propertyValue instanceof Boolean) {
            return (Boolean)propertyValue;
        }
        if (propertyValue instanceof String) {
            if (propertyValue.toString().equalsIgnoreCase("true")) {
                return true;
            }
            if (propertyValue.toString().equalsIgnoreCase("false")) {
                return false;
            }
        }
        throw new SDOPropertyException("Property is not a valid Boolean.");
    }

    public static byte checkByteValue(Object propertyValue) throws SDOPropertyException {
        try {
            if (propertyValue == null) {
                throw new SDOPropertyException("Byte property is null.");
            }
            if (propertyValue instanceof Byte) {
                return (Byte)propertyValue;
            }
            if (propertyValue instanceof String) {
                return Byte.parseByte(propertyValue.toString());
            }
        }
        catch (NumberFormatException exception) {
            throw new SDOPropertyException("Property is not a valid Byte.");
        }
        throw new SDOPropertyException("Property is not a valid Byte.");
    }

    public static short checkShortValue(Object propertyValue) throws SDOPropertyException {
        try {
            if (propertyValue == null) {
                throw new SDOPropertyException("Short property is null.");
            }
            if (propertyValue instanceof Short || propertyValue instanceof Byte) {
                return ((Number)propertyValue).shortValue();
            }
            if (propertyValue instanceof String) {
                return Short.parseShort(propertyValue.toString());
            }
        }
        catch (NumberFormatException exception) {
            throw new SDOPropertyException("Property is not a valid Short.");
        }
        throw new SDOPropertyException("Property is not a valid Short.");
    }

    public static int checkIntValue(Object propertyValue) throws SDOPropertyException {
        try {
            if (propertyValue == null) {
                throw new SDOPropertyException("Integer property is null.");
            }
            if (propertyValue instanceof Integer || propertyValue instanceof Short || propertyValue instanceof Byte) {
                return ((Number)propertyValue).intValue();
            }
            if (propertyValue instanceof String) {
                return Integer.parseInt(propertyValue.toString());
            }
        }
        catch (NumberFormatException exception) {
            throw new SDOPropertyException("Property is not a valid Integer.");
        }
        throw new SDOPropertyException("Property is not a valid Integer.");
    }

    public static long checkLongValue(Object propertyValue) throws SDOPropertyException {
        try {
            if (propertyValue == null) {
                throw new SDOPropertyException("Long property is null.");
            }
            if (propertyValue instanceof Long || propertyValue instanceof Integer || propertyValue instanceof Short || propertyValue instanceof Byte) {
                return ((Number)propertyValue).longValue();
            }
            if (propertyValue instanceof String) {
                return Long.parseLong(propertyValue.toString());
            }
        }
        catch (NumberFormatException exception) {
            throw new SDOPropertyException("Property is not a valid Long.");
        }
        throw new SDOPropertyException("Property is not a valid Long.");
    }

    public static float checkFloatValue(Object propertyValue) throws SDOPropertyException {
        try {
            float result;
            if (propertyValue == null) {
                throw new SDOPropertyException("Float property is null.");
            }
            if (propertyValue instanceof Float) {
                return ((Number)propertyValue).floatValue();
            }
            if (propertyValue instanceof String && (result = Float.parseFloat(propertyValue.toString())) != Float.POSITIVE_INFINITY && result != Float.NEGATIVE_INFINITY) {
                return result;
            }
        }
        catch (NumberFormatException exception) {
            throw new SDOPropertyException("Property is not a valid Float.");
        }
        throw new SDOPropertyException("Property is not a valid Float.");
    }

    public static double checkDoubleValue(Object propertyValue) throws SDOPropertyException {
        try {
            double result;
            if (propertyValue == null) {
                throw new SDOPropertyException("Double property is null.");
            }
            if (propertyValue instanceof Double || propertyValue instanceof Float) {
                return ((Number)propertyValue).doubleValue();
            }
            if (propertyValue instanceof String && (result = Double.parseDouble(propertyValue.toString())) != Double.POSITIVE_INFINITY && result != Double.NEGATIVE_INFINITY) {
                return result;
            }
        }
        catch (NumberFormatException exception) {
            throw new SDOPropertyException("Property is not a valid Double.");
        }
        throw new SDOPropertyException("Property is not a valid Double.");
    }

    public static BigDecimal checkBigDecimalValue(Object propertyValue) throws SDOPropertyException {
        try {
            if (propertyValue == null) {
                throw new SDOPropertyException("BigDecimal property is null.");
            }
            if (propertyValue instanceof BigDecimal) {
                return (BigDecimal)propertyValue;
            }
            if (propertyValue instanceof Double) {
                return BigDecimal.valueOf((Double)propertyValue);
            }
            if (propertyValue instanceof Float) {
                return BigDecimal.valueOf(((Float)propertyValue).floatValue());
            }
            if (propertyValue instanceof Long || propertyValue instanceof Integer || propertyValue instanceof Short || propertyValue instanceof Byte) {
                return new BigDecimal(((Number)propertyValue).longValue());
            }
            if (propertyValue instanceof String) {
                return new BigDecimal(propertyValue.toString());
            }
        }
        catch (NumberFormatException exception) {
            throw new SDOPropertyException("Property is not a valid BigDecimal.");
        }
        throw new SDOPropertyException("Property is not a valid BigDecimal.");
    }

    public static String checkStringValue(Object propertyValue) throws SDOPropertyException {
        if (propertyValue == null) {
            throw new SDOPropertyException("String property is null.");
        }
        if (propertyValue instanceof String) {
            return (String)propertyValue;
        }
        if (propertyValue instanceof Boolean) {
            return propertyValue.toString();
        }
        if (propertyValue instanceof Number) {
            return propertyValue.toString();
        }
        throw new SDOPropertyException("Property is not a valid String.");
    }

    public static <T> T getDefaultValue(Class<T> propertyClass) throws SDOPropertyException {
        return (T)EventPropertyValidator.getDefaultValue(EventPropertyValidator.getPropertyType(propertyClass));
    }

    public static Object getDefaultValue(PropertyType propertyType) {
        switch (propertyType) {
            case Boolean: {
                return false;
            }
            case Byte: {
                return (byte)0;
            }
            case Short: {
                return (short)0;
            }
            case Integer: {
                return 0;
            }
            case Long: {
                return 0L;
            }
            case Float: {
                return Float.valueOf(0.0f);
            }
            case Double: {
                return 0.0;
            }
            case BigDecimal: {
                return new BigDecimal(0);
            }
            case String: {
                return "";
            }
        }
        throw new RuntimeException("Invalid PropertyType!");
    }

    static boolean isDefaultValue(Object propertyValue) {
        if (propertyValue != null) {
            PropertyType type = PropertyType.resolveType(propertyValue);
            return type != null && propertyValue.equals(EventPropertyValidator.getDefaultValue(type));
        }
        return false;
    }

    static PropertyType getPropertyType(Class propertyClass) throws SDOPropertyException {
        PropertyType propertyType = PropertyType.resolveType(propertyClass);
        if (propertyType == null) {
            throw new SDOPropertyException("Invalid property class '" + propertyClass.getName() + "'.");
        }
        return propertyType;
    }

    public static int getBigDecimalPrecision(EventDatagram datagram, String propertyName) throws SDOException {
        return EventPropertyValidator.getBigDecimalPrecision(datagram.getEventObjectProperty(propertyName));
    }

    public static int getBigDecimalPrecision(Object value) {
        return EventPropertyValidator.isBigDecimalTemplate(value) ? ((BigDecimal)value).precision() : 128;
    }

    public static int getBigDecimalScale(EventDatagram datagram, String propertyName) throws SDOException {
        return EventPropertyValidator.getBigDecimalScale(datagram.getEventObjectProperty(propertyName));
    }

    public static int getBigDecimalScale(Object value) {
        return EventPropertyValidator.isBigDecimalTemplate(value) ? ((BigDecimal)value).scale() : 0;
    }

    static boolean isBigDecimalTemplate(Object value) {
        return value instanceof BigDecimal && ((BigDecimal)value).signum() != 0;
    }

    public static BigDecimal makeBigDecimalTemplate(int precision, int scale) {
        if (precision < 0 || scale < 0 || precision == 0 && scale == 0 || precision == 128 && scale == 0) {
            return new BigDecimal(0);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("-");
        while (precision-- - scale > 0) {
            builder.append("9");
        }
        builder.append(".");
        while (scale-- > 0) {
            builder.append("9");
        }
        return new BigDecimal(builder.toString());
    }
}

