/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.sdo.EventPropertyValidator;
import com.streamscape.sdo.SDOPropertyException;
import com.streamscape.sdo.enums.PropertyType;

public class EventProperty {
    private String propertyName = "";
    private String propertyType = PropertyType.String.name();
    private Object propertyValue = null;

    public EventProperty() {
    }

    public EventProperty(String name, PropertyType type) {
        this.propertyName = name;
        this.setType(type);
    }

    public void setName(String name) {
        this.propertyName = name;
    }

    public String getName() {
        return this.propertyName;
    }

    public void setType(PropertyType type) {
        this.propertyType = type.name();
    }

    public PropertyType getType() {
        return PropertyType.valueOf(this.propertyType);
    }

    public void setValue(Object value) throws SDOPropertyException {
        switch (this.getType()) {
            case Boolean: {
                this.propertyValue = EventPropertyValidator.checkBooleanValue(value);
                break;
            }
            case Byte: {
                this.propertyValue = EventPropertyValidator.checkByteValue(value);
                break;
            }
            case Double: {
                this.propertyValue = EventPropertyValidator.checkDoubleValue(value);
                break;
            }
            case Float: {
                this.propertyValue = Float.valueOf(EventPropertyValidator.checkFloatValue(value));
                break;
            }
            case Integer: {
                this.propertyValue = EventPropertyValidator.checkIntValue(value);
                break;
            }
            case Long: {
                this.propertyValue = EventPropertyValidator.checkLongValue(value);
                break;
            }
            case Short: {
                this.propertyValue = EventPropertyValidator.checkShortValue(value);
                break;
            }
            case String: {
                this.propertyValue = EventPropertyValidator.checkStringValue(value);
                break;
            }
            default: {
                throw new SDOPropertyException("Invalid property object.");
            }
        }
    }

    public Object getValue() {
        return this.propertyValue;
    }
}

