/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.filter.FilterUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.PayloadEvent;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.dispatcher.AbstractDatagramPrototypeCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class DatagramPrototypeCacheImpl
extends AbstractDatagramPrototypeCache
implements DatagramPrototypeCache {
    DatagramPrototypeCacheImpl(SemanticTypeCache typeCache) {
        super(typeCache);
    }

    @Override
    protected void addPrototype(DatagramFactory factory, Prototype prototype, ImmutableEventDatagram event) throws DatagramFactoryException {
        super.addPrototype(factory, prototype, event);
    }

    @Override
    protected void removePrototype(Prototype prototype) throws DatagramFactoryException {
        super.removePrototype(prototype);
    }

    @Override
    public boolean existsPrototype(Prototype prototype) {
        return this.prototypes.containsKey(prototype);
    }

    @Override
    public boolean existsEventId(String eventId) {
        return this.eventIds.containsKey(eventId);
    }

    @Override
    public List<Prototype> getPrototypesByDataType(SemanticType type) {
        return this.doFilterPrototypesByDataType(type).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public List<String> listEventIdsByDataType(SemanticType type) {
        return this.doFilterPrototypesByDataType(type).map(entry -> ((ImmutableEventDatagram)entry.getValue()).getEventId()).collect(Collectors.toList());
    }

    @Override
    protected void getPrototypesByDataType(SemanticType type, Map<Prototype, ImmutableEventDatagram> result) {
        this.doFilterPrototypesByDataType(type).forEach(entry -> result.put((Prototype)entry.getKey(), (ImmutableEventDatagram)entry.getValue()));
    }

    protected Stream<Map.Entry<Prototype, ImmutableEventDatagram>> doFilterPrototypesByDataType(SemanticType type) {
        return this.prototypes.entrySet().stream().filter(entry -> {
            String dataType = this.getDataType((Prototype)entry.getKey(), (ImmutableEventDatagram)entry.getValue());
            return dataType != null && type.getTypeName().equals(dataType);
        });
    }

    protected List<Prototype> getPrototypesByAncestor(String ancestorName) {
        return this.getPrototypesByAncestor(ancestorName, true);
    }

    @Override
    public List<Prototype> getPrototypesByAncestor(String ancestor, boolean includeModels) {
        return this.ancestors.keySet().stream().filter(prototype -> ((String)this.ancestors.get(prototype)).equals(ancestor) && (includeModels || !prototype.getModelName().equals(prototype.getInstanceName()))).collect(Collectors.toList());
    }

    @Override
    public String getAncestor(Prototype prototype) throws DatagramFactoryException {
        if (!this.ancestors.containsKey(prototype)) {
            throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", prototype.toString()));
        }
        return this.doGetAncestor(prototype);
    }

    protected String doGetAncestor(Prototype prototype) {
        return (String)this.ancestors.get(prototype);
    }

    @Override
    public String getAncestor(String eventId) throws DatagramFactoryException {
        Prototype prototype = this.lookupPrototype(eventId);
        if (prototype == null) {
            throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", eventId));
        }
        return this.getAncestor(prototype);
    }

    @Override
    public String getModel(String eventId) throws DatagramFactoryException {
        Prototype prototype = this.lookupPrototype(eventId);
        if (prototype == null) {
            throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", eventId));
        }
        return prototype.getModelName();
    }

    @Override
    public String lookupEventId(Prototype prototype) {
        ImmutableEventDatagram event = (ImmutableEventDatagram)this.prototypes.get(prototype);
        return event != null ? event.getEventId() : null;
    }

    @Override
    public Prototype lookupPrototype(String eventId) {
        return this.doLookupPrototype(eventId);
    }

    Prototype doLookupPrototype(String eventId) {
        return (Prototype)this.eventIds.get(eventId);
    }

    Prototype doLookupPrototype(Prototype prototype) {
        ImmutableEventDatagram event = (ImmutableEventDatagram)this.prototypes.get(prototype);
        return event != null ? this.doLookupPrototype(event.getEventId()) : null;
    }

    @Override
    public List<Prototype> getPrototypes() {
        ArrayList<Prototype> result = new ArrayList<Prototype>(this.prototypes.size());
        result.addAll(this.prototypes.keySet());
        return result;
    }

    @Override
    public List<String> listEventIds() {
        ArrayList<String> result = new ArrayList<String>(this.eventIds.keySet());
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> listEventIdsByAncestor(String ancestor) {
        return this.ancestors.keySet().stream().filter(prototype -> ((String)this.ancestors.get(prototype)).equals(ancestor)).map(prototype -> ((ImmutableEventDatagram)this.prototypes.get(prototype)).getEventId()).sorted().collect(Collectors.toList());
    }

    @Override
    public List<String> listEventIdsByFilter(Filter filter) {
        ArrayList<String> result = new ArrayList<String>();
        if (!filter.hasMetacharacters() && this.eventIds.containsKey(filter.toString())) {
            result.add(filter.toString());
        } else {
            result = this.eventIds.keySet().stream().filter(eventId -> FilterUtils.matches(eventId, filter)).sorted().collect(Collectors.toList());
        }
        return result;
    }

    ImmutableEventDatagram getEventPrototype(Prototype prototype) throws DatagramFactoryException {
        ImmutableEventDatagram result = (ImmutableEventDatagram)this.prototypes.get(prototype);
        if (result != null) {
            try {
                return (ImmutableEventDatagram)SDOUtils.clone(result);
            }
            catch (SDOException exception) {
                throw new DatagramFactoryException(5037, "Cloning of event prototype [" + result.getEventId() + "] failed.", exception);
            }
        }
        throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", prototype.toString()));
    }

    ImmutableEventDatagram getEventPrototype(String eventId) throws DatagramFactoryException {
        Prototype prototype = (Prototype)this.eventIds.get(eventId);
        if (prototype != null) {
            return this.getEventPrototype(prototype);
        }
        throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", eventId));
    }

    Pair<Prototype, ImmutableEventDatagram> getPrototype(String eventId) throws DatagramFactoryException {
        Prototype prototype = (Prototype)this.eventIds.get(eventId);
        if (prototype != null) {
            return new Pair<Prototype, ImmutableEventDatagram>(prototype, this.getEventPrototype(prototype));
        }
        throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", eventId));
    }

    @Override
    protected String getDataType(Prototype prototype, ImmutableEventDatagram event) {
        return super.getDataType(prototype, event);
    }

    @Override
    protected List<Pair<Prototype, ImmutableEventDatagram>> checkEventPrototypes(SemanticType dataType) {
        ArrayList<Pair<Prototype, ImmutableEventDatagram>> result = new ArrayList<Pair<Prototype, ImmutableEventDatagram>>();
        for (Map.Entry entry : this.prototypes.entrySet()) {
            EventDatagramFactory factory;
            String eventDataType;
            if (!(entry.getValue() instanceof PayloadEvent)) continue;
            PayloadEvent event = (PayloadEvent)entry.getValue();
            String string = eventDataType = event.getPayloadClass() != null ? this.semanticTypeCache.resolveSemanticClass(event.getPayloadClass()) : ((Prototype)entry.getKey()).getPayloadType();
            IAbstractDatagramFactory iAbstractDatagramFactory = event instanceof DataEvent || event instanceof DeltaEvent ? EventDatagramFactory.getInstance() : (factory = event instanceof OpaqueEvent ? OpaqueDatagramFactory.getInstance() : null);
            if (eventDataType == null || !dataType.getTypeName().equals(eventDataType)) continue;
            Pair<Prototype, ImmutableEventDatagram> validatedPrototype = factory.checkEventPrototype(dataType, (Prototype)entry.getKey(), (ImmutableEventDatagram)entry.getValue());
            if (validatedPrototype.second != null) {
                entry.setValue((ImmutableEventDatagram)validatedPrototype.second);
            }
            result.add(validatedPrototype);
        }
        return result;
    }

    void clear() {
        this.eventIds.clear();
        this.prototypes.clear();
    }
}

