/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.event.AbstractEventOperation;
import com.streamscape.sdo.DatagramPrototypeCacheImpl;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.AdvisoryDatagramFactory;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.excp.ExceptionDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.DatagramFactoryManager;
import com.streamscape.sef.FabricException;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractEventPrototypeOperation
extends AbstractEventOperation {
    protected AbstractEventPrototypeOperation() {
    }

    protected AbstractEventPrototypeOperation(boolean isAdministrative) {
        super(isAdministrative);
    }

    protected PrototypeModel checkModel(Prototype prototype) throws Exception {
        PrototypeModel result = null;
        String ancestor = ((RuntimeContext)this.callable).getDatagramPrototypeCache().getAncestor(prototype);
        if (ancestor.equals("advisory")) {
            result = PrototypeModel.ADVISORY;
        } else if (ancestor.equals("exception")) {
            result = PrototypeModel.EXCEPTION;
        } else if (ancestor.equals("opaque")) {
            result = PrototypeModel.OPAQUE_EVENT;
        } else if (ancestor.equals("datagram")) {
            result = this.getEventPrototypeModel(prototype.getModelName());
        }
        return this.checkResultModel(result, prototype.getModelName());
    }

    protected PrototypeModel checkModel(String model) throws Exception {
        PrototypeModel result = null;
        DatagramFactoryManager factoryManager = ((RuntimeContext)this.callable).getDatagramFactoryManager();
        for (String factoryName : factoryManager.listDatagramFactories()) {
            DatagramFactory factory = factoryManager.lookupDatagramFactory(factoryName);
            if (!factory.supportsModel(model)) continue;
            if (factory instanceof AdvisoryDatagramFactory) {
                result = PrototypeModel.ADVISORY;
                break;
            }
            if (factory instanceof ExceptionDatagramFactory) {
                result = PrototypeModel.EXCEPTION;
                break;
            }
            if (factory instanceof OpaqueDatagramFactory) {
                result = PrototypeModel.OPAQUE_EVENT;
                break;
            }
            if (!(factory instanceof EventDatagramFactory)) break;
            result = this.getEventPrototypeModel(model);
            break;
        }
        return this.checkResultModel(result, model);
    }

    private PrototypeModel getEventPrototypeModel(String model) {
        if (model.equals("DataEvent")) {
            return PrototypeModel.DATA_EVENT;
        }
        if (model.equals("DeltaEvent")) {
            return PrototypeModel.DELTA_EVENT;
        }
        if (model.startsWith("Row")) {
            return PrototypeModel.ROW_EVENT;
        }
        return PrototypeModel.EVENT;
    }

    private PrototypeModel checkResultModel(PrototypeModel result, String model) throws Exception {
        if (result == null) {
            throw new FabricException("Model '" + model + "' is not supported.");
        }
        return result;
    }

    protected boolean needSemanticType(PrototypeModel model) {
        return model == PrototypeModel.DATA_EVENT || model == PrototypeModel.DELTA_EVENT || model == PrototypeModel.OPAQUE_EVENT;
    }

    protected Pair<Prototype, ImmutableEventDatagram> getPrototype(String eventId) throws DatagramFactoryException {
        return ((DatagramPrototypeCacheImpl)((RuntimeContext)this.callable).getDatagramPrototypeCache()).getPrototype(eventId);
    }

    protected ImmutableEventDatagram getEventPrototype(String eventId) throws DatagramFactoryException {
        return ((DatagramPrototypeCacheImpl)((RuntimeContext)this.callable).getDatagramPrototypeCache()).getEventPrototype(eventId);
    }

    protected String getDataType(Prototype prototype, ImmutableEventDatagram event) {
        return ((DatagramPrototypeCacheImpl)((RuntimeContext)this.callable).getDatagramPrototypeCache()).getDataType(prototype, event);
    }

    protected static enum PrototypeModel {
        ADVISORY,
        MESSAGE,
        EVENT,
        EXCEPTION,
        DATA_EVENT,
        DELTA_EVENT,
        OPAQUE_EVENT,
        ROW_EVENT;

    }

    public class EventModelCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser {
        @Override
        public List<String> doGetCompletions(String processedScript, MFSession session) {
            ArrayList<String> result = new ArrayList<String>();
            DatagramFactoryManager factoryManager = ((RuntimeContext)AbstractEventPrototypeOperation.this.callable).getDatagramFactoryManager();
            for (String factoryName : factoryManager.listDatagramFactories()) {
                DatagramFactory factory = factoryManager.lookupDatagramFactory(factoryName);
                result.addAll(factory.listPrototypeModels());
            }
            return result;
        }
    }
}

