/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.Trace;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.types.Prototype;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.DatagramPrototypeCacheImpl;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.SystemEvents;
import com.streamscape.sdo.excp.ApplicationFabricException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.mf.admin.DatagramPrototypeFactory;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.mf.admin.FabricContext;
import java.util.List;

public abstract class AbstractDatagramPrototypeFactory
implements DatagramPrototypeFactory {
    protected DatagramPrototypeCache prototypeCache = null;

    protected AbstractDatagramPrototypeFactory(FabricContext context) {
        this.prototypeCache = new DatagramPrototypeCacheImpl(context.getSemanticTypeCache());
    }

    protected abstract FabricContext getContext();

    @Override
    public boolean existsPrototype(Prototype prototype) {
        return this.prototypeCache.existsPrototype(prototype);
    }

    @Override
    public boolean existsEventId(String eventId) {
        return this.prototypeCache.existsEventId(eventId);
    }

    @Override
    public String getAncestor(Prototype prototype) throws DatagramFactoryException {
        return this.prototypeCache.getAncestor(prototype);
    }

    @Override
    public String getAncestor(String eventId) throws DatagramFactoryException {
        return this.prototypeCache.getAncestor(eventId);
    }

    @Override
    public String getModel(String eventId) throws DatagramFactoryException {
        return this.prototypeCache.getModel(eventId);
    }

    @Override
    public String lookupEventId(Prototype prototype) {
        return this.prototypeCache.lookupEventId(prototype);
    }

    @Override
    public Prototype lookupPrototype(String eventId) {
        return this.prototypeCache.lookupPrototype(eventId);
    }

    @Override
    public List<Prototype> getPrototypes() {
        return this.prototypeCache.getPrototypes();
    }

    @Override
    public List<Prototype> getPrototypesByAncestor(String ancestorName, boolean includeModels) {
        return this.prototypeCache.getPrototypesByAncestor(ancestorName, includeModels);
    }

    @Override
    public List<Prototype> getPrototypesByDataType(SemanticType type) {
        return this.prototypeCache.getPrototypesByDataType(type);
    }

    @Override
    public List<String> listEventIdsByDataType(SemanticType type) {
        return this.prototypeCache.listEventIdsByDataType(type);
    }

    @Override
    public List<String> listEventIds() {
        return this.prototypeCache.listEventIds();
    }

    @Override
    public List<String> listEventIdsByAncestor(String ancestor) {
        return this.prototypeCache.listEventIdsByAncestor(ancestor);
    }

    @Override
    public List<String> listEventIdsByFilter(Filter filter) {
        return this.prototypeCache.listEventIdsByFilter(filter);
    }

    @Override
    public void addEventPrototype(String model, String eventId) throws DatagramFactoryException {
        this.addEventPrototype(model, AbstractDatagramPrototypeFactory.createInstance(eventId), eventId);
    }

    protected void addEventPrototype(String model, String instance, String eventId) throws DatagramFactoryException {
        this.doAddEventPrototype(model, instance, eventId, this.createEvent(model), true);
    }

    @Override
    public void addEventPrototype(String eventId, EventDatagram event) throws DatagramFactoryException {
        this.addEventPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, event);
    }

    protected void addEventPrototype(String instance, String eventId, EventDatagram event) throws DatagramFactoryException {
        this.doAddEventPrototype(instance, eventId, event, true);
    }

    protected void doAddEventPrototype(String instance, String eventId, EventDatagram event, boolean notify) throws DatagramFactoryException {
        this.doAddEventPrototype(event.getClass().getSimpleName(), instance, eventId, event, notify);
    }

    private void doAddEventPrototype(String model, String instance, String eventId, EventDatagram event, boolean notify) throws DatagramFactoryException {
        if (model.equals("DataEvent") || model.equals("DeltaEvent")) {
            throw new DatagramFactoryException(5029, "Event model '" + model + "' cannot be used in 'addEventPrototype' methods.");
        }
        this.addPrototype(this.getContext().getEventDatagramFactory(), model, instance, eventId, event, notify);
    }

    @Override
    public void removeEventPrototype(String eventId) throws DatagramFactoryException {
        this.removePrototype(this.getContext().getEventDatagramFactory(), eventId, false, true);
    }

    @Override
    public void addDataEventPrototype(String eventId, String semanticType) throws DatagramFactoryException {
        this.addDataEventPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, semanticType);
    }

    protected void addDataEventPrototype(String instance, String eventId, String semanticType) throws DatagramFactoryException {
        try {
            DataEvent event = (DataEvent)this.createEvent("DataEvent");
            event.setData(SDOUtils.createDataObject(semanticType));
            this.addDataEventPrototype(instance, eventId, event);
        }
        catch (SecurityViolationException exception) {
            throw new DatagramFactoryException(5036, (Throwable)exception);
        }
        catch (SDOException exception) {
            throw new DatagramFactoryException(5036, (Throwable)exception);
        }
    }

    @Override
    public void addDataEventPrototype(String eventId, DataEvent event) throws DatagramFactoryException {
        this.addDataEventPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, event);
    }

    protected void addDataEventPrototype(String instance, String eventId, DataEvent event) throws DatagramFactoryException {
        SDOUtils.checkDataClass(this.getContext(), event.getPayloadClass());
        this.addPrototype(this.getContext().getEventDatagramFactory(), "DataEvent", instance, eventId, event, true);
    }

    @Override
    public void addDeltaEventPrototype(String eventId, String semanticType) throws DatagramFactoryException {
        this.addDeltaEventPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, semanticType);
    }

    protected void addDeltaEventPrototype(String instance, String eventId, String semanticType) throws DatagramFactoryException {
        try {
            DeltaEvent event = (DeltaEvent)this.createEvent("DeltaEvent");
            Object data = SDOUtils.createDataObject(semanticType);
            event.setBeforeImage(data);
            event.setAfterImage(data);
            this.addDeltaEventPrototype(instance, eventId, event);
        }
        catch (SecurityViolationException exception) {
            throw new DatagramFactoryException(5036, (Throwable)exception);
        }
        catch (SDOException exception) {
            throw new DatagramFactoryException(5036, (Throwable)exception);
        }
    }

    @Override
    public void addDeltaEventPrototype(String eventId, DeltaEvent event) throws DatagramFactoryException {
        this.addDeltaEventPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, event);
    }

    protected void addDeltaEventPrototype(String instance, String eventId, DeltaEvent event) throws DatagramFactoryException {
        SDOUtils.checkDataClass(this.getContext(), event.getPayloadClass());
        this.addPrototype(this.getContext().getEventDatagramFactory(), "DeltaEvent", instance, eventId, event, true);
    }

    @Override
    public void addOpaqueEventPrototype(String eventId, String semanticType) throws DatagramFactoryException {
        this.addOpaqueEventPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, semanticType);
    }

    protected void addOpaqueEventPrototype(String instance, String eventId, String semanticType) throws DatagramFactoryException {
        try {
            OpaqueEvent event = (OpaqueEvent)this.createOpaqueEvent("OpaqueEvent");
            event.setData(SDOUtils.createDataObject(semanticType));
            this.addOpaqueEventPrototype(instance, eventId, event);
        }
        catch (SDOException exception) {
            throw new DatagramFactoryException(5036, (Throwable)exception);
        }
    }

    @Override
    public void addOpaqueEventPrototype(String eventId, OpaqueEvent event) throws DatagramFactoryException {
        this.addOpaqueEventPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, event);
    }

    protected void addOpaqueEventPrototype(String instance, String eventId, OpaqueEvent event) throws DatagramFactoryException {
        SDOUtils.checkDataClass(this.getContext(), event.getPayloadClass());
        this.addPrototype(this.getContext().getOpaqueDatagramFactory(), "OpaqueEvent", instance, eventId, event, true);
    }

    @Override
    public void removeOpaqueEventPrototype(String eventId) throws DatagramFactoryException {
        this.removePrototype(this.getContext().getOpaqueDatagramFactory(), eventId, false, true);
    }

    @Override
    public void addAdvisoryPrototype(String model, String eventId) throws DatagramFactoryException {
        this.addAdvisoryPrototype(model, AbstractDatagramPrototypeFactory.createInstance(eventId), eventId);
    }

    protected void addAdvisoryPrototype(String model, String instance, String eventId) throws DatagramFactoryException {
        this.doAddAdvisoryPrototype(model, instance, eventId, this.createAdvisoryEvent(model), true);
    }

    @Override
    public void addAdvisoryPrototype(String eventId, AdvisoryEventDatagram event) throws DatagramFactoryException {
        this.addAdvisoryPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, event);
    }

    protected void addAdvisoryPrototype(String instance, String eventId, AdvisoryEventDatagram event) throws DatagramFactoryException {
        this.doAddAdvisoryPrototype(instance, eventId, event, true);
    }

    protected void doAddAdvisoryPrototype(String instance, String eventId, AdvisoryEventDatagram event, boolean notify) throws DatagramFactoryException {
        this.doAddAdvisoryPrototype(event.getClass().getSimpleName(), instance, eventId, event, notify);
    }

    protected void doAddAdvisoryPrototype(String model, String instance, String eventId, AdvisoryEventDatagram event, boolean notify) throws DatagramFactoryException {
        this.addPrototype(this.getContext().getAdvisoryDatagramFactory(), model, instance, eventId, event, notify);
    }

    @Override
    public void removeAdvisoryPrototype(String eventId) throws DatagramFactoryException {
        this.removePrototype(this.getContext().getAdvisoryDatagramFactory(), eventId, false, true);
    }

    @Override
    public void addExceptionPrototype(String model, String eventId) throws DatagramFactoryException {
        this.addExceptionPrototype(model, AbstractDatagramPrototypeFactory.createInstance(eventId), eventId);
    }

    protected void addExceptionPrototype(String model, String instance, String eventId) throws DatagramFactoryException {
        this.doAddExceptionPrototype(model, instance, eventId, this.createExceptionEvent(model), true);
    }

    @Override
    public void addExceptionPrototype(String eventId, ExceptionEventDatagram event) throws DatagramFactoryException {
        this.addExceptionPrototype(AbstractDatagramPrototypeFactory.createInstance(eventId), eventId, event);
    }

    protected void addExceptionPrototype(String instance, String eventId, ExceptionEventDatagram event) throws DatagramFactoryException {
        this.doAddExceptionPrototype(instance, eventId, event, true);
    }

    protected void doAddExceptionPrototype(String instance, String eventId, ExceptionEventDatagram event, boolean notify) throws DatagramFactoryException {
        this.doAddExceptionPrototype(event instanceof ApplicationFabricException ? ApplicationFabricException.class.getSimpleName() : event.getClass().getSimpleName(), instance, eventId, event, notify);
    }

    protected void doAddExceptionPrototype(String model, String instance, String eventId, ExceptionEventDatagram event, boolean notify) throws DatagramFactoryException {
        this.addPrototype(this.getContext().getExceptionDatagramFactory(), model, instance, eventId, event, notify);
    }

    protected void doAddEventPrototype(Prototype prototype, ImmutableEventDatagram event, boolean notify) throws DatagramFactoryException {
        if (event instanceof AdvisoryEventDatagram) {
            this.addPrototype(this.getContext().getAdvisoryDatagramFactory(), prototype, event.getEventId(), event, notify);
        } else if (event instanceof EventDatagram) {
            this.addPrototype(this.getContext().getEventDatagramFactory(), prototype, event.getEventId(), event, notify);
        } else if (event instanceof OpaqueDatagram) {
            this.addPrototype(this.getContext().getOpaqueDatagramFactory(), prototype, event.getEventId(), event, notify);
        } else if (event instanceof ExceptionEventDatagram) {
            this.addPrototype(this.getContext().getExceptionDatagramFactory(), prototype, event.getEventId(), event, notify);
        } else {
            throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", event.getClass().getName()));
        }
    }

    protected void unregisterInvalidPrototype(Prototype prototype, ImmutableEventDatagram event) throws DatagramFactoryException {
        IAbstractDatagramFactory factory;
        if (event instanceof AdvisoryEventDatagram) {
            factory = this.getContext().getAdvisoryDatagramFactory();
        } else if (event instanceof EventDatagram) {
            factory = this.getContext().getEventDatagramFactory();
        } else if (event instanceof OpaqueEvent) {
            factory = this.getContext().getOpaqueDatagramFactory();
        } else if (event instanceof ExceptionEventDatagram) {
            factory = this.getContext().getExceptionDatagramFactory();
        } else {
            throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", event.getClass().getName()));
        }
        factory.unregisterPrototype(prototype);
    }

    @Override
    public void removeExceptionPrototype(String eventId) throws DatagramFactoryException {
        this.removePrototype(this.getContext().getExceptionDatagramFactory(), eventId, false, true);
    }

    @Override
    public void removePrototype(String eventId) throws DatagramFactoryException {
        this.removePrototype(eventId, false);
    }

    @Override
    public void removePrototype(String eventId, boolean force) throws DatagramFactoryException {
        this.doRemovePrototype(eventId, force, true);
    }

    protected void doRemovePrototype(String eventId, boolean force, boolean notify) throws DatagramFactoryException {
        Pair<String, String> ancestor = this.doGetAncestor(eventId);
        if (((String)ancestor.first).equals(this.getContext().getAdvisoryDatagramFactory().getAncestorType())) {
            this.removePrototype(this.getContext().getAdvisoryDatagramFactory(), eventId, force, notify);
        } else if (((String)ancestor.first).equals(this.getContext().getEventDatagramFactory().getAncestorType())) {
            this.removePrototype(this.getContext().getEventDatagramFactory(), eventId, force, notify);
        } else if (((String)ancestor.first).equals(this.getContext().getExceptionDatagramFactory().getAncestorType())) {
            this.removePrototype(this.getContext().getExceptionDatagramFactory(), eventId, force, notify);
        } else if (((String)ancestor.first).equals(this.getContext().getOpaqueDatagramFactory().getAncestorType())) {
            this.removePrototype(this.getContext().getOpaqueDatagramFactory(), eventId, force, notify);
        } else {
            throw new DatagramFactoryException(5035, ErrorMessages.format("Event prototype model '%1$s' is not supported.", (String)ancestor.second));
        }
    }

    private synchronized Pair<String, String> doGetAncestor(String eventId) throws DatagramFactoryException {
        this.checkPrototypeExistence(eventId);
        Prototype prototype = this.lookupPrototype(eventId);
        return new Pair<String, String>(this.prototypeCache.getAncestor(prototype), prototype.getModelName());
    }

    @Override
    public boolean existsPrototype(String eventId) {
        return this.existsEventId(eventId);
    }

    protected EventDatagram createEvent(String model) throws DatagramFactoryException {
        return this.getContext().getEventDatagramFactory().newEventInstance(this.getSemanticType(model));
    }

    protected OpaqueDatagram createOpaqueEvent(String model) throws DatagramFactoryException {
        return this.getContext().getOpaqueDatagramFactory().newEventInstance(this.getSemanticType(model));
    }

    protected AdvisoryEventDatagram createAdvisoryEvent(String model) throws DatagramFactoryException {
        return this.getContext().getAdvisoryDatagramFactory().newEventInstance(this.getSemanticType(model));
    }

    protected ExceptionEventDatagram createExceptionEvent(String model) throws DatagramFactoryException {
        return this.getContext().getExceptionDatagramFactory().newEventInstance(this.getSemanticType(model));
    }

    protected SemanticType getSemanticType(String model) throws DatagramFactoryException {
        SemanticType type = this.getContext().getSemanticTypeCache().lookupSemanticType(model);
        if (type == null) {
            throw new DatagramFactoryException(5014, ErrorMessages.format("Semantic type [%1$s] does not exist.", model));
        }
        return type;
    }

    protected void addPrototype(IAbstractDatagramFactory factory, String model, String instance, String eventId, ImmutableEventDatagram event, boolean notify) throws DatagramFactoryException {
        AbstractDatagramPrototypeFactory.validateEventId(eventId);
        this.addPrototype(factory, factory.createPrototype(model, instance, null), eventId, event, notify);
    }

    private static void validateEventId(String eventId) throws DatagramFactoryException {
        try {
            SDOUtils.validateEventId(eventId);
        }
        catch (SDOFormatException exception) {
            throw new DatagramFactoryException(5020, exception.getMessage());
        }
    }

    private void addSystemPrototype(IAbstractDatagramFactory factory, String model, String instance, String eventId, ImmutableEventDatagram event) throws DatagramFactoryException {
        this.doAddPrototypeCore(factory, factory.createPrototype(model, instance, null), eventId, event, true);
    }

    protected void addPrototype(IAbstractDatagramFactory factory, Prototype prototype, String eventId, ImmutableEventDatagram event, boolean notify) throws DatagramFactoryException {
        this.doAddPrototypeCore(factory, prototype, eventId, event);
    }

    protected ImmutableEventDatagram doAddPrototypeCore(IAbstractDatagramFactory factory, Prototype prototype, String eventId, ImmutableEventDatagram event) throws DatagramFactoryException {
        return this.doAddPrototypeCore(factory, prototype, eventId, event, false);
    }

    private synchronized ImmutableEventDatagram doAddPrototypeCore(IAbstractDatagramFactory factory, Prototype prototype, String eventId, ImmutableEventDatagram event, boolean system) throws DatagramFactoryException {
        factory.checkRegistrationParameters(eventId, prototype, event, system);
        event = factory.prepareEventInstance(event, eventId);
        if (!system) {
            this.doRegisterPrototype(factory, prototype, event);
        }
        this.doAddPrototype(factory, prototype, event);
        if (!system) {
            Trace.logInfo(this, prototype.getModelName() + " prototype [" + eventId + "] added.");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new DatagramFactoryException(5003, "Adding event prototype [" + eventId + "] interrupted.");
        }
        return event;
    }

    protected void doRegisterPrototype(IAbstractDatagramFactory factory, Prototype prototype, ImmutableEventDatagram event) throws DatagramFactoryException {
        factory.doRegisterPrototype(prototype, event);
    }

    protected void doAddPrototype(IAbstractDatagramFactory factory, Prototype prototype, ImmutableEventDatagram event) throws DatagramFactoryException {
        factory.addPrototype(prototype, event);
    }

    protected void removePrototype(IAbstractDatagramFactory factory, String eventId, boolean force, boolean notify) throws DatagramFactoryException {
        this.doRemovePrototypeCore(factory, eventId, force, notify);
    }

    protected void doRemovePrototypeCore(IAbstractDatagramFactory factory, String eventId, boolean force, boolean inSysplex) throws DatagramFactoryException {
        factory.removePrototype(this.prototypeCache.lookupPrototype(eventId));
        Trace.logInfo(this, "Event prototype [" + eventId + "] removed.");
        if (Thread.currentThread().isInterrupted()) {
            throw new DatagramFactoryException(5003, "Removing event prototype [" + eventId + "] interrupted.");
        }
    }

    protected void unregisterPrototype(IAbstractDatagramFactory factory, String eventId) throws DatagramFactoryException {
        factory.unregisterPrototype(eventId);
    }

    protected synchronized void removePrototypeSpecial(IAbstractDatagramFactory factory, String eventId) throws DatagramFactoryException {
        if (this.existsEventId(eventId)) {
            factory.unregisterPrototype(factory.getPrototype(eventId));
            factory.removePrototype(this.prototypeCache.lookupPrototype(eventId));
            Trace.logInfo(this, "Event prototype [" + eventId + "] removed.");
        }
    }

    protected void addSystemPrototypes(IAbstractDatagramFactory factory) throws DatagramFactoryException {
        for (IAbstractDatagramFactory.DatagramEntry entry : factory.getDatagramEntries().values()) {
            this.addSystemPrototype(factory, entry.getModel(), entry.getModel(), entry.getPrototypeEventId(), entry.datagram);
        }
    }

    protected static String createInstance(String eventId) {
        return PrototypeFactory.createInstance(eventId);
    }

    protected Pair<Prototype, ImmutableEventDatagram> getPrototype(String eventId) throws DatagramFactoryException {
        return ((DatagramPrototypeCacheImpl)this.prototypeCache).getPrototype(eventId);
    }

    protected void checkOnRemove(String eventId, boolean force, boolean inSysplex) throws DatagramFactoryException {
        if (SDOUtils.isSystemEventId(eventId)) {
            throw new DatagramFactoryException(5021, ErrorMessages.format("Event id [%1$s] is reserved for system purposes.", eventId));
        }
        if (SystemEvents.isPredefined(eventId)) {
            throw new DatagramFactoryException(5022, "Event id [" + eventId + "] is predefined and cannot be removed.");
        }
        this.checkPrototypeExistence(eventId);
    }

    protected void checkPrototypeExistence(String eventId) throws DatagramFactoryException {
        if (!this.existsEventId(eventId)) {
            throw new DatagramFactoryException(5031, ErrorMessages.format("Event prototype [%1$s] does not exist.", eventId));
        }
    }
}

