/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sdo;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.Prototype;
import com.streamscape.sdo.AbstractDatagramPrototypeFactory;
import com.streamscape.sdo.DatagramPrototypeCacheImpl;
import com.streamscape.sdo.IAbstractDatagramFactory;
import com.streamscape.sdo.advisory.AdvisoryDatagramFactory;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.excp.ExceptionDatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactory;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.DatagramFactoryManager;
import com.streamscape.sdo.mf.admin.DatagramFactoryManagerException;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sef.mf.admin.FabricContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractDatagramFactoryManager
implements DatagramFactoryManager {
    protected FabricContext context;
    protected AbstractDatagramPrototypeFactory prototypeFactory;
    protected DatagramPrototypeCacheImpl prototypeCache;
    protected Map<String, DatagramFactory> factories = new ConcurrentHashMap<String, DatagramFactory>();

    protected AbstractDatagramFactoryManager(FabricContext context, AbstractDatagramPrototypeFactory prototypeFactory) {
        this.context = context;
        this.prototypeFactory = prototypeFactory;
        this.prototypeCache = (DatagramPrototypeCacheImpl)prototypeFactory.prototypeCache;
    }

    protected void addFactories() throws Exception {
        this.addFactory(EventDatagramFactory.class);
        this.addFactory(OpaqueDatagramFactory.class);
        this.addFactory(AdvisoryDatagramFactory.class);
        this.addFactory(ExceptionDatagramFactory.class);
    }

    @Override
    public void addDatagramFactory(Class factoryClass) throws DatagramFactoryManagerException {
        this.logDebug("Adding datagram factory '" + String.valueOf(factoryClass) + "'...");
        DatagramFactory factory = this.getDatagramFactory(factoryClass);
        this.addSemanticType(factory);
        this.addFactory(factory, false);
        this.logInfo("Datagram factory '" + factory.getName() + "' added.");
    }

    protected void addFactory(Class factoryClass) throws DatagramFactoryManagerException, SemanticTypeFactoryException {
        this.logDebug("Adding datagram factory '" + String.valueOf(factoryClass) + "'...");
        DatagramFactory factory = this.getDatagramFactory(factoryClass);
        this.registerDatagramFactory((IAbstractDatagramFactory)factory);
        this.addFactory(factory, true);
        this.logInfo("Datagram factory '" + factory.getName() + "' added.");
    }

    void addSemanticType(DatagramFactory factory) throws DatagramFactoryManagerException {
        try {
            this.context.getSemanticTypeFactory().addSemanticType(factory.getSemanticType());
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(5072, (Throwable)exception);
        }
    }

    protected DatagramFactory getDatagramFactory(Class factoryClass) throws DatagramFactoryManagerException {
        this.checkFactoryClass(factoryClass);
        try {
            return (DatagramFactory)ClassUtils.invokeMethod(factoryClass, factoryClass.getDeclaredMethod("getInstance", new Class[0]), null);
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(5072, (Throwable)exception);
        }
    }

    protected void registerDatagramFactory(IAbstractDatagramFactory factory) throws DatagramFactoryManagerException {
    }

    void addFactory(DatagramFactory factory, boolean isSystem) throws DatagramFactoryManagerException {
        try {
            this.initDatagramFactory(factory, isSystem);
            this.doAddFactory(factory);
        }
        catch (Exception exception) {
            throw new DatagramFactoryManagerException(5072, (Throwable)exception);
        }
    }

    protected void checkFactoryClass(Class factoryClass) throws DatagramFactoryManagerException {
        if (factoryClass == null) {
            throw new DatagramFactoryManagerException(5004, "Datagram factory class is null.");
        }
        if (!DatagramFactory.class.isAssignableFrom(factoryClass)) {
            throw new DatagramFactoryManagerException(5069, "Datagram factory class '" + factoryClass.getName() + "' is not an instance of '" + DatagramFactory.class.getName() + "'.");
        }
    }

    protected void initDatagramFactory(DatagramFactory factory, boolean isSystem) throws DatagramFactoryException {
        this.logDebug("Initializing datagram factory...");
        if (factory instanceof IAbstractDatagramFactory) {
            if (!isSystem) {
                ((IAbstractDatagramFactory)factory).addSupportedTypes();
            }
            this.doInitDatagramFactory((IAbstractDatagramFactory)factory);
        }
        this.logDebug("Datagram factory '" + factory.getName() + "' initialized.");
    }

    protected void doInitDatagramFactory(IAbstractDatagramFactory factory) throws DatagramFactoryException {
        this.setPrototypeCache(factory);
        this.prototypeFactory.addSystemPrototypes(factory);
    }

    protected void setPrototypeCache(IAbstractDatagramFactory factory) throws DatagramFactoryException {
        factory.setPrototypeCache(this.prototypeCache);
    }

    protected void initFactoryInstance(IAbstractDatagramFactory factory) throws DatagramFactoryException {
        factory.init();
    }

    protected void doAddFactory(DatagramFactory factory) throws DatagramFactoryManagerException {
        if (this.factories.containsKey(factory.getName())) {
            throw new DatagramFactoryManagerException(5065, "Datagram factory '" + factory.getName() + "' already exists.");
        }
        this.factories.put(factory.getName(), factory);
    }

    @Override
    public void removeDatagramFactory(String factoryName) throws DatagramFactoryManagerException {
        DatagramFactory factory = this.factories.get(factoryName);
        if (factory == null) {
            throw new DatagramFactoryManagerException(5066, "Datagram factory '" + factoryName + "' does not exist.");
        }
        if (AbstractDatagramFactoryManager.isSystem(factory)) {
            throw new DatagramFactoryManagerException(5075, "System datagram factory '" + factoryName + "' cannot be removed.");
        }
        this.logDebug("Removing datagram factory '" + factoryName + "'..");
        this.removePrototypesFromCache(this.factories.remove(factoryName));
    }

    protected void removeSystemPrototypes(IAbstractDatagramFactory factory) throws Exception {
        factory.removeSystemPrototypes(factory, this.prototypeCache);
    }

    static boolean isSystem(DatagramFactory factory) {
        return factory instanceof AdvisoryDatagramFactory || factory instanceof EventDatagramFactory || factory instanceof ExceptionDatagramFactory || factory instanceof OpaqueDatagramFactory;
    }

    protected void removePrototypesFromCache(DatagramFactory factory) throws DatagramFactoryManagerException {
        for (Prototype prototype : this.prototypeCache.getPrototypesByAncestor(factory.getAncestorType())) {
            try {
                this.logDebug("Removing datagram prototype '" + String.valueOf(prototype) + "'...");
                this.prototypeCache.removePrototype(prototype);
            }
            catch (DatagramFactoryException exception) {
                throw new DatagramFactoryManagerException(exception.errorCode, (Throwable)exception);
            }
        }
    }

    @Override
    public DatagramPrototypeCache getPrototypeCache() {
        return this.prototypeCache;
    }

    @Override
    public DatagramFactory lookupDatagramFactory(String factoryName) {
        return this.factories.get(factoryName);
    }

    @Override
    public DatagramFactory lookupDatagramFactoryByAncestor(String ancestorName) {
        for (DatagramFactory factory : this.factories.values()) {
            if (!factory.getAncestorType().equals(ancestorName)) continue;
            return factory;
        }
        return null;
    }

    @Override
    public DatagramFactory lookupDatagramFactoryByModel(String modelName) {
        for (DatagramFactory factory : this.factories.values()) {
            if (!factory.supportsModel(modelName)) continue;
            return factory;
        }
        return null;
    }

    @Override
    public List<String> listDatagramFactories() {
        return new ArrayList<String>(this.factories.keySet());
    }

    @Override
    public List<String> listPrototypeModels() {
        ArrayList<String> result = new ArrayList<String>();
        for (DatagramFactory factory : this.factories.values()) {
            result.addAll(factory.listPrototypeModels());
        }
        return result;
    }

    protected Collection<DatagramFactory> getFactories() {
        return this.factories.values();
    }

    protected void logException(Throwable exception) {
        Trace.logException(this, exception, true);
    }

    protected void logError(String message) {
        Trace.logError(this, message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(this, message);
    }
}

