/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.stats;

import com.streamscape.Trace;
import com.streamscape.lib.concurrent.worker.MonitorDaemonWorker;
import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.stats.CpuThresholdListenerImpl;
import com.streamscape.runtime.stats.DiskThresholdListenerImpl;
import com.streamscape.runtime.stats.MemoryPoolStats;
import com.streamscape.runtime.stats.MemoryThresholdListenerImpl;
import com.streamscape.runtime.stats.MemoryUsageAdapter;
import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.runtime.stats.StatsListener;
import com.streamscape.runtime.stats.StatsMonitorException;
import com.streamscape.runtime.stats.SystemEnvironment;
import com.streamscape.runtime.stats.ThreadStats;
import com.streamscape.runtime.stats.ThresholdListenerImpl;
import com.streamscape.runtime.stats.threshold.CpuThreshold;
import com.streamscape.runtime.stats.threshold.Threshold;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractStatsMonitor;
import com.streamscape.sef.utils.RepositoryUtils;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class StatsMonitor
extends AbstractStatsMonitor {
    public static final int DEFAULT_CPU_EXCEEDING_INTERVAL = 5;
    private Monitor monitor;
    private Map<String, StatsListener> listeners = new ConcurrentHashMap<String, StatsListener>();
    private OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
    private MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    private List<MemoryPoolMXBean> memoryPoolBeans = ManagementFactory.getMemoryPoolMXBeans();
    private ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private File file = new File(".");
    private Map<String, Threshold> memoryThresholds = new HashMap<String, Threshold>();
    private Map<String, CpuThreshold> cpuThresholds = new HashMap<String, CpuThreshold>();
    private Map<String, Threshold> diskThresholds = new HashMap<String, Threshold>();
    private static final String MEMORY_THRESHOLDS_NAMESPACE = "sys/threshold/memory";
    private static final String CPU_THRESHOLDS_NAMESPACE = "sys/threshold/cpu";
    private static final String DISK_THRESHOLDS_NAMESPACE = "sys/threshold/disk";
    private static final String THRESHOLDS_INSTANCE_NAME = "Thresholds";
    private static final Method GET_SYSTEM_CPU_LOAD = StatsMonitor.getMethod("getSystemCpuLoad");
    private static final Method GET_PROCESS_CPU_LOAD = StatsMonitor.getMethod("getProcessCpuLoad");

    public StatsMonitor(RuntimeContext context) throws FabricException {
        this(context, 1000);
    }

    public StatsMonitor(RuntimeContext context, int samplingInterval) throws FabricException {
        super(context);
        try {
            if (RepositoryUtils.existsObject(MEMORY_THRESHOLDS_NAMESPACE, THRESHOLDS_INSTANCE_NAME)) {
                this.memoryThresholds = this.loadThresholds(this.memoryThresholds, MEMORY_THRESHOLDS_NAMESPACE);
            }
            if (RepositoryUtils.existsObject(CPU_THRESHOLDS_NAMESPACE, THRESHOLDS_INSTANCE_NAME)) {
                this.loadCpuThresholds();
            }
            if (RepositoryUtils.existsObject(DISK_THRESHOLDS_NAMESPACE, THRESHOLDS_INSTANCE_NAME)) {
                this.diskThresholds = this.loadThresholds(this.diskThresholds, DISK_THRESHOLDS_NAMESPACE);
            }
        }
        catch (Exception exception) {
            throw new StatsMonitorException("Loading thresholds from repository failed.");
        }
        this.monitor = new Monitor(samplingInterval);
        for (Map.Entry<String, Threshold> entry : this.memoryThresholds.entrySet()) {
            this.doAddMemoryThresholdListener(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Threshold> entry : this.cpuThresholds.entrySet()) {
            this.doAddCpuThresholdListener(entry.getKey(), (CpuThreshold)entry.getValue());
        }
        for (Map.Entry<String, Threshold> entry : this.diskThresholds.entrySet()) {
            this.doAddDiskThresholdListener(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, Threshold> loadThresholds(Map<String, Threshold> thresholds, String namespace) throws Exception {
        HashMap<String, ThresholdImpl> map = (HashMap<String, ThresholdImpl>)RepositoryUtils.lookupObject(namespace, THRESHOLDS_INSTANCE_NAME);
        if (!map.isEmpty()) {
            Object threshold = map.values().iterator().next();
            if (threshold instanceof Integer) {
                thresholds = new HashMap<String, ThresholdImpl>();
                for (Map.Entry entry : map.entrySet()) {
                    thresholds.put((String)entry.getKey(), new ThresholdImpl(null, (Integer)entry.getValue()));
                }
                StatsMonitor.updateInRepository(namespace, thresholds);
            } else {
                thresholds = map;
            }
        }
        return thresholds;
    }

    private void loadCpuThresholds() throws Exception {
        Map map = (Map)RepositoryUtils.lookupObject(CPU_THRESHOLDS_NAMESPACE, THRESHOLDS_INSTANCE_NAME);
        if (!map.isEmpty()) {
            Object threshold = map.values().iterator().next();
            if (threshold instanceof Integer) {
                this.cpuThresholds = new HashMap<String, CpuThreshold>();
                for (Map.Entry entry : map.entrySet()) {
                    this.cpuThresholds.put((String)entry.getKey(), new CpuThresholdImpl(null, (Integer)entry.getValue(), 5));
                }
                StatsMonitor.updateInRepository(CPU_THRESHOLDS_NAMESPACE, this.cpuThresholds);
            } else if (threshold instanceof Pair) {
                this.cpuThresholds = new HashMap<String, CpuThreshold>();
                for (Map.Entry entry : map.entrySet()) {
                    this.cpuThresholds.put((String)entry.getKey(), new CpuThresholdImpl(null, (Integer)((Pair)entry.getValue()).first, (Integer)((Pair)entry.getValue()).second));
                }
                StatsMonitor.updateInRepository(CPU_THRESHOLDS_NAMESPACE, this.cpuThresholds);
            } else {
                this.cpuThresholds = map;
            }
        }
    }

    public synchronized void start() {
        if (!this.monitor.isStarted()) {
            Trace.logDebug(this, "StatsMonitor starting...");
            this.monitor.prepare();
            this.monitor.start();
            Trace.logInfo(this, "StatsMonitor started.");
        }
    }

    public synchronized void stop() {
        Trace.logDebug(this, "StatsMonitor stopping...");
        this.monitor.stop();
        Trace.logInfo(this, "StatsMonitor stopped.");
    }

    public long getSamplingInterval() {
        return this.monitor.getTimeout();
    }

    public void setSamplingInterval(int samplingInterval) throws FabricException {
        this.monitor.setTimeout(samplingInterval);
    }

    public SystemEnvironment getSystemEnvironment() {
        return this.doGetSystemEnvironment();
    }

    public long getTotalSystemMemorySize() {
        return this.osBean.getTotalPhysicalMemorySize();
    }

    public RuntimeStats getRuntimeStats() {
        return this.doGetRuntimeStats();
    }

    @Override
    public List<RuntimeStats> getRemoteRuntimeStats() throws StatsMonitorException {
        return super.getRemoteRuntimeStats();
    }

    public synchronized void addListener(String name, StatsListener listener) throws StatsMonitorException {
        if (this.listeners.containsKey(name)) {
            throw new StatsMonitorException("Listener '" + name + "' already exists.");
        }
        if (this.monitor.isStarted()) {
            listener.onSystemEnvironment(this.doGetSystemEnvironment());
        }
        this.listeners.put(name, listener);
        if (this.monitor.isStarted() && this.listeners.size() == 1) {
            this.monitor.wakeUp();
        }
    }

    public synchronized boolean removeListener(String name) {
        return !this.memoryThresholds.containsKey(name) && !this.cpuThresholds.containsKey(name) && !this.diskThresholds.containsKey(name) && this.doRemoveListener(name);
    }

    private boolean doRemoveListener(String name) {
        return this.listeners.remove(name) != null;
    }

    public StatsListener lookupListener(String name) {
        return this.listeners.get(name);
    }

    public List<StatsListener> getListeners() {
        return new ArrayList<StatsListener>(this.listeners.values());
    }

    public List<String> listListeners() {
        return new ArrayList<String>(this.listeners.keySet());
    }

    public void addMemoryThresholdListener(int threshold) throws StatsMonitorException {
        this.addMemoryThresholdListener(threshold, null);
    }

    public synchronized void addMemoryThresholdListener(int threshold, String key) throws StatsMonitorException {
        if (threshold <= 0) {
            throw new StatsMonitorException("Threshold must be positive.");
        }
        String name = StatsMonitor.getMemoryThresholdListenerName(threshold, key);
        ThresholdImpl thresholdImpl = new ThresholdImpl(key, threshold);
        this.addThresholdToRepository(this.memoryThresholds, this.doAddMemoryThresholdListener(name, thresholdImpl), thresholdImpl, MEMORY_THRESHOLDS_NAMESPACE);
    }

    private String doAddMemoryThresholdListener(String name, Threshold threshold) throws StatsMonitorException {
        return this.doAddThresholdListener(name, new MemoryThresholdListenerImpl(threshold));
    }

    public boolean removeMemoryThresholdListener(int threshold) {
        return this.removeMemoryThresholdListener(threshold, null);
    }

    public boolean removeMemoryThresholdListener(int threshold, String key) {
        return this.doRemoveThresholdListener(StatsMonitor.getMemoryThresholdListenerName(threshold, key), this.memoryThresholds, MEMORY_THRESHOLDS_NAMESPACE);
    }

    private static String getMemoryThresholdListenerName(int threshold, String key) {
        return StatsMonitor.getThresholdListenerName("Memory", threshold, key);
    }

    public void clearMemoryThresholdListeners() {
        this.clearThresholdListeners(this.memoryThresholds, MEMORY_THRESHOLDS_NAMESPACE);
    }

    public List<Threshold> getMemoryThresholds() {
        return this.getListeners().stream().filter(listener -> listener instanceof MemoryThresholdListenerImpl).map(listener -> ((MemoryThresholdListenerImpl)listener).threshold).collect(Collectors.toList());
    }

    public void addCpuThresholdListener(int threshold) throws StatsMonitorException {
        this.addCpuThresholdListener(threshold, null);
    }

    public void addCpuThresholdListener(int threshold, String key) throws StatsMonitorException {
        this.addCpuThresholdListener(threshold, key, 5);
    }

    public void addCpuThresholdListener(int threshold, String key, int interval) throws StatsMonitorException {
        if (threshold <= 0 || threshold > 100) {
            throw new StatsMonitorException("Threshold must be in range [1, 100].");
        }
        StatsMonitor.checkInterval(interval);
        String name = StatsMonitor.getCpuThresholdListenerName(threshold, key);
        CpuThresholdImpl thresholdImpl = new CpuThresholdImpl(key, threshold, interval);
        this.addThresholdToRepository(this.cpuThresholds, this.doAddCpuThresholdListener(name, thresholdImpl), thresholdImpl, CPU_THRESHOLDS_NAMESPACE);
    }

    private String doAddCpuThresholdListener(String name, CpuThreshold threshold) throws StatsMonitorException {
        return this.doAddThresholdListener(name, new CpuThresholdListenerImpl(threshold));
    }

    public boolean removeCpuThresholdListener(int threshold) {
        return this.removeCpuThresholdListener(threshold, null);
    }

    public boolean removeCpuThresholdListener(int threshold, String key) {
        return this.doRemoveThresholdListener(StatsMonitor.getCpuThresholdListenerName(threshold, key), this.cpuThresholds, CPU_THRESHOLDS_NAMESPACE);
    }

    public void clearCpuThresholdListeners() {
        this.clearThresholdListeners(this.cpuThresholds, CPU_THRESHOLDS_NAMESPACE);
    }

    public void setCpuThresholdListenerInterval(int threshold, String key, int interval) throws StatsMonitorException {
        String name = StatsMonitor.getCpuThresholdListenerName(threshold, key);
        StatsListener listener = this.lookupListener(name);
        if (listener == null) {
            throw new StatsMonitorException("Threshold not found.");
        }
        StatsMonitor.checkInterval(interval);
        ((CpuThresholdListenerImpl)listener).setInterval(interval);
        this.addThresholdToRepository(this.cpuThresholds, name, (CpuThreshold)((CpuThresholdListenerImpl)listener).threshold, CPU_THRESHOLDS_NAMESPACE);
    }

    private static String getCpuThresholdListenerName(int threshold, String key) {
        return StatsMonitor.getThresholdListenerName("Cpu", threshold, key);
    }

    private static void checkInterval(int interval) throws StatsMonitorException {
        if (interval <= 0) {
            throw new StatsMonitorException("Interval must be positive.");
        }
    }

    public List<CpuThreshold> getCpuThresholds() {
        return this.getListeners().stream().filter(listener -> listener instanceof CpuThresholdListenerImpl).map(listener -> (CpuThreshold)((CpuThresholdListenerImpl)listener).threshold).collect(Collectors.toList());
    }

    public void addDiskThresholdListener(int threshold) throws StatsMonitorException {
        this.addDiskThresholdListener(threshold, null);
    }

    public synchronized void addDiskThresholdListener(int threshold, String key) throws StatsMonitorException {
        if (threshold <= 0 || threshold > 100) {
            throw new StatsMonitorException("Threshold must be in range [1, 100].");
        }
        String name = StatsMonitor.getDiskThresholdListenerName(threshold, key);
        ThresholdImpl thresholdImpl = new ThresholdImpl(key, threshold);
        this.addThresholdToRepository(this.diskThresholds, this.doAddDiskThresholdListener(name, thresholdImpl), thresholdImpl, DISK_THRESHOLDS_NAMESPACE);
    }

    private String doAddDiskThresholdListener(String name, Threshold threshold) throws StatsMonitorException {
        return this.doAddThresholdListener(name, new DiskThresholdListenerImpl(threshold));
    }

    public boolean removeDiskThresholdListener(int threshold) {
        return this.removeDiskThresholdListener(threshold, null);
    }

    public boolean removeDiskThresholdListener(int threshold, String key) {
        return this.doRemoveThresholdListener(StatsMonitor.getDiskThresholdListenerName(threshold, key), this.diskThresholds, DISK_THRESHOLDS_NAMESPACE);
    }

    public void clearDiskThresholdListeners() {
        this.clearThresholdListeners(this.diskThresholds, DISK_THRESHOLDS_NAMESPACE);
    }

    public List<Threshold> getDiskThresholds() {
        return this.getListeners().stream().filter(listener -> listener instanceof DiskThresholdListenerImpl).map(listener -> ((DiskThresholdListenerImpl)listener).threshold).collect(Collectors.toList());
    }

    private static String getDiskThresholdListenerName(int threshold, String key) {
        return StatsMonitor.getThresholdListenerName("Disk", threshold, key);
    }

    private static String getThresholdListenerName(String prefix, int threshold, String key) {
        return prefix + "ThresholdListener" + threshold + (String)(key != null ? "_" + key : "");
    }

    private String doAddThresholdListener(String name, ThresholdListenerImpl listener) throws StatsMonitorException {
        this.init(listener);
        this.addListener(name, listener);
        return name;
    }

    private void init(ThresholdListenerImpl listener) {
        super.init(listener);
        listener.init(this);
    }

    private <T> void addThresholdToRepository(Map<String, T> thresholds, String name, T value, String namespace) throws StatsMonitorException {
        thresholds.put(name, value);
        StatsMonitor.updateInRepository(namespace, thresholds);
    }

    private synchronized <T> boolean doRemoveThresholdListener(String name, Map<String, T> thresholds, String namespace) {
        if (this.doRemoveListener(name)) {
            this.removeThresholdFromRepository(thresholds, name, namespace);
            return true;
        }
        return false;
    }

    private <T> void removeThresholdFromRepository(Map<String, T> thresholds, String name, String namespace) {
        if (thresholds.remove(name) != null) {
            StatsMonitor.updateInRepository(namespace, thresholds);
        }
    }

    private synchronized <T> void clearThresholdListeners(Map<String, T> thresholds, String namespace) {
        thresholds.keySet().forEach(this::doRemoveListener);
        thresholds.clear();
        StatsMonitor.updateInRepository(namespace, thresholds);
    }

    private static <T> void updateInRepository(String namespace, Map<String, T> thresholds) {
        try {
            RepositoryUtils.bindObject(namespace, THRESHOLDS_INSTANCE_NAME, thresholds);
        }
        catch (ObjectConfigurationException exception) {
            Trace.logException(StatsMonitor.class, exception, true);
            Trace.logError(StatsMonitor.class, "Update thresholds in repository failed.");
        }
    }

    protected SystemEnvironment doGetSystemEnvironment() {
        SystemEnvironment stats = new SystemEnvironment();
        stats.osName = this.osBean.getName();
        stats.osArchitecture = this.osBean.getArch();
        stats.osVersion = this.osBean.getVersion();
        stats.processorsNumber = this.osBean.getAvailableProcessors();
        stats.totalPhysicalMemorySize = this.osBean.getTotalPhysicalMemorySize();
        stats.totalSwapSpaceSize = this.osBean.getTotalSwapSpaceSize();
        stats.jvmName = this.runtimeBean.getVmName();
        stats.jvmVendor = this.runtimeBean.getVmVendor();
        stats.jvmVersion = this.runtimeBean.getVmVersion();
        stats.jvmStartTime = this.runtimeBean.getStartTime();
        return stats;
    }

    protected RuntimeStats doGetRuntimeStats() {
        long[] threadIds;
        RuntimeStats stats = new RuntimeStats(this.context.getName());
        stats.freePhysicalMemorySize = this.osBean.getFreePhysicalMemorySize();
        stats.freeSwapSpaceSize = this.osBean.getFreeSwapSpaceSize();
        stats.systemCpuUsage = this.getCpuLoad(GET_SYSTEM_CPU_LOAD);
        stats.jvmUpTime = this.runtimeBean.getUptime();
        stats.jvmCpuUsage = this.getCpuLoad(GET_PROCESS_CPU_LOAD);
        stats.heapMemoryUsageAdapter = new MemoryUsageAdapter(this.memoryBean.getHeapMemoryUsage());
        stats.nonHeapMemoryUsageAdapter = new MemoryUsageAdapter(this.memoryBean.getNonHeapMemoryUsage());
        stats.memoryPoolsStats.addAll(this.memoryPoolBeans.stream().map(bean -> new MemoryPoolStats(bean.getName(), bean.getType(), bean.getUsage(), bean.getPeakUsage())).collect(Collectors.toList()));
        for (long threadId : threadIds = this.threadBean.getAllThreadIds()) {
            try {
                ThreadInfo info = this.threadBean.getThreadInfo(threadId);
                if (info == null) continue;
                stats.threadsStats.add(new ThreadStats(info.getThreadId(), info.getThreadName(), info.getThreadState()));
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Obtaining info for thread '" + threadId + "' failed.");
            }
        }
        stats.totalDiskSpace = this.file.getTotalSpace();
        stats.freeDiskSpace = this.file.getUsableSpace();
        return stats;
    }

    private static Method getMethod(String methodName) {
        try {
            return OperatingSystemMXBean.class.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private double getCpuLoad(Method method) {
        try {
            return method != null ? (Double)method.invoke((Object)this.osBean, new Object[0]) : -1.0;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    private class Monitor
    extends MonitorDaemonWorker {
        public Monitor(int samplingInterval) throws FabricException {
            super("FSYS:Stats.Monitor", "Monitors JVM statistics.", samplingInterval);
        }

        protected void prepare() {
            if (!StatsMonitor.this.listeners.isEmpty()) {
                SystemEnvironment stats = StatsMonitor.this.doGetSystemEnvironment();
                for (StatsListener listener : StatsMonitor.this.listeners.values()) {
                    listener.onSystemEnvironment(stats);
                }
            }
        }

        @Override
        protected synchronized void doExecute() {
            RuntimeStats stats = StatsMonitor.this.doGetRuntimeStats();
            for (StatsListener listener : StatsMonitor.this.listeners.values()) {
                listener.onStats(stats);
            }
        }

        @Override
        protected boolean hasTasks() {
            return !StatsMonitor.this.listeners.isEmpty();
        }
    }

    static class ThresholdImpl
    implements Threshold {
        private String key;
        private int value;

        ThresholdImpl(String key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }

    static class CpuThresholdImpl
    extends ThresholdImpl
    implements CpuThreshold {
        private volatile int interval;

        CpuThresholdImpl(String key, int value, int interval) {
            super(key, value);
            this.interval = interval;
        }

        @Override
        public int getInterval() {
            return this.interval;
        }

        void setInterval(int interval) {
            this.interval = interval;
        }
    }
}

