/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.stats;

import com.streamscape.runtime.stats.MemoryPoolStats;
import com.streamscape.runtime.stats.MemoryUsageAdapter;
import com.streamscape.runtime.stats.ThreadStats;
import com.streamscape.sdo.CloneableDataObject;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;

public class RuntimeStats
extends CloneableDataObject {
    String nodeName;
    long freePhysicalMemorySize;
    long freeSwapSpaceSize;
    double systemCpuUsage;
    long jvmUpTime;
    double jvmCpuUsage;
    MemoryUsageAdapter heapMemoryUsageAdapter;
    MemoryUsageAdapter nonHeapMemoryUsageAdapter;
    List<MemoryPoolStats> memoryPoolsStats = new ArrayList<MemoryPoolStats>();
    List<ThreadStats> threadsStats = new ArrayList<ThreadStats>();
    long totalDiskSpace;
    long freeDiskSpace;

    RuntimeStats(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public long getFreePhysicalMemorySize() {
        return this.freePhysicalMemorySize;
    }

    public long getFreeSwapSpaceSize() {
        return this.freeSwapSpaceSize;
    }

    public double getSystemCpuUsage() {
        return this.systemCpuUsage;
    }

    public long getJvmUpTime() {
        return this.jvmUpTime;
    }

    public double getJvmCpuUsage() {
        return this.jvmCpuUsage;
    }

    public long getUsedMemorySize() {
        return this.getHeapUsedMemorySize() + this.getNonHeapUsedMemorySize();
    }

    public long getFreeMemorySize() {
        return this.getHeapFreeMemorySize() + this.getNonHeapFreeMemorySize();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.heapMemoryUsageAdapter.getMemoryUsage();
    }

    public long getHeapUsedMemorySize() {
        return this.heapMemoryUsageAdapter.getMemoryUsage().getUsed();
    }

    public long getHeapFreeMemorySize() {
        MemoryUsage heapMemoryUsage = this.heapMemoryUsageAdapter.getMemoryUsage();
        return heapMemoryUsage.getCommitted() - heapMemoryUsage.getUsed();
    }

    public MemoryUsage getNonHeapMemoryUsage() {
        return this.nonHeapMemoryUsageAdapter.getMemoryUsage();
    }

    public long getNonHeapUsedMemorySize() {
        return this.nonHeapMemoryUsageAdapter.getMemoryUsage().getUsed();
    }

    public long getNonHeapFreeMemorySize() {
        MemoryUsage nonHeapMemoryUsage = this.nonHeapMemoryUsageAdapter.getMemoryUsage();
        return nonHeapMemoryUsage.getCommitted() - nonHeapMemoryUsage.getUsed();
    }

    public List<MemoryPoolStats> getMemoryPoolsStats() {
        return this.memoryPoolsStats;
    }

    public List<ThreadStats> getThreadStats() {
        return this.threadsStats;
    }

    public long getTotalDiskSpace() {
        return this.totalDiskSpace;
    }

    public long getFreeDiskSpace() {
        return this.freeDiskSpace;
    }

    public long getUsedDiskSpace() {
        return this.totalDiskSpace - this.freeDiskSpace;
    }

    public double getDiskUsage() {
        return (double)this.getUsedDiskSpace() / (double)this.totalDiskSpace;
    }
}

