/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.stats;

import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.runtime.stats.ThresholdListenerImpl;
import com.streamscape.runtime.stats.threshold.MemoryThresholdAdvisory;
import com.streamscape.runtime.stats.threshold.Threshold;
import com.streamscape.runtime.stats.threshold.ThresholdAdvisoryType;

class MemoryThresholdListenerImpl
extends ThresholdListenerImpl {
    private static final int MB = 0x100000;

    MemoryThresholdListenerImpl(Threshold threshold) {
        super(threshold);
    }

    @Override
    boolean isAboveThreshold(RuntimeStats stats) {
        return stats.getUsedMemorySize() >= (long)(this.threshold.getValue() * 0x100000);
    }

    @Override
    boolean isBelowThreshold(RuntimeStats stats) {
        return stats.getUsedMemorySize() < (long)(this.threshold.getValue() * 0x100000);
    }

    @Override
    void raiseAdvisory(ThresholdAdvisoryType type, RuntimeStats stats) {
        this.raiseAdvisory(new MemoryThresholdAdvisory(type, this.threshold, (int)(stats.getUsedMemorySize() / 0x100000L), stats.getMemoryPoolsStats()));
    }
}

