/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.stats;

import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.runtime.stats.ThresholdListenerImpl;
import com.streamscape.runtime.stats.threshold.DiskThresholdAdvisory;
import com.streamscape.runtime.stats.threshold.Threshold;
import com.streamscape.runtime.stats.threshold.ThresholdAdvisoryType;

class DiskThresholdListenerImpl
extends ThresholdListenerImpl {
    DiskThresholdListenerImpl(Threshold threshold) {
        super(threshold);
    }

    @Override
    boolean isAboveThreshold(RuntimeStats stats) {
        return DiskThresholdListenerImpl.getDiskUsage(stats) >= this.threshold.getValue();
    }

    @Override
    boolean isBelowThreshold(RuntimeStats stats) {
        return DiskThresholdListenerImpl.getDiskUsage(stats) < this.threshold.getValue();
    }

    @Override
    void raiseAdvisory(ThresholdAdvisoryType type, RuntimeStats stats) {
        this.raiseAdvisory(new DiskThresholdAdvisory(type, this.threshold, DiskThresholdListenerImpl.getDiskUsage(stats)));
    }

    private static int getDiskUsage(RuntimeStats stats) {
        return (int)(Math.abs(stats.getDiskUsage()) * 100.0);
    }
}

