/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.stats;

import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.runtime.stats.StatsMonitor;
import com.streamscape.runtime.stats.ThresholdListenerImpl;
import com.streamscape.runtime.stats.threshold.CpuThreshold;
import com.streamscape.runtime.stats.threshold.CpuThresholdAdvisory;
import com.streamscape.runtime.stats.threshold.ThresholdAdvisoryType;

class CpuThresholdListenerImpl
extends ThresholdListenerImpl {
    private int counter = 0;

    CpuThresholdListenerImpl(CpuThreshold threshold) {
        super(threshold);
    }

    void setInterval(int interval) {
        ((StatsMonitor.CpuThresholdImpl)this.threshold).setInterval(interval);
    }

    @Override
    boolean isAboveThreshold(RuntimeStats stats) {
        return this.isThresholdExceeded(CpuThresholdListenerImpl.getCpuUsage(stats) >= this.threshold.getValue());
    }

    @Override
    boolean isBelowThreshold(RuntimeStats stats) {
        return this.isThresholdExceeded(CpuThresholdListenerImpl.getCpuUsage(stats) < this.threshold.getValue());
    }

    private boolean isThresholdExceeded(boolean condition) {
        this.counter = condition ? ++this.counter : 0;
        if (this.getCurrentInterval() >= ((CpuThreshold)this.threshold).getInterval()) {
            this.counter = 0;
            return true;
        }
        return false;
    }

    private int getCurrentInterval() {
        return (int)((double)this.counter * ((double)this.monitor.getSamplingInterval() / 1000.0));
    }

    @Override
    void raiseAdvisory(ThresholdAdvisoryType type, RuntimeStats stats) {
        this.raiseAdvisory(new CpuThresholdAdvisory(type, this.threshold, CpuThresholdListenerImpl.getCpuUsage(stats)));
    }

    private static int getCpuUsage(RuntimeStats stats) {
        return stats.getJvmCpuUsage() > 0.0 ? (int)(Math.abs(stats.getJvmCpuUsage()) * 100.0) : 0;
    }
}

