/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.type;

import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class UnregisterTypeOperation
extends AbstractSemanticTypeOperation {
    public static final String NAME = "unregister type";

    public UnregisterTypeOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("UNREGISTER").setPredicate((ChoiceModifier)new ChoiceModifier().addPossibleValues("SDO", "TYPE").setIncludeToDefinition(true));
        this.syntax.addParameter(new IdentifierParameter("TypeName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FORCE").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("IF EXISTS").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("unregister type <TypeName>           - Unregisters the specified semantic type.\nunregister type <TypeName> force     - Unregisters the specified semantic type without checking for dependencies (e.g. event prototypes).\nunregister type <TypeName> if exists - Unregisters the specified semantic type if type exists.");
        this.syntax.addCompletionCommand("list types");
        this.syntax.setHiddenAlias("unregister semantic type");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.resolveTypeName(statement.getParameter("TypeName").getValue()), statement.existsModifier("FORCE"), statement.existsModifier("IF EXISTS"));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getSemanticTypeCache().listUserSemanticTypes());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SemanticType type = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(definition.typeName);
        if (type == null) {
            if (definition.ifExists) {
                return new SLResponse();
            }
            return new SLResponse("Semantic type not found.", false);
        }
        if (type.isSystem()) {
            return new SLResponse("System semantic type cannot be removed.", false);
        }
        TypeFactory.removeSemanticType(type.getTypeName(), definition.isForce);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String typeName;
        private boolean isForce;
        private boolean ifExists;

        public Definition(String typeName, boolean isForce, boolean ifExists) {
            super(UnregisterTypeOperation.NAME);
            this.typeName = typeName;
            this.isForce = isForce;
            this.ifExists = ifExists;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isForce() {
            return this.isForce;
        }
    }
}

