/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.type;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.runtime.mf.operation.edl.annotations.Default;
import com.streamscape.runtime.mf.operation.edl.annotations.Description;
import com.streamscape.runtime.mf.operation.edl.annotations.Domain;
import com.streamscape.runtime.mf.operation.edl.annotations.Enum;
import com.streamscape.runtime.mf.operation.edl.annotations.Implicit;
import com.streamscape.runtime.mf.operation.edl.annotations.ImplicitMap;
import com.streamscape.runtime.mf.operation.edl.annotations.Key;
import com.streamscape.runtime.mf.operation.edl.annotations.Length;
import com.streamscape.runtime.mf.operation.edl.annotations.NotNull;
import com.streamscape.runtime.mf.operation.edl.annotations.Offset;
import com.streamscape.runtime.mf.operation.edl.annotations.Precision;
import com.streamscape.runtime.mf.operation.edl.annotations.Range;
import com.streamscape.runtime.mf.operation.edl.annotations.Regexp;
import com.streamscape.runtime.mf.operation.edl.annotations.Scale;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType1;
import com.streamscape.runtime.mf.operation.edl.annotations.SemanticType2;
import com.streamscape.runtime.mf.operation.edl.annotations.SuppressGenericType;
import com.streamscape.runtime.mf.operation.edl.annotations.Value;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowException;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sdrpath.ReferencePathException;
import com.streamscape.sef.evtrigger.function.SemanticTypeLookupContext;
import com.streamscape.sef.evtrigger.function.TriggerFunctionParserContextImpl;
import com.streamscape.sef.evtrigger.function.types.AbstractObjectType;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.slex.lang.AbstractDSLOperation;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SemanticTypeEntitiesDescriber {
    private boolean entities;
    private String entity;
    private FabricContext context;

    public SemanticTypeEntitiesDescriber(boolean entities, String entity, FabricContext context) {
        this.entities = entities;
        this.entity = entity;
        this.context = context;
    }

    public RowSet describe(Class<?> clazz) throws Exception {
        RowSet result = new RowSet(this.createResultDescriptorForEntries());
        if (this.entities) {
            for (Field field : this.getAllFields(clazz)) {
                this.addEntity(result, field);
            }
        } else {
            int pos = this.entity.lastIndexOf(46);
            Object parentSpath = "//";
            String entityName = this.entity;
            if (pos != -1) {
                entityName = this.entity.substring(pos + 1);
                parentSpath = (String)parentSpath + this.entity.substring(0, pos);
                parentSpath = ((String)parentSpath).replace('.', '/');
            }
            try {
                clazz = this.context.getSDRManagerFactory().createManager().getTypeAtPath((String)parentSpath, clazz);
            }
            catch (ReferencePathException exception) {
                throw new Exception("Entity with path '" + this.entity + "' doesn't exist.");
            }
            if (entityName.length() == 0) {
                for (Field field : this.getAllFields(clazz)) {
                    this.addEntity(result, field);
                }
            } else {
                String finalEntityName = entityName;
                Field field = this.getAllFields(clazz).stream().filter(f -> f.getName().equals(finalEntityName)).findAny().orElse(null);
                if (field == null) {
                    throw new Exception("Entity with path '" + this.entity + "' does not exist.");
                }
                this.addEntity(result, field);
            }
        }
        return result;
    }

    private void addEntity(RowSet result, Field field) {
        Row row = result.newRow();
        try {
            ArrayList<Object> values;
            Annotation annotation;
            TriggerFunctionParserContextImpl parserContext = new TriggerFunctionParserContextImpl(this.context);
            Type<?> type = TypeFactory.resolveFieldType(field, parserContext);
            String name = field.getName();
            String typeDefinition = "";
            String defaultValue = "";
            String notNull = "false";
            String length = "";
            String range = "";
            String domain = "";
            String matches = "";
            String isEnum = "false";
            Object offset = "";
            String description = "";
            if (field.getAnnotation(NotNull.class) != null) {
                notNull = "true";
            }
            if ((annotation = field.getAnnotation(Length.class)) != null) {
                length = String.valueOf(annotation.value());
            }
            if ((annotation = field.getAnnotation(Regexp.class)) != null) {
                matches = annotation.value();
            }
            if ((annotation = field.getAnnotation(Offset.class)) != null) {
                offset = annotation.begin() + " - " + annotation.end();
            }
            if ((annotation = field.getAnnotation(Description.class)) != null) {
                description = annotation.value();
            }
            if ((annotation = field.getAnnotation(Domain.class)) != null && ((domain = annotation.name()) == null || domain.length() == 0)) {
                values = new ArrayList<Object>();
                for (String value : annotation.values()) {
                    values.add(type.escapeValue(value));
                }
                domain = ((Object)values).toString();
            }
            if ((annotation = field.getAnnotation(Range.class)) != null && ((range = annotation.name()) == null || range.length() == 0)) {
                values = new ArrayList();
                for (int i = 0; i < annotation.startvalues().length; ++i) {
                    values.add(type.escapeValue(annotation.startvalues()[i]) + " - " + type.escapeValue(annotation.endvalues()[i]));
                }
                range = ((Object)values).toString();
            }
            if ((annotation = field.getAnnotation(Enum.class)) != null) {
                isEnum = "true";
            }
            Pair<String, String> pair = this.getTypeDefinition(field, field.getType(), parserContext, 0);
            typeDefinition = (String)pair.first;
            defaultValue = (String)pair.second;
            if (field.getType().isEnum()) {
                isEnum = "true";
            }
            row.setColumn(1, (Object)name);
            row.setColumn(2, (Object)typeDefinition);
            row.setColumn(3, (Object)defaultValue);
            row.setColumn(4, (Object)notNull);
            row.setColumn(5, (Object)length);
            row.setColumn(6, (Object)range);
            row.setColumn(7, (Object)domain);
            row.setColumn(8, (Object)matches);
            row.setColumn(9, (Object)isEnum);
            row.setColumn(10, offset);
            row.setColumn(11, (Object)description);
            result.addToRowSet(row);
        }
        catch (RowException | SQLException exception) {
            Trace.logException(this, exception, true);
        }
    }

    private Pair<String, String> getTypeDefinition(Field field, Class<?> fieldType, TriggerFunctionParserContextImpl parserContext, int level) {
        Object typeDefinition;
        Annotation semanticTypeAnnotation;
        boolean isImplicit = false;
        boolean suppressGenericType = false;
        String[] semanticTypes = null;
        Default defaultValueAnnotation = null;
        if (level == 0) {
            defaultValueAnnotation = field.getAnnotation(Default.class);
            semanticTypeAnnotation = field.getAnnotation(SemanticType.class);
            if (semanticTypeAnnotation != null) {
                semanticTypes = new String[]{semanticTypeAnnotation.type(), semanticTypeAnnotation.type1(), semanticTypeAnnotation.alias()};
            }
            isImplicit = field.getAnnotation(Implicit.class) != null;
            suppressGenericType = field.getAnnotation(SuppressGenericType.class) != null;
        } else if (level == 1) {
            semanticTypeAnnotation = field.getAnnotation(SemanticType1.class);
            if (semanticTypeAnnotation != null) {
                semanticTypes = new String[]{semanticTypeAnnotation.type(), semanticTypeAnnotation.type1(), semanticTypeAnnotation.alias()};
            }
        } else if (level == 2 && (semanticTypeAnnotation = field.getAnnotation(SemanticType2.class)) != null) {
            semanticTypes = new String[]{semanticTypeAnnotation.type(), semanticTypeAnnotation.type1(), semanticTypeAnnotation.alias()};
        }
        String defaultValue = "";
        Type<?> type = TypeFactory.resolveType(fieldType, (SemanticTypeLookupContext)parserContext);
        if (fieldType.isArray() || Collection.class.isAssignableFrom(fieldType)) {
            if (fieldType.isArray()) {
                type = TypeFactory.resolveType(field.getType().getComponentType(), (SemanticTypeLookupContext)parserContext);
                typeDefinition = this.getTypeName(field, type) + "[]";
            } else {
                typeDefinition = "list(";
                if (semanticTypes != null && semanticTypes[0] != null) {
                    try {
                        type = TypeFactory.resolveType(semanticTypes[0], (SemanticTypeLookupContext)parserContext);
                        Class<?> typeClass = TypeFactory.resolveClass(type, parserContext);
                        typeDefinition = (String)typeDefinition + (String)this.getTypeDefinition((Field)field, typeClass, (TriggerFunctionParserContextImpl)parserContext, (int)(level + 1)).first;
                    }
                    catch (ClassNotFoundException exception) {
                        Trace.logException(this, exception, true);
                    }
                }
                if (semanticTypes != null && semanticTypes[2] != null && semanticTypes[2].length() > 0) {
                    typeDefinition = (String)typeDefinition + " alias " + semanticTypes[2];
                }
                if (isImplicit) {
                    typeDefinition = (String)typeDefinition + ", xml-implicit-collection";
                }
                if (suppressGenericType) {
                    typeDefinition = (String)typeDefinition + ", json-suppress-generic-type";
                }
                typeDefinition = (String)typeDefinition + ")";
            }
            if (defaultValueAnnotation != null && defaultValueAnnotation.values() != null) {
                ArrayList<String> values = new ArrayList<String>();
                for (String value : defaultValueAnnotation.values()) {
                    values.add(type.escapeValue(value));
                }
                defaultValue = ((Object)values).toString();
            } else {
                defaultValue = field.getType().isArray() ? "Null filled array" : "Empty List";
            }
        } else if (Map.class.isAssignableFrom(fieldType)) {
            typeDefinition = "map(";
            ImplicitMap isImplicitMapAnnotation = field.getAnnotation(ImplicitMap.class);
            if (isImplicitMapAnnotation == null && semanticTypes != null) {
                try {
                    Type<?> keyType = TypeFactory.resolveType(semanticTypes[0], (SemanticTypeLookupContext)parserContext);
                    Type<?> valueType = TypeFactory.resolveType(semanticTypes[1], (SemanticTypeLookupContext)parserContext);
                    typeDefinition = (String)typeDefinition + this.getTypeName(null, keyType) + ", " + (String)this.getTypeDefinition((Field)field, TypeFactory.resolveClass(valueType, (SemanticTypeLookupContext)parserContext), (TriggerFunctionParserContextImpl)parserContext, (int)(level + 1)).first;
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
            } else if (isImplicitMapAnnotation != null && semanticTypes != null) {
                String keyName = null;
                String valueName = null;
                try {
                    Type<?> entryType = TypeFactory.resolveType(semanticTypes[0], (SemanticTypeLookupContext)parserContext);
                    typeDefinition = (String)typeDefinition + this.getTypeName(null, entryType) + "(";
                    Class entryClass = ClassUtils.loadClass(semanticTypes[0], this.context.getSystemClassLoaderChain());
                    for (Field field1 : entryClass.getFields()) {
                        if (field1.getAnnotation(Key.class) != null) {
                            Type<?> keyType = TypeFactory.resolveType(field1.getType(), (SemanticTypeLookupContext)parserContext);
                            keyName = this.getTypeName(field1, keyType) + " " + field1.getName();
                        }
                        if (field1.getAnnotation(Value.class) == null) continue;
                        Type<?> valueType = TypeFactory.resolveType(field1.getType(), (SemanticTypeLookupContext)parserContext);
                        valueName = this.getTypeName(field1, valueType) + " " + field1.getName();
                    }
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                }
                if (keyName != null) {
                    typeDefinition = (String)typeDefinition + keyName;
                }
                if (valueName != null) {
                    typeDefinition = (String)typeDefinition + ", " + valueName;
                }
                typeDefinition = (String)typeDefinition + ")";
            }
            if (isImplicit) {
                typeDefinition = (String)typeDefinition + ", xml-implicit-collection";
            }
            if (suppressGenericType) {
                typeDefinition = (String)typeDefinition + ", json-suppress-generic-type";
            }
            typeDefinition = (String)typeDefinition + ")";
            defaultValue = "Empty Map";
        } else {
            typeDefinition = this.getTypeName(field, type);
            if (defaultValueAnnotation != null) {
                defaultValue = defaultValueAnnotation.value();
            }
        }
        return new Pair<Object, String>(typeDefinition, defaultValue);
    }

    private RowMetaData createResultDescriptorForEntries() {
        RowMetaData result = new RowMetaData();
        AbstractDSLOperation.addColumn(result, "Element Name");
        AbstractDSLOperation.addColumn(result, "Type");
        AbstractDSLOperation.addColumn(result, "Default Value");
        AbstractDSLOperation.addColumn(result, "Not null");
        AbstractDSLOperation.addColumn(result, "Length");
        AbstractDSLOperation.addColumn(result, "Range");
        AbstractDSLOperation.addColumn(result, "Domain");
        AbstractDSLOperation.addColumn(result, "Matches");
        AbstractDSLOperation.addColumn(result, "Enum");
        AbstractDSLOperation.addColumn(result, "Offset");
        AbstractDSLOperation.addColumn(result, "Description");
        return result;
    }

    private List<Field> getAllFields(Class<?> clazz) {
        return ClassUtils.getAllFields(clazz).stream().filter(field -> !field.isSynthetic() && !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
    }

    protected String getTypeName(Field field, Type<?> fieldType) {
        if (fieldType instanceof AbstractObjectType) {
            return fieldType.getName();
        }
        Object typeName = fieldType.getName();
        if (field != null && !field.getType().isEnum()) {
            Precision precision = field.getAnnotation(Precision.class);
            Scale scale = field.getAnnotation(Scale.class);
            if (precision != null) {
                typeName = (String)typeName + "(" + precision.value();
                if (scale != null) {
                    typeName = (String)typeName + "," + scale.value();
                }
                typeName = (String)typeName + ")";
            }
        }
        return typeName;
    }
}

