/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.type;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.Map;

public class SelectAncestorTreeOperation
extends AbstractSemanticTypeOperation {
    public static final String NAME = "select ancestor tree";

    public SelectAncestorTreeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SELECT ANCESTOR TREE");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ALL", false).setAlias("*")).setSyntaxHintSpace());
        this.syntax.addModifier(new CompoundModifier("AsFormat", false).addModifier(new Modifier("AS")).addModifier(new ChoiceModifier("Format").addPossibleValues("XML", "JSON")));
        this.syntax.setDescription("Returns an object containing a tree of ancestors for user semantic types.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all     - Returns a tree of ancestors for all (system and user) semantic types.\n   as xml  - Shows the result object in XML format.\n   as json - Shows the result object in JSON format.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("ALL"), statement.existsModifier("XML"), statement.existsModifier("JSON"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Map<String, Object> map;
        Definition definition = (Definition)statement;
        Map<String, Object> map2 = map = definition.isAll ? ((RuntimeContext)this.callable).getSemanticTypeCache().getAncestorTree() : ((RuntimeContext)this.callable).getSemanticTypeCache().getUserAncestorTree();
        if (definition.asXML) {
            return new SLResponse(((RuntimeContext)this.callable).getXSerializer().serialize(map));
        }
        if (definition.asJSON) {
            return new SLResponse(((RuntimeContext)this.callable).getJSONSerializer().serialize(map));
        }
        RowSet rowSet = new RowSet(SelectAncestorTreeOperation.createResultDescriptor());
        SelectAncestorTreeOperation.addValues(rowSet, map);
        return new SLResponse(rowSet);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        SelectAncestorTreeOperation.addGenericColumn(result, "Ancestors");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        private boolean isAll;
        private boolean asXML;
        private boolean asJSON;

        public Definition(boolean isAll, boolean asXML, boolean asJSON) {
            super(SelectAncestorTreeOperation.NAME);
            this.isAll = isAll;
            this.asXML = asXML;
            this.asJSON = asJSON;
        }
    }
}

