/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.type;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;

public class RegisterTypeOperation
extends AbstractSemanticTypeOperation {
    public static final String NAME = "register type";

    public RegisterTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REGISTER").setPredicate((ChoiceModifier)new ChoiceModifier().addPossibleValues("SDO", "TYPE").setIncludeToDefinition(true));
        this.syntax.addParameter(new IdentifierParameter("TypeName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("CLASS").addParameter(new IdentifierParameter("ClassName"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("DESCRIPTION").addParameter(new StringParameter("Description", Character.valueOf('\''), Character.valueOf('\'')))).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ANCESTOR").addParameter(new IdentifierParameter("AncestorType"))).setRequired(false));
        this.syntax.setDescription("Registers a new semantic type with the specified name.");
        this.syntax.setSyntaxDescription("Name must not contain whitespace characters.\nMandatory parameters:\n   class       - class name of the created type.\nOptional parameters (must be separated by commas):\n   description - description of the created type.\n   ancestor    - name of ancestor type of the created type.");
        this.syntax.setExamples("register type Example1 class com.streamscape.Example1\nregister type Example2 class com.streamscape.Example2 description 'Example type.'\nregister type Example3 class com.streamscape.Example3 description 'Example type.' ancestor Example2");
        this.syntax.setHiddenAlias("register semantic type");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition result = new Definition(this.resolveTypeName(statement.getParameter("TypeName").getValue()), statement.getParameter("ClassName").getValue());
        result.setDescription(statement.getParameter("Description").getValue());
        result.setAncestor(statement.getParameter("AncestorType").getValue());
        return result;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (((RuntimeContext)this.callable).getSemanticTypeCache().existsSemanticType(definition.typeName)) {
            return new SLResponse("Semantic type '" + definition.typeName + "' already exists.", false);
        }
        SemanticType semanticType = new SemanticType(definition.typeName, definition.className);
        try {
            Class typeClass = ClassUtils.loadClass(definition.className, ((RuntimeContext)this.callable).getSystemClassLoaderChain());
            semanticType.setInterface(typeClass.isInterface());
        }
        catch (ClassNotFoundException exception) {
            return new SLResponse("Class '" + definition.className + "' not found.", false);
        }
        catch (Exception exception) {
            return new SLResponse("Class '" + definition.className + "' is invalid.", false);
        }
        if (definition.description != null) {
            semanticType.setDescription(definition.description);
        }
        if (definition.ancestor != null) {
            if (!((RuntimeContext)this.callable).getSemanticTypeCache().existsSemanticType(definition.ancestor)) {
                return new SLResponse("Ancestor type '" + definition.ancestor + "' not found.", false);
            }
            semanticType.setAncestorType(definition.ancestor);
        }
        TypeFactory.addSemanticType(semanticType);
        return new SLResponse();
    }

    public static class Definition
    extends AbstractSLStatement {
        private String typeName;
        private String className;
        private String description;
        private String ancestor;

        public Definition(String typeName, String className) {
            super(RegisterTypeOperation.NAME);
            this.typeName = typeName;
            this.className = className;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getAncestor() {
            return this.ancestor;
        }

        public void setAncestor(String ancestor) {
            this.ancestor = ancestor;
        }
    }
}

