/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.type;

import com.streamscape.lib.analyzer.TypeAnalyzer;
import com.streamscape.lib.analyzer.TypeAnalyzerException;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphVisitor;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeOperation;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ListTypesOperation
extends AbstractSemanticTypeOperation {
    public static final String NAME = "list types";

    public ListTypesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST").setPredicate((ChoiceModifier)new ChoiceModifier().addPossibleValues("SDO", "TYPES").setIncludeToDefinition(true));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("ALL", false).setAlias("*")).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("WITH NESTED", false).addParameter((SyntaxParameter)new IdentifierParameter("Type").setCompletionAdviser(new AbstractOperation.SemanticTypeCompletionAdviser())));
        this.syntax.addModifier(ListTypesOperation.createLikeModifier());
        this.syntax.addModifier(new CompoundModifier(false).addModifier(new Modifier("CLASS")).addModifier((AbstractModifier)ListTypesOperation.createLikeModifier("ClassLikePattern", false).setName("ClassLikeModifier")));
        this.syntax.addModifier(new Modifier("DIRTY", false));
        this.syntax.addModifier(new CompoundModifier(false).addModifier(new Modifier("GROUP BY")).addModifier(new ChoiceModifier("GroupByChoice").addPossibleValues("ANCESTOR", "PACKAGE", "ARCHIVE")).addParameter((AbstractParameter)((IdentifierParameter)new IdentifierParameter("Value").setRequired(false)).setCompletionAdviser(new GroupByCompletionAdviser())));
        this.syntax.setDescription("Returns a list of user semantic types.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all         - Returns a list of all (system and user) semantic types.\n   with nested - Returns a list of semantic types that contain nested fields of the specified type.\n   class       - Adds information about the implementing class for each result type.\n   like        - Returns a list of semantic types whose name matches the specified pattern.\n   class like  - Returns a list of semantic types whose implementing class matches the specified pattern.\n   dirty       - Returns a list of dirty semantic types (whose package has been reloaded).\n   group by    - Returns a list of semantic types grouped by the specified property.\n\n" + ListTypesOperation.getLikeModifierDescription("                 ", ""));
        this.syntax.setExamples("list types\nlist types with nested TestType\nlist types like 'Test.*'\nlist types class\nlist types class like 'user.*'\nlist types with nested TestType class like 'user.*'\nlist types primitive\nlist types complex class\nlist types all like '.*XMPP.*'\nlist types all group by ancestor\nlist types all group by ancestor complex");
        this.syntax.setHiddenAlias("list semantic types");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.existsModifier("ALL"), statement.existsParameter("Type") ? statement.getParameter("Type").getValue() : null, statement.existsModifier("CLASS"), ListTypesOperation.getLikeParameterValue(statement), ListTypesOperation.getLikeParameterValue(statement, "ClassLikePattern"), statement.existsModifier("DIRTY"), statement.existsModifier("GroupByChoice") ? GroupBy.valueOf(statement.getModifier("GroupByChoice").getToken()) : null, statement.existsParameter("Value") ? statement.getParameter("Value").getValue() : null);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        String nestedClassName;
        Definition definition = (Definition)statement;
        SemanticTypeCache cache = ((RuntimeContext)this.callable).getSemanticTypeCache();
        String string = nestedClassName = definition.nestedType != null ? cache.resolveSemanticType(definition.nestedType) : null;
        if (definition.nestedType != null && nestedClassName == null) {
            throw new Exception("Nested semantic type not found.");
        }
        TypeAnalyzer typeAnalyzer = definition.nestedType != null ? ((RuntimeContext)this.callable).getTypeAnalyzerFactory().createTypeAnalyzer() : null;
        Pattern pattern = ListTypesOperation.compileExtendedPattern(definition.pattern);
        Pattern classPattern = ListTypesOperation.compileExtendedPattern(definition.classPattern);
        String ancestor = null;
        if (definition.groupBy == GroupBy.ANCESTOR && definition.groupByValue != null) {
            ancestor = definition.groupByValue;
            int iLastDot = definition.groupByValue.lastIndexOf(46);
            if (iLastDot != -1) {
                definition.groupByValue = definition.groupByValue.substring(iLastDot + 1);
            }
        }
        if (definition.groupBy == GroupBy.PACKAGE && definition.groupByValue != null && !SpecialGroup.equals(definition.groupByValue) && !((RuntimeContext)this.callable).getPackageManifestManager().existsPackage(definition.groupByValue)) {
            throw new Exception("Package not found.");
        }
        TreeMap<String, String> jarsByType = new TreeMap<String, String>();
        TreeSet<String> jarTypes = new TreeSet<String>();
        this.mapTypesToJars(definition, jarsByType, jarTypes);
        List<SemanticType> types = (definition.isAll ? cache.listSemanticTypes() : cache.listUserSemanticTypes()).stream().map(cache::lookupSemanticType).filter(type -> type != null && this.matchesNestedType((SemanticType)type, nestedClassName, typeAnalyzer) && this.matchesPattern((SemanticType)type, pattern, classPattern, cache) && this.matchesDirty((SemanticType)type, definition) && this.matchesGroup((SemanticType)type, definition, (Set<String>)jarTypes, (Map<String, String>)jarsByType)).collect(Collectors.toList());
        AbstractDSLOperation.OperationResult result = new AbstractDSLOperation.OperationResult(ListTypesOperation.createResultDescriptor(definition.withClass, definition.isAll, definition.groupBy));
        if (definition.groupBy != null) {
            Map<String, List<SemanticType>> typesByGroup = this.mapTypesByGroup(types, definition, jarsByType);
            for (String group : typesByGroup.keySet()) {
                boolean firstTime = true;
                for (SemanticType type2 : typesByGroup.get(group)) {
                    Object[] objectArray = new Object[7];
                    objectArray[0] = firstTime ? (ancestor != null ? ancestor : group) : "";
                    objectArray[1] = type2.getTypeName();
                    objectArray[2] = new AbstractDSLOperation.OptionalValue(definition.withClass, type2::getClassName);
                    objectArray[3] = new AbstractDSLOperation.OptionalValue(definition.groupBy != GroupBy.ANCESTOR, type2::getAncestorType);
                    objectArray[4] = new AbstractDSLOperation.OptionalValue(definition.isAll, type2::isSystem);
                    objectArray[5] = SemanticUtils.isSemanticTypeGlobal(type2, (RuntimeContext)this.callable);
                    objectArray[6] = type2.isValid();
                    result.add(objectArray);
                    if (!firstTime) continue;
                    firstTime = false;
                }
            }
        } else {
            for (SemanticType type3 : types) {
                Object[] objectArray = new Object[6];
                objectArray[0] = type3.getTypeName();
                objectArray[1] = new AbstractDSLOperation.OptionalValue(definition.withClass, type3::getClassName);
                objectArray[2] = type3.getAncestorType();
                objectArray[3] = new AbstractDSLOperation.OptionalValue(definition.isAll, type3::isSystem);
                objectArray[4] = true;
                objectArray[5] = type3.isValid();
                result.add(objectArray);
            }
        }
        return result.getResponse();
    }

    private boolean matchesNestedType(SemanticType type, final String nestedClassName, TypeAnalyzer analyzer) {
        if (nestedClassName != null) {
            final Pair<Boolean, Boolean> result = new Pair<Boolean, Boolean>(false, false);
            try {
                analyzer.getTypeGraph("//{" + type.getClassName() + "}").traverse(new TypeGraphVisitor(){

                    @Override
                    public boolean visit(TypeGraph node, int level) throws TypeAnalyzerException {
                        Class<?> fieldClass;
                        if (level > 0 && (fieldClass = TypeAnalyzer.getRawClass(node.getType())) != null && nestedClassName.equals(fieldClass.getName())) {
                            result.first = true;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public void afterChildrenVisit(TypeGraph node, int level) throws TypeAnalyzerException {
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (Boolean)result.first;
        }
        return true;
    }

    private boolean matchesPattern(SemanticType type, Pattern typePattern, Pattern classPattern, SemanticTypeCache cache) {
        boolean matches = true;
        if (typePattern != null) {
            matches &= typePattern.matcher(type.getTypeName()).matches();
        }
        if (matches && classPattern != null) {
            String typeClassName = cache.resolveSemanticType(type.getTypeName());
            matches &= typeClassName != null && classPattern.matcher(typeClassName).matches();
        }
        return matches;
    }

    private boolean matchesDirty(SemanticType type, Definition definition) {
        return !definition.dirty || type.isDirty();
    }

    private boolean matchesGroup(SemanticType type, Definition definition, Set<String> jarTypes, Map<String, String> jarsByType) {
        if (definition.groupBy != null && definition.groupByValue != null) {
            switch (definition.groupBy.ordinal()) {
                case 0: {
                    return this.matchesAncestor(type, definition.groupByValue);
                }
                case 1: {
                    return this.matchesPackage(type, definition.groupByValue);
                }
                case 2: {
                    return this.matchesArchive(type, definition.groupByValue, jarTypes, jarsByType);
                }
            }
        }
        return true;
    }

    private boolean matchesAncestor(SemanticType type, String ancestor) {
        return type.getAncestorType().equals(ancestor);
    }

    private boolean matchesPackage(SemanticType type, String pkgName) {
        String typePkgName = this.getPackage(type);
        return typePkgName.equals(pkgName) || SpecialGroup.equals(pkgName) && typePkgName.equalsIgnoreCase(pkgName);
    }

    private boolean matchesArchive(SemanticType type, String jarName, Set<String> jarTypes, Map<String, String> jarsByType) {
        if (jarName.equalsIgnoreCase(SpecialGroup.SYSTEM.name())) {
            return type.isSystem();
        }
        String typeJarName = jarsByType.get(type.getTypeName());
        if (jarName.equalsIgnoreCase(SpecialGroup.AMBIGUOUS.name())) {
            return typeJarName != null && typeJarName.equals(SpecialGroup.AMBIGUOUS.toString());
        }
        if (jarName.equalsIgnoreCase(SpecialGroup.UNKNOWN.name())) {
            return !type.isSystem() && typeJarName == null;
        }
        return jarTypes.contains(type.getTypeName());
    }

    private Map<String, List<SemanticType>> mapTypesByGroup(List<SemanticType> types, Definition definition, Map<String, String> jarsByType) {
        TreeMap<String, List<SemanticType>> result = new TreeMap<String, List<SemanticType>>();
        types.forEach(type -> result.computeIfAbsent(this.getGroupForType((SemanticType)type, definition, jarsByType), k -> new ArrayList()).add(type));
        return result;
    }

    private String getGroupForType(SemanticType type, Definition definition, Map<String, String> jarsByType) {
        if (definition.groupByValue != null) {
            if (definition.groupBy == GroupBy.ANCESTOR || !SpecialGroup.equals(definition.groupByValue)) {
                return definition.groupByValue;
            }
            return StringUtils.toCapitalized(definition.groupByValue);
        }
        switch (definition.groupBy.ordinal()) {
            case 0: {
                return type.getAncestorType();
            }
            case 1: {
                return this.getPackage(type);
            }
            case 2: {
                return this.getArchive(type, jarsByType);
            }
        }
        return SpecialGroup.UNKNOWN.toString();
    }

    private String getPackage(SemanticType type) {
        if (type.isSystem()) {
            return SpecialGroup.SYSTEM.toString();
        }
        Package pkg = ((RuntimeContext)this.callable).getPackageLoaderRegistry().lookupPackageBySemanticType(type);
        return pkg != null ? pkg.getFullName() : SpecialGroup.UNKNOWN.toString();
    }

    private String getArchive(SemanticType type, Map<String, String> jarsByType) {
        if (type.isSystem()) {
            return SpecialGroup.SYSTEM.toString();
        }
        String jarName = jarsByType.get(type.getTypeName());
        return jarName != null ? jarName : SpecialGroup.UNKNOWN.toString();
    }

    private void mapTypesToJars(Definition definition, Map<String, String> jarsByType, Set<String> jarTypes) throws Exception {
        if (definition.groupBy == GroupBy.ARCHIVE) {
            try {
                if (definition.groupByValue != null && !SpecialGroup.equals(definition.groupByValue)) {
                    boolean isExtJar = false;
                    if (((RuntimeContext)this.callable).getRepositoryAccessor().existsExtensionArchive(definition.groupByValue)) {
                        isExtJar = true;
                    } else if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsArchive(definition.groupByValue)) {
                        throw new Exception("Archive not found.");
                    }
                    SemanticUtils.getRelatedSemanticTypes(definition.groupByValue, isExtJar, (RuntimeContext)this.callable).forEach(type -> jarTypes.add(type.getTypeName()));
                } else {
                    this.doGetArchivesByType(((RuntimeContext)this.callable).getRepositoryAccessor().listExtensionArchives(), true, jarsByType);
                    this.doGetArchivesByType(((RuntimeContext)this.callable).getRepositoryAccessor().listArchives(), false, jarsByType);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doGetArchivesByType(List<String> jars, boolean isExtJar, Map<String, String> result) {
        for (String jarName : jars) {
            try {
                SemanticUtils.getRelatedSemanticTypes(jarName, isExtJar, (RuntimeContext)this.callable).forEach(type -> {
                    if (result.containsKey(type.getTypeName())) {
                        result.put(type.getTypeName(), SpecialGroup.AMBIGUOUS.toString());
                    } else {
                        result.put(type.getTypeName(), jarName);
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    private static RowMetaData createResultDescriptor(boolean addClass, boolean addSystem, GroupBy groupBy) {
        RowMetaData result = new RowMetaData();
        if (groupBy != null) {
            ListTypesOperation.addColumn(result, groupBy.toColumnName());
        }
        ListTypesOperation.addColumn(result, "Type");
        if (addClass) {
            ListTypesOperation.addColumn(result, "Class");
        }
        if (groupBy != GroupBy.ANCESTOR) {
            ListTypesOperation.addColumn(result, GroupBy.ANCESTOR.toColumnName());
        }
        if (addSystem) {
            ListTypesOperation.addColumn(result, "System");
        }
        ListTypesOperation.addColumn(result, "Global");
        ListTypesOperation.addColumn(result, "Valid");
        return result;
    }

    private static class GroupByCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        private GroupByCompletionAdviser() {
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            if (processedScript.trim().endsWith(GroupBy.ANCESTOR.name().toLowerCase())) {
                ArrayList<String> result = new ArrayList<String>();
                this.addAncestorCompletions(callable.getSemanticTypeCache().getUserAncestorTree(), new ArrayList<String>(), result);
                return result;
            }
            if (processedScript.trim().endsWith(GroupBy.PACKAGE.name().toLowerCase())) {
                return callable.getPackageManifestManager().listLoadedPackages();
            }
            if (processedScript.trim().endsWith(GroupBy.ARCHIVE.name().toLowerCase())) {
                try {
                    ArrayList<String> result = new ArrayList<String>();
                    result.addAll(callable.getRepositoryAccessor().listExtensionArchives());
                    result.addAll(callable.getRepositoryAccessor().listArchives());
                    Collections.sort(result);
                    return result;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        private void addAncestorCompletions(Map<String, Object> node, List<String> nodeCompletions, List<String> result) {
            for (String ancestor : node.keySet()) {
                Object childNode = node.get(ancestor);
                if (childNode == null) continue;
                ArrayList<String> completions = new ArrayList<String>();
                completions.add(ancestor);
                for (String nodeCompletion : nodeCompletions) {
                    completions.add(nodeCompletion + "." + ancestor);
                }
                this.addAncestorCompletions((Map)childNode, completions, result);
                result.addAll(completions);
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    static class Definition
    extends AbstractSLStatement {
        boolean isAll;
        String nestedType;
        boolean withClass;
        String pattern;
        String classPattern;
        boolean dirty;
        GroupBy groupBy;
        String groupByValue;

        Definition(boolean isAll, String nestedType, boolean withClass, String pattern, String classPattern, boolean dirty, GroupBy groupBy, String groupByValue) {
            super(ListTypesOperation.NAME);
            this.isAll = isAll;
            this.nestedType = nestedType;
            this.withClass = withClass;
            this.pattern = pattern;
            this.classPattern = classPattern;
            this.dirty = dirty;
            this.groupBy = groupBy;
            this.groupByValue = groupByValue;
        }
    }

    static enum GroupBy {
        ANCESTOR,
        PACKAGE,
        ARCHIVE;


        String toColumnName() {
            switch (this.ordinal()) {
                case 0: {
                    return "Namespace";
                }
            }
            return StringUtils.toCapitalized(this.name().toLowerCase());
        }
    }

    static enum SpecialGroup {
        AMBIGUOUS,
        SYSTEM,
        UNKNOWN;


        public String toString() {
            return StringUtils.toCapitalized(this.name().toLowerCase());
        }

        static boolean equals(String value) {
            value = value.toUpperCase();
            return AMBIGUOUS.name().equals(value) || SYSTEM.name().equals(value) || UNKNOWN.name().equals(value);
        }
    }
}

