/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.type;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.PrefixCompleter;
import com.streamscape.slex.lang.completion.Suggestion;
import com.streamscape.slex.lang.completion.TokenSuggestion;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Timer;
import java.util.stream.Collectors;

public class EntityCompleter
implements PrefixCompleter {
    private RuntimeContext context;
    private String typeName;
    private Class<?> typeClass;

    public EntityCompleter(RuntimeContext context) {
        this.context = context;
    }

    @Override
    public DSLCompletion complete(String prefix) {
        DSLCompletion completion = new DSLCompletion();
        try {
            Class<?> entityType;
            Field entityField;
            SemanticType semanticType;
            if (this.typeClass == null && (semanticType = this.context.getSemanticTypeCache().lookupSemanticType(this.typeName)) != null) {
                this.typeClass = ClassUtils.loadClass(semanticType.getClassName(), this.context.getSystemClassLoaderChain());
            }
            Object entityName = prefix;
            String entityParent = "";
            boolean entityNameWithBracket = false;
            int pos = ((String)entityName).lastIndexOf(46);
            if (pos != -1) {
                entityParent = ((String)entityName).substring(0, pos);
                entityName = ((String)entityName).substring(pos + 1);
                String parentSpath = "//" + entityParent.replace('.', '/');
                this.typeClass = this.context.getSDRManagerFactory().createManager().getTypeAtPath(parentSpath, this.typeClass);
            }
            if (((String)entityName).indexOf(91) != -1) {
                entityName = ((String)entityName).substring(0, ((String)entityName).indexOf(91));
                entityNameWithBracket = true;
            }
            List<String> result = new ArrayList<String>();
            List<Field> fields = EntityCompleter.getAllFields(this.typeClass);
            String finalEntityName = entityName;
            if (!entityNameWithBracket) {
                result.addAll(fields.stream().map(Field::getName).filter(n -> n.startsWith(finalEntityName)).collect(Collectors.toList()));
            }
            if ((entityField = (Field)fields.stream().filter(f -> f.getName().equals(finalEntityName)).findAny().orElse(null)) == null && result.size() == 1) {
                entityField = fields.stream().filter(f -> f.getName().startsWith(finalEntityName)).findAny().orElse(null);
                entityName = (String)result.get(0);
            }
            if (entityField != null && !EntityCompleter.isPrimitive(entityType = entityField.getType())) {
                if (entityType.isArray() || Collection.class.isAssignableFrom(entityType)) {
                    try {
                        Class<?> componentTypeClass = this.context.getSDRManagerFactory().createManager().getTypeAtPath("//" + (String)entityName + "[0]", this.typeClass);
                        if (componentTypeClass != null && !EntityCompleter.isPrimitive(componentTypeClass)) {
                            entityName = (String)entityName + "[0].";
                        }
                    }
                    catch (Exception componentTypeClass) {
                        // empty catch block
                    }
                    result.add(0, (String)entityName);
                } else {
                    result.add(0, (String)entityName + ".");
                }
            }
            if (entityParent.length() > 0) {
                String finalEntityParent = entityParent;
                result = result.stream().map(e -> finalEntityParent + "." + e).collect(Collectors.toList());
            }
            if ((completion = DSLCompletion.buildPrefixAndCompletion(prefix, result)) != null) {
                for (String entity : result) {
                    Suggestion suggestion = new TokenSuggestion(entity).setOffset(prefix);
                    completion.addSuggestion(suggestion);
                }
                completion.checkAndCompress();
                completion.moveSingleSuggestionToCompletion();
            }
        }
        catch (Exception exception) {
            completion.setException(exception);
        }
        return completion;
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz.equals(String.class) || clazz.equals(Class.class) || TypeFactory.unwrapBoxer(clazz).isPrimitive() || clazz == java.util.Date.class || clazz == Timer.class || clazz == Date.class || clazz == Time.class || clazz == Timestamp.class;
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        return ClassUtils.getAllFields(clazz).stream().filter(field -> !field.isSynthetic() && !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
    }
}

