/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.type;

import com.streamscape.lib.loader.MemoryJarFile;
import com.streamscape.lib.reflection.creator.ObjectCreatorFactory;
import com.streamscape.omf.json.jackson.JsonCustomization;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.edl.SdoUtils;
import com.streamscape.runtime.mf.operation.type.EntityCompleter;
import com.streamscape.runtime.mf.operation.type.SemanticTypeEntitiesDescriber;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeOperation;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.network.http.server.servlet.FormatAndMimeTypes;
import com.streamscape.sef.network.http.server.utils.HTTPUtils;
import com.streamscape.sef.utils.SemanticTypeInfo;
import com.streamscape.sef.utils.SemanticUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.lang.completion.ScriptCompleter;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Action;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Predicate;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeTypeOperation
extends AbstractSemanticTypeOperation {
    public static final String NAME = "describe type";

    public DescribeTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction(new Action("DESCRIBE")).setPredicate(new Predicate("TYPE").addPossibleValues("SDO"));
        ChoiceModifier actionModifier = (ChoiceModifier)new ChoiceModifier("Action").setSyntaxHint(SyntaxHint.SPACE);
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)actionModifier.addParameter(new IdentifierParameter("TypeName"))).addModifier((AbstractModifier)new Modifier("FOR CLASS").addParameter(new IdentifierParameter("ClassName"))));
        CompoundModifier infoModifier = new CompoundModifier("InfoUsage");
        infoModifier.addModifier(new Modifier("INFO", false)).addModifier(new Modifier("ARCHIVES", false)).addModifier(new CompoundModifier("UsageAtDomain", false).addModifier(new Modifier("USAGE")).addModifier(new Modifier("AT DOMAIN", false)));
        Modifier entityModifier = (Modifier)new Modifier("ENTITY").addParameter((SyntaxParameter)((ExpressionParameter)new ExpressionParameter("entity").setCompleter(new SemanticTypeEntityCompleter())).setExcludedDelimiters(" \t\n\r[]()|{}=."));
        CompoundModifier asModifier = new CompoundModifier("AsFormat");
        asModifier.addModifier(new Modifier("AS")).addModifier((AbstractModifier)new ChoiceModifier("Format").addPossibleValues("XML", "SRC", "EDL").addModifier((AbstractModifier)new Modifier("JSON").addParameter((SyntaxParameter)new ExpressionParameter("customization", '(', ')').setRequired(false))));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().addModifier(infoModifier)).addModifier(new Modifier("ENTITIES"))).addModifier(entityModifier)).addModifier(asModifier)).addModifier(new Modifier("doc"))).setRequired(false));
        this.syntax.setDescription("Shows information about the semantic type.");
        this.syntax.setSyntaxDescription("describe type <TypeName>            - Shows information about a type with the specified name.\ndescribe type for class <ClassName> - Shows information about a type associated with the specified class.\n\nOptional parameters:\n\n   info            - Shows basic information about the type.\n   archives        - Shows a list of archives which contain the corresponding class.\n   usage           - Shows a list of dependent entities (event prototypes, semantic types, services, artifacts etc) in the current node.\n                     Dependent entities use an object of the semantic type (as payload, subtype, etc).\n   usage at domain - Shows usage of the type in all nodes of the sysplex.\n   entities        - Shows list of semantic type entities.\n   entity <entity> - Shows list of entities inside of specified entity.\n   as xml          - Shows the corresponding semantic object serialized in XML format (filled with default values).\n   as json         - Shows JSON output based on customized, user-defined notation, allowing users to suppress container elements,\n                     polymorphic objects or implicit collections. See toJSON(..) function for use with data object instances.\n                     JSON output can be customized in format (param1=value11,value12,...;param2=value21,value22,...).\n                     The following parameters and values are available:\n                        notation    { " + Arrays.stream(JsonNotation.values()).map(v -> v.toString().toLowerCase()).collect(Collectors.joining(" | ")) + " }\n                        level       { none | root_element | root_enum | complex_objects | polymorphic_objects | polymorphic_maps_and_collections |\n                                      polymorphic_primitive_objects | primitive_objects | enums | old_fabric_style_date_and_sqltimestamp },...\n                        skipnulls   { true | false }\n                        prettyprint { true | false }\n   as src          - Shows a source code of the corresponding class if it is available.\n   as edl          - Shows an EDL associated with the type if it is available.\n   doc             - Shows SDO documentation, if available.\n");
        this.syntax.setExamples("describe type Example1\ndescribe type Example1 info\ndescribe type Example1 usage\ndescribe type Example1 usage at domain\ndescribe type Example1 info usage\ndescribe type Example1 as xml\ndescribe type Example1 doc\ndescribe type for class example.Example1\ndescribe type for class example.Example1 info\ndescribe type Example1 as json (notation=type;level=none)\ndescribe type Example1 as json (notation=type;level=root_element,complex_objects;prettyprint=true)");
        this.syntax.addCompletionCommand("list types");
        this.syntax.setHiddenAlias("describe semantic type");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getSemanticTypeCache().listUserSemanticTypes());
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        JsonCustomization jsonCustomization = null;
        if (statement.existsParameter("customization")) {
            String customization = statement.getParameter("customization").getValue();
            try {
                jsonCustomization = JsonCustomization.builder().fromMap(FormatAndMimeTypes.splitParameters(customization)).build();
            }
            catch (Exception exception) {
                throw new ParsingException("Parsing JSON customization '" + customization + "' failed. Cause: " + String.valueOf(exception));
            }
        }
        return new Definition(this.resolveTypeName(statement.getParameter("TypeName").getValue()), statement.getParameter("ClassName").getValue(), statement.existsModifier("INFO"), statement.existsModifier("USAGE") ? (statement.existsModifier("AT DOMAIN") ? Usage.GLOBAL : Usage.LOCAL) : null, statement.existsModifier("ARCHIVES"), statement.existsModifier("XML"), statement.existsModifier("JSON"), statement.existsModifier("SRC"), statement.existsModifier("EDL"), statement.existsModifier("doc"), statement.existsModifier("ENTITIES"), statement.getParameter("entity").getValue(), jsonCustomization);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        return this.invoke(definition.usage == Usage.GLOBAL ? "*" : null, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        SemanticType type;
        Definition definition = (Definition)statement;
        SemanticType semanticType = type = definition.typeName != null ? ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(definition.typeName) : ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticClass(definition.className);
        if (type == null) {
            return new SLResponse("Semantic type not found.", false);
        }
        if (definition.info || definition.usage != null || definition.archives) {
            RowSet result = new RowSet(DescribeTypeOperation.createResultDescriptor(definition.usage == Usage.GLOBAL));
            if (session.isInstant()) {
                this.doUsage(type, session, true, result);
            } else {
                if (definition.info) {
                    result.addToRowSet(new Object[]{"Name", type.getTypeName()});
                    result.addToRowSet(new Object[]{"Class", type.getClassName()});
                    result.addToRowSet(new Object[]{"Description", type.getDescription()});
                    result.addToRowSet(new Object[]{"Ancestor", type.getAncestorType()});
                    result.addToRowSet(new Object[]{"Interface", type.isInterface()});
                    result.addToRowSet(new Object[]{"UID", type.getSerialVersionUID()});
                    result.addToRowSet(new Object[]{"Timestamp", type.getTimestamp() > 0L ? DescribeTypeOperation.formatDate(type.getTimestamp()) : "n/a"});
                    result.addToRowSet(new Object[]{"System", type.isSystem()});
                    SemanticTypeInfo typeInfo = SemanticUtils.getSemanticTypeInfo(type, (RuntimeContext)this.callable);
                    result.addToRowSet(new Object[]{"Global", typeInfo.isGlobal()});
                    if (typeInfo.getPackage() != null) {
                        result.addToRowSet(new Object[]{"Package", typeInfo.getPackage().getFullName()});
                        result.addToRowSet(new Object[]{"Archive", typeInfo.getLibJar()});
                    } else if (typeInfo.getExtJar() != null) {
                        result.addToRowSet(new Object[]{"Ext Archive", typeInfo.getExtJar()});
                    }
                    result.addToRowSet(new Object[]{"Valid", type.isValid()});
                    result.addToRowSet(new Object[]{"Dirty", type.isDirty()});
                }
                if (definition.archives) {
                    result.addToRowSet(new Object[]{"Archives", new HashSet<String>(((RuntimeContext)this.callable).getClassLoaderRegistry().listArchivesByClass(type.getClassName()))});
                }
                if (definition.usage != null) {
                    this.doUsage(type, session, definition.usage == Usage.GLOBAL, result);
                }
            }
            return new SLResponse(result);
        }
        if (definition.entities || definition.entity != null) {
            try {
                Class<?> clazz = ((RuntimeContext)this.callable).getSystemClassLoaderChain().loadClass(type.getClassName());
                return new SLResponse(new SemanticTypeEntitiesDescriber(definition.entities, definition.entity, (FabricContext)((Object)this.callable)).describe(clazz));
            }
            catch (ClassNotFoundException exception) {
                throw new Exception("Loading class '" + type.getClassName() + "' failed (for semantic type '" + type.getTypeName() + "').");
            }
        }
        if (definition.asJSON || definition.asXML) {
            String text;
            Object object = ObjectCreatorFactory.createObjectCreator().createDefaultObject(type.getTypeName());
            if (object == null) {
                throw new Exception("Creation of semantic type instance failed.");
            }
            try {
                text = this.getSerializer(definition).serialize(object);
            }
            catch (Error error) {
                throw new Exception("Serialization of semantic type failed. Cause: " + error.toString() + ".");
            }
            return text != null ? new SLResponse(text) : new SLResponse("Serialization of semantic type failed.", false);
        }
        String name = definition.asSRC ? "Source code" : (definition.asEDL ? "EDL statement" : "Documentation");
        String className = type.getClassName();
        SemanticTypeInfo typeInfo = SemanticUtils.getSemanticTypeInfo(type, (RuntimeContext)this.callable);
        if (typeInfo.getLibJar() == null) {
            return new SLResponse(name + " not found.");
        }
        Object filename = definition.asSRC ? MemoryJarFile.convertClassNameToPathInJar(className) + ".java" : SdoUtils.getEDLPathInJar(className);
        byte[] bytes = SemanticUtils.getLibJarFile(typeInfo.getLibJar(), (RuntimeContext)this.callable).getEntryBytes((String)filename);
        if (bytes == null) {
            return new SLResponse(name + " not found.");
        }
        String result = new String(bytes);
        if (definition.isDoc()) {
            result = BufferUtils.extractUnwrappedJavaDoc(result);
        }
        return new SLResponse(result);
    }

    private void doUsage(SemanticType type, MFSession session, boolean global, RowSet result) throws Exception {
        if (!session.isInstant()) {
            result.addToRowSet(new Object[]{"Dependent Types", SemanticUtils.listDependentTypes(type, (FabricContext)((Object)this.callable))});
            result.addToRowSet(new Object[]{"Dependent Events", SemanticUtils.listDependentEventIds(type, (FabricContext)((Object)this.callable))});
        }
        result.addToRowSet(new Object[]{"Dependent Services", this.processNames(SemanticUtils.listDependentServices(type, (RuntimeContext)this.callable), global)});
        result.addToRowSet(new Object[]{"Dependent Artifacts", this.processNames(SemanticUtils.listDependentMappers(type, (RuntimeContext)this.callable), global)});
        HashMap<Integer, List<String>> references = ((RuntimeContext)this.callable).getDataspaceManager().getSemanticTypeReferences(type);
        result.addToRowSet(new Object[]{"Dependent Collections", this.processNames(references.get(3), global)});
        result.addToRowSet(new Object[]{"Dependent Functions", this.processNames(references.get(17), global)});
        result.addToRowSet(new Object[]{"Dependent Actors", this.processNames(references.get(32), global)});
        result.addToRowSet(new Object[]{"Dependent Triggers", this.processNames(references.get(9), global)});
    }

    private List<String> processNames(List<String> names, boolean global) {
        return this.processNames(names, global ? ((RuntimeContext)this.callable).getName() : null);
    }

    @Override
    protected void addBroadcastRowSet(SLResponse response, RowSet result) throws Exception {
        int iShift = 0;
        for (int i = 1; i <= result.getRowCount() && !result.getRowAt(i).getColumn(1).equals("Dependent Services"); ++i) {
            ++iShift;
        }
        RowSet rowSet = response.getRowSet();
        for (int i = 1; i <= rowSet.getRowCount(); ++i) {
            ((List)result.getRowAt(i + iShift).getColumn(2)).addAll((List)rowSet.getRowAt(i).getColumn(2));
        }
    }

    private synchronized TextSerializer getSerializer(Definition definition) {
        if (definition.asXML) {
            return ((RuntimeContext)this.callable).getXSerializer();
        }
        if (definition.jsonCustomization == null) {
            definition.jsonCustomization = JsonCustomization.builder().build();
        }
        if (definition.jsonCustomization.getPrettyPrint() == null) {
            definition.jsonCustomization = JsonCustomization.builder().from(definition.jsonCustomization).setPrettyPrint(true).build();
        }
        return HTTPUtils.getJsonSerializerForRest((FabricContext)((Object)this.callable), definition.jsonCustomization);
    }

    private static RowMetaData createResultDescriptor(boolean global) {
        RowMetaData result = new RowMetaData();
        DescribeTypeOperation.addColumn(result, "Property");
        if (global) {
            DescribeTypeOperation.addGenericColumn(result, "Value");
        } else {
            DescribeTypeOperation.addColumn(result, "Value");
        }
        return result;
    }

    public static class SemanticTypeEntityCompleter
    implements ScriptCompleter<RuntimeContext> {
        @Override
        public DSLCompletion complete(String script, String processedScript, RuntimeContext callable, MFSession session) {
            try {
                DSLStatement statement = new DescribeTypeOperation().parseDsl(processedScript + " fake");
                EntityCompleter completer = new EntityCompleter(callable);
                completer.setTypeName(statement.getParameter("TypeName").getValue());
                return completer.complete(script);
            }
            catch (ParsingException exception) {
                return new DSLCompletion(exception);
            }
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private String typeName;
        private String className;
        private boolean info = false;
        private Usage usage = null;
        private boolean archives = false;
        private boolean asXML = false;
        private boolean asJSON = false;
        private boolean asSRC = false;
        private boolean asEDL = false;
        private boolean suppressTopName = false;
        private boolean doc = false;
        private boolean entities;
        private String entity;
        private JsonCustomization jsonCustomization;

        public Definition(String typeName, String className) {
            super(DescribeTypeOperation.NAME);
            if (typeName != null) {
                className = null;
            }
            this.typeName = typeName;
            this.className = className;
        }

        public Definition(String typeName, String className, boolean info, Usage usage, boolean archives, boolean asXML, boolean asJSON, boolean asSRC, boolean asEDL, boolean doc, boolean entities, String entity, JsonCustomization jsonCustomization) {
            this(typeName, className);
            this.info = info;
            this.usage = usage;
            this.archives = archives;
            this.asXML = asXML;
            this.asJSON = asJSON;
            this.asSRC = asSRC;
            this.asEDL = asEDL;
            this.doc = doc;
            this.entities = entities;
            this.entity = entity;
            this.jsonCustomization = jsonCustomization;
            if (!(info || usage != null || archives || asXML || asJSON || asSRC || asEDL || doc || entities || entity != null)) {
                this.info = true;
            }
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isInfo() {
            return this.info;
        }

        public Usage getUsage() {
            return this.usage;
        }

        public boolean isArchives() {
            return this.archives;
        }

        public boolean asXML() {
            return this.asXML;
        }

        public boolean asJSON() {
            return this.asJSON;
        }

        public boolean asSRC() {
            return this.asSRC;
        }

        public boolean asEDL() {
            return this.asEDL;
        }

        public boolean isDoc() {
            return this.doc;
        }
    }

    public static enum Usage {
        LOCAL,
        GLOBAL;

    }
}

