/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.type;

import com.streamscape.lib.analyzer.SerializableFieldsAndParentTypesStrategy;
import com.streamscape.lib.analyzer.SerializableFieldsOnlyStrategy;
import com.streamscape.lib.analyzer.TypeAnalyzerFactory;
import com.streamscape.lib.analyzer.TypeGraph;
import com.streamscape.lib.analyzer.TypeGraphJsonPrintVisitor;
import com.streamscape.lib.analyzer.TypeGraphPrettyPrintVisitor;
import com.streamscape.lib.analyzer.TypeGraphPrintVisitor;
import com.streamscape.lib.analyzer.TypeGraphXmlPrintVisitor;
import com.streamscape.lib.utils.OrderedMap;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Action;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Predicate;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnalyzeTypeOperation
extends AbstractSemanticTypeOperation {
    public static final String NAME = "analyze type";

    public AnalyzeTypeOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction(new Action("ANALYZE")).setPredicate(new Predicate("TYPE").addPossibleValues("SDO"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier().addParameter((SyntaxParameter)new IdentifierParameter("TypeName").setExcludedDelimiters("[]"))).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier(false).addPossibleValue("DEPENDENCIES").addModifier(new CompoundModifier().addModifier(new Modifier("FULL", false)).addModifier(new CompoundModifier(false).addModifier(new Modifier("AS")).addModifier(new ChoiceModifier().addPossibleValues("XML", "JSON")))));
        this.syntax.setDescription("Shows information about structure or dependencies of the specified semantic type.\nBy default, shows a structure of the type in a tree view.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   as xml       - Shows the type structure in XML format.\n   as json      - Shows the type structure in JSON format.\n   full         - Shows a structure of the type and its parent types.\n   dependencies - Shows all dependencies (types, event prototypes, etc) of the type.");
        this.syntax.setExamples("analyze type Example1\nanalyze type Example1 as xml\nanalyze type Example1 full\nanalyze type Example1 full as json\nanalyze type Example1 dependencies");
        this.syntax.addCompletionCommand("list types");
        this.syntax.setHiddenAlias("analyze semantic type");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((RuntimeContext)this.callable).getSemanticTypeCache().listUserSemanticTypes());
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.resolveTypeName(statement.getParameter("TypeName").getValue()), statement.existsModifier("DEPENDENCIES"), statement.existsModifier("FULL"), statement.existsModifier("XML"), statement.existsModifier("JSON"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        SemanticType type;
        Definition definition = (Definition)statement;
        boolean isArray = false;
        String typeName = definition.getTypeName();
        if (typeName.endsWith("[]")) {
            isArray = true;
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        if ((type = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticType(typeName)) == null) {
            return new SLResponse("Semantic type not found.", false);
        }
        if (definition.dependencies) {
            RowSet result = new RowSet(AnalyzeTypeOperation.createSimpleResultDescriptor());
            AnalyzeTypeOperation.add(result, new Object[]{"Depends On Types", ((RuntimeContext)this.callable).getSemanticTypeCache().listComponentSemanticTypes(type.getTypeName())});
            Map<String, Map<String, List<String>>> allDependencies = this.getSemanticTypeDependenciesInSysplex(type.getTypeName());
            OrderedMap<String, List<String>> resultDependencies = new OrderedMap<String, List<String>>();
            resultDependencies.put("Types", new ArrayList());
            resultDependencies.put("Events", new ArrayList());
            resultDependencies.put("Services", new ArrayList());
            resultDependencies.put("Artifacts", new ArrayList());
            resultDependencies.put("Collections", new ArrayList());
            resultDependencies.put("Functions", new ArrayList());
            resultDependencies.put("Actors", new ArrayList());
            resultDependencies.put("Triggers", new ArrayList());
            Map<String, List<String>> localNodeDependencies = allDependencies.remove(((RuntimeContext)this.callable).getName());
            if (localNodeDependencies != null) {
                this.addDependencies(!allDependencies.isEmpty() ? ((RuntimeContext)this.callable).getName() : null, localNodeDependencies, resultDependencies);
            }
            allDependencies.forEach((nodeName, nodeDependencies) -> this.addDependencies((String)nodeName, (Map<String, List<String>>)nodeDependencies, (Map<String, List<String>>)resultDependencies));
            resultDependencies.entrySet().forEach(entry -> AnalyzeTypeOperation.add(result, new Object[]{"Dependent " + (String)entry.getKey(), entry.getValue()}));
            return new SLResponse(result);
        }
        TypeGraph typeGraph = TypeAnalyzerFactory.getInstance().createTypeAnalyzer(definition.full ? new SerializableFieldsAndParentTypesStrategy() : new SerializableFieldsOnlyStrategy()).getTypeGraph("//{" + type.getClassName() + (isArray ? "[]" : "") + "}");
        TypeGraphPrintVisitor printVisitor = definition.asXML() ? new TypeGraphXmlPrintVisitor() : (definition.asJSON() ? new TypeGraphJsonPrintVisitor() : new TypeGraphPrettyPrintVisitor());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        printVisitor.setOutput(os);
        typeGraph.traverse(printVisitor);
        return new SLResponse(os.toString("UTF-8"));
    }

    private void addDependencies(String nodeName, Map<String, List<String>> nodeDependencies, Map<String, List<String>> result) {
        for (Map.Entry<String, List<String>> entry : result.entrySet()) {
            List<String> dependencies = nodeDependencies.get(entry.getKey());
            if (dependencies == null) continue;
            entry.getValue().addAll(this.processNames(dependencies, entry.getKey(), nodeName));
        }
    }

    private List<String> processNames(List<String> names, String entityName, String nodeName) {
        return !entityName.equals("Types") && !entityName.equals("Events") ? this.processNames(names, nodeName) : names;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String typeName;
        private boolean dependencies = false;
        private boolean full = false;
        private boolean asXML = false;
        private boolean asJSON = false;

        public Definition(String typeName, boolean dependencies, boolean full, boolean asXML, boolean asJSON) {
            super(AnalyzeTypeOperation.NAME);
            this.typeName = typeName;
            this.dependencies = dependencies;
            this.full = full;
            this.asXML = asXML;
            this.asJSON = asJSON;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public boolean isDependencies() {
            return this.dependencies;
        }

        public boolean isFull() {
            return this.full;
        }

        public boolean asXML() {
            return this.asXML;
        }

        public boolean asJSON() {
            return this.asJSON;
        }
    }
}

