/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace.log;

import com.streamscape.runtime.mf.operation.trace.log.AbstractLogOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import org.apache.commons.io.input.ReversedLinesFileReader;

public class ShowLogOperation<T extends SLCallable>
extends AbstractLogOperation<T> {
    private static final String NAME = "show log";
    private static final int DEFAULT_LINES_NUMBER = 1000;

    public ShowLogOperation(boolean isMnode) {
        super(isMnode);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW LOG");
        this.addNodeModifier();
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(new Modifier("FULL"))).addModifier(new CompoundModifier("LinesModifier").addModifier(new ChoiceModifier().addPossibleValues("FIRST", "LAST")).addModifier((AbstractModifier)new Modifier().addParameter(new IntegerParameter("Lines").setRange(1, Integer.MAX_VALUE))))).setCompactSyntax("[{full | {{first | last} <Lines>}}]")).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription(this.getNodeDescription());
        this.syntax.setSyntaxDescription("Parameters:\n\n   full          - Shows the full log file (this can be long and expensive operation in the case of a large file).\n   first <Lines> - Shows the first <Lines> lines of the log file.\n   last <Lines>  - Shows the last <Lines> lines of the log file.");
        this.syntax.setExamples("show log\nshow log full\nshow log first 100\nshow log last 100" + this.getNodeExample());
        this.syntax.addTag(OperationTag.trace);
        this.syntax.addTag(OperationTag.log);
    }

    protected String getNodeDescription() {
        return this.doGetNodeDescription() + "\nBy default the command shows 1000 last lines of the log.";
    }

    protected String doGetNodeDescription() {
        return "Shows the log file from the current node.";
    }

    protected String getNodeExample() {
        return "";
    }

    protected void checkSyntax(DSLStatement statement) throws ParsingException {
        String originalStatement = statement.getOriginalStatement().trim();
        if (originalStatement.equalsIgnoreCase("show log first") || originalStatement.equalsIgnoreCase("show log last")) {
            throw new ParsingException(this.getSyntaxErrorMessage("Lines should be specified."));
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        this.checkSyntax(statement);
        return new Definition(statement.existsModifier("FULL"), this.getDirection(statement), this.getLines(statement));
    }

    protected Direction getDirection(DSLStatement statement) {
        return statement.existsModifier("FIRST") ? Direction.FIRST : (statement.existsModifier("LAST") ? Direction.LAST : null);
    }

    protected int getLines(DSLStatement statement) {
        return statement.existsParameter("Lines") ? Integer.parseInt(statement.getParameter("Lines").getValue()) : -1;
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        File logFile = this.getLogFile(definition);
        if (logFile == null || !logFile.exists()) {
            return new SLResponse("Log file not found.", false);
        }
        return new SLResponse(this.getLines(logFile, definition.full, definition.direction, definition.lines));
    }

    protected File getLogFile(Definition definition) throws Exception {
        return TraceConfigurator.getInstance().getLogFile();
    }

    private RowSet getLines(File logFile, boolean full, Direction direction, int nLines) throws Exception {
        RowSet result = new RowSet(ShowLogOperation.createResultDescriptor());
        if (!full && direction == null && nLines == -1) {
            direction = Direction.LAST;
            nLines = 1000;
        }
        if (full || direction == null || nLines == -1) {
            try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
                while (reader.ready()) {
                    result.addToRowSet(new Object[]{reader.readLine()});
                }
            }
        }
        if (direction == Direction.FIRST) {
            try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
                for (int i = 0; i < nLines && reader.ready(); ++i) {
                    result.addToRowSet(new Object[]{reader.readLine()});
                }
            }
        }
        try (ReversedLinesFileReader reader = new ReversedLinesFileReader(logFile);){
            String line;
            int i;
            ArrayList<String> lines = new ArrayList<String>(nLines);
            for (i = 0; i < nLines && (line = reader.readLine()) != null; ++i) {
                lines.add(line);
            }
            for (i = lines.size() - 1; i >= 0; --i) {
                result.addToRowSet(new Object[]{lines.get(i)});
            }
        }
        return result;
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ShowLogOperation.addColumn(result, "Trace Log");
        return result;
    }

    protected static class Definition
    extends AbstractSLStatement {
        private boolean full;
        private Direction direction;
        private int lines;

        public Definition(boolean full, Direction direction, int lines) {
            super(ShowLogOperation.NAME);
            this.full = full;
            this.direction = direction;
            this.lines = lines;
        }

        public boolean isFull() {
            return this.full;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getLines() {
            return this.lines;
        }
    }

    public static enum Direction {
        FIRST,
        LAST;

    }
}

