/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace.log;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.trace.log.AbstractLogOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class RotateLogOperation<T extends RuntimeContext>
extends AbstractLogOperation<T> {
    private static final String NAME = "rotate log";

    public RotateLogOperation(boolean isMnode) {
        super(isMnode);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ROTATE LOG");
        this.addNodeModifier();
        this.syntax.setDescription("Forcibly closes the current Trace Log file and opens a new one for further logging.\nSaving the closed log file (and its naming) depends on the parameters of the node Logger.\nThe old file will be saved if 'logFileArchive' parameter is true and 'maximumLogFiles' is not 0.\nThese parameters can be changed by 'set node properties' command.");
    }

    @Override
    public boolean isVisible(MFSession session) {
        return ((RuntimeContext)this.callable).getContainer() != null && super.isVisible(session);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.checkLog((Definition)statement);
        ((ContainerLogger)TraceConfigurator.getInstance().getLogger()).rotate();
        return new SLResponse();
    }

    static class Definition
    extends AbstractLogOperation.AbstractDefinition {
        Definition(DSLStatement statement) {
            super(RotateLogOperation.NAME, statement);
        }
    }
}

