/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace.log;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.trace.log.AbstractLogOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.io.File;

public class ListLogsOperation<T extends RuntimeContext>
extends AbstractLogOperation<T> {
    public static final String NAME = "list logs";

    public ListLogsOperation(boolean isMnode) {
        super(isMnode);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST LOGS");
        this.syntax.addModifier((AbstractModifier)new Modifier("ABSOLUTE", false).setSyntaxHintSpace());
        this.addNodeModifier();
        this.syntax.setDescription("Shows a list of all Trace Log files of the current node.\nThis list includes the active log file and archived log files.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   absolute - Specifies to use absolute paths to show result." + this.getNodeParameterDescription(" "));
        this.syntax.setExamples("list logs\nlist logs absolute" + this.getNodeExamples());
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.checkLog(definition);
        AbstractOperation.checkFullPathAllowed((AbstractRuntimeContext)this.callable, definition.absolute);
        RowSet result = new RowSet(ListLogsOperation.createResultDescriptor());
        this.addLogFiles(definition, result);
        return new SLResponse(result);
    }

    private void addLogFiles(Definition definition, RowSet result) throws Exception {
        for (File file : this.listLogFiles(definition)) {
            ListLogsOperation.addLogFile(file, definition.absolute, result);
        }
    }

    private static void addLogFile(File file, boolean absolute, RowSet result) {
        try {
            ListLogsOperation.addValues(result, absolute ? file.getCanonicalPath() : file.getName(), ListLogsOperation.formatCreationDate(file), ListLogsOperation.formatDate(file.lastModified()), AbstractOperation.Scale.MB.format(file.length()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListLogsOperation.addColumn(result, "Log");
        ListLogsOperation.addColumn(result, "Created On");
        ListLogsOperation.addColumn(result, "Last Modified On");
        ListLogsOperation.addColumn(result, "Size");
        return result;
    }

    protected static class Definition
    extends AbstractLogOperation.AbstractDefinition {
        boolean absolute;

        protected Definition(DSLStatement statement) {
            super(ListLogsOperation.NAME, statement);
            this.absolute = statement.existsModifier("ABSOLUTE");
        }
    }
}

