/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace.log;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.zip.ZipArchiveOutputStream;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.trace.log.AbstractLogOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileOutputStream;
import com.streamscape.slex.file.SLFileOutputStreamFactory;
import com.streamscape.slex.file.SLFileUtils;
import com.streamscape.slex.file.SLFileUtilsFactory;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;

public class ExportLogOperation<T extends RuntimeContext>
extends AbstractLogOperation<T> {
    private static final String NAME = "export log";
    private static final long MB = 0x100000L;
    private static final long MIN_ARCHIVE_SIZE = 0xA00000L;

    public ExportLogOperation(boolean isMnode) {
        super(isMnode);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("EXPORT LOG");
        this.syntax.addActionParameter((SyntaxParameter)new LocalPathParameter("LogFilename").setRequired(false));
        this.addNodeModifier();
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("AS").addParameter(new SLFilePathParameter("Destination"))).setSyntaxHintSpace());
        ChoiceModifier choiceModifier = new ChoiceModifier("ArchiveChoice", false);
        choiceModifier.addModifier(new CompoundModifier().addModifier((AbstractModifier)new Modifier("COMPRESS").setHiddenAlias("ARCHIVE")).addModifier((AbstractModifier)new Modifier("IF SIZE > ", false).addParameter((SyntaxParameter)new NumericParameter("size in Mb").setName("minArchiveSize"))));
        choiceModifier.addModifier((AbstractModifier)((Modifier)new Modifier("NO COMPRESS").setHiddenAlias("NO ARCHIVE")).setName("NOARCHIVE"));
        this.syntax.addModifier(choiceModifier);
        this.syntax.setDescription("Exports the log file from the node to the specified destination.\nBy default if the log file size greater then 10 Mb, it is compressed to zip.\nCompressed log always has name <Destination>.zip.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   &lt;LogFilename&gt;    - Name of the log file. It can be an absolute path or just a filename.\n   compress         - Specifies to compress the log file regardless of its size.\n   compress if size - Specifies to compress the log file if its size greater then the specified size in Mb.\n   no compress      - Specifies not to compress the log file regardless of its size." + this.getNodeParameterDescription("         "));
        this.syntax.setExamples("export log as 'C:/debug/mnode.log'\nexport log as 'C:/debug/mnode.log' compress\nexport log as 'C:/debug/mnode.log' compress if size > 5\nexport log 'C:/StreamScape/Nodes/Node1/Node1.03.08.2017-04.29.51.log' as 'C:/debug/mnode.log'" + this.getNodeExamples());
        this.syntax.addCompletionCommand("list logs");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(this.listLogFiles(null).stream().map(file -> "'" + file.getName() + "'").collect(Collectors.toList()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        block10: {
            Definition definition = (Definition)statement;
            this.checkLog(definition);
            File logFile = this.getActualLogFile(definition);
            try (FileInputStream logFileInputStream = null;){
                logFileInputStream = new FileInputStream(logFile);
                if (definition.archive && logFile.length() >= definition.minArchiveSize) {
                    OutputStream slFileOutputStream = null;
                    ZipOutputStream zipOutputStream = null;
                    try {
                        slFileOutputStream = (OutputStream)new SLFileOutputStreamFactory().create(session, definition.destination + ".zip");
                        ((SLFileOutputStream)slFileOutputStream).create();
                        slFileOutputStream = new BufferedOutputStream(slFileOutputStream, session.getSLSessionData().getTransferBufferSize());
                        zipOutputStream = new ZipArchiveOutputStream(slFileOutputStream);
                        ((ZipArchiveOutputStream)zipOutputStream).putArchiveEntry(((ZipArchiveOutputStream)zipOutputStream).createArchiveEntry(logFile, logFile.getName()));
                        FileIOUtils.copy((InputStream)logFileInputStream, (OutputStream)zipOutputStream);
                        ((ZipArchiveOutputStream)zipOutputStream).closeArchiveEntry();
                        break block10;
                    }
                    finally {
                        if (zipOutputStream != null) {
                            zipOutputStream.close();
                        }
                        if (slFileOutputStream != null) {
                            slFileOutputStream.close();
                        }
                    }
                }
                ((SLFileUtils)new SLFileUtilsFactory().create(session, definition.destination)).createFile(logFileInputStream, logFile.length(), false);
            }
        }
        return new SLResponse();
    }

    protected static class Definition
    extends AbstractLogOperation.AbstractDefinition {
        String destination;
        boolean archive = true;
        long minArchiveSize = 0xA00000L;

        protected Definition(DSLStatement statement) {
            super(ExportLogOperation.NAME, statement);
            this.destination = statement.getParameter("Destination").getValue();
            if (statement.existsModifier("COMPRESS")) {
                this.archive = true;
                this.minArchiveSize = -1L;
                if (statement.existsParameter("minArchiveSize")) {
                    this.minArchiveSize = Long.parseLong(statement.getParameter("minArchiveSize").getValue()) * 0x100000L;
                }
            } else if (statement.existsModifier("NOARCHIVE")) {
                this.archive = false;
            }
        }
    }
}

