/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace.log;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.trace.log.AbstractLogOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class DropLogOperation<T extends RuntimeContext>
extends AbstractLogOperation<T> {
    private static final String NAME = "drop log";

    public DropLogOperation(boolean isMnode) {
        super(isMnode);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP LOG");
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().setSyntaxHintSpace()).addParameter(new LocalPathParameter("LogFilename"))).addModifier(new Modifier("ALL")));
        this.addNodeModifier();
        this.syntax.setDescription("Drops the specified inactive Trace log file.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all" + (isMnode ? "    " : "") + " - Drops all inactive log files." + this.getNodeParameterDescription(""));
        this.syntax.setExamples("drop log 'Node1.03.08.2017-04.29.51.log'\ndrop log 'C:/StreamScape/Nodes/Node1/Node1.03.08.2017-04.29.51.log'\ndrop log all" + this.getNodeExamples());
        this.syntax.addCompletionCommand("list logs");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(this.listLogFiles(null).stream().map(file -> "'" + file.getName() + "'").collect(Collectors.toList()));
            completions.add("all");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        this.checkLog(definition);
        if (definition.all) {
            File activeLogFile = this.getLogFile(definition);
            for (File logFile : this.listLogFiles(definition)) {
                if (logFile.equals(activeLogFile)) continue;
                logFile.delete();
            }
        } else {
            File logFile = this.getActualLogFile(definition);
            if (!logFile.delete()) {
                throw new Exception("Deleting log file failed.");
            }
        }
        return new SLResponse();
    }

    protected static class Definition
    extends AbstractLogOperation.AbstractDefinition {
        boolean all;

        protected Definition(DSLStatement statement) {
            super(DropLogOperation.NAME, statement);
            this.all = statement.existsModifier("ALL");
        }
    }
}

