/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace.log;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractLogOperation<T extends SLCallable>
extends AbstractDSLOperation<T> {
    protected boolean isMnode = false;

    protected AbstractLogOperation() {
        this(false);
    }

    protected AbstractLogOperation(boolean isMnode) {
        super(false, true);
        this.isMnode = isMnode;
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.trace);
        this.syntax.addTag(OperationTag.log);
    }

    protected void checkLog(AbstractDefinition definition) throws Exception {
        if (definition.nodeName == null && !TraceConfigurator.getInstance().isLogEnabled()) {
            throw new Exception("Log is disabled.");
        }
    }

    protected File getLogFile(AbstractDefinition definition) throws Exception {
        return this.isMnode && definition != null && definition.nodeName != null ? this.getLogFile(definition.nodeName) : TraceConfigurator.getInstance().getLogFile();
    }

    protected File getLogFile(String nodeName) throws Exception {
        return null;
    }

    protected File getActualLogFile(AbstractDefinition definition) throws Exception {
        File logFile = this.doGetLogFile(definition);
        if (logFile == null || !logFile.exists()) {
            throw new Exception("Log file not found.");
        }
        if (!this.listLogFiles(definition).contains(logFile)) {
            throw new Exception("Specified file is not an actual log file.");
        }
        return logFile;
    }

    private File doGetLogFile(AbstractDefinition definition) throws Exception {
        if (definition.logFilename != null) {
            File logFile = new File(definition.logFilename);
            return logFile.isAbsolute() ? logFile : this.getSpecificLogFile(definition);
        }
        return this.getLogFile(definition);
    }

    private File getSpecificLogFile(AbstractDefinition definition) throws Exception {
        File logFile = this.getLogFile(definition);
        return logFile != null ? new File(logFile.getParentFile(), definition.logFilename) : null;
    }

    protected File getWorkingDir(AbstractDefinition definition) throws Exception {
        return definition != null && definition.nodeName != null ? this.getWorkingDir(definition.nodeName) : new File(this.callable.getStartupDir());
    }

    protected File getWorkingDir(String nodeName) throws Exception {
        return null;
    }

    protected List<File> listLogFiles(AbstractDefinition definition) throws Exception {
        File logDir;
        ArrayList<File> result = new ArrayList<File>();
        File logFile = this.getLogFile(definition);
        if (logFile != null && (logDir = logFile.getParentFile()) != null && logDir.isDirectory()) {
            result.add(logFile);
            for (File file : logDir.listFiles()) {
                if (!file.isFile() || !ContainerLogger.isArchive(logFile.getName(), file.getName())) continue;
                result.add(file);
            }
        }
        return result;
    }

    protected void addNodeModifier() {
        if (this.isMnode) {
            this.syntax.addModifier((AbstractModifier)new AtNodeOrAtDomainModifier(false, (CompletionAdviser)this.getNodeCompletionAdviser()).setSyntaxHintSpace());
        }
    }

    protected AtNodeOrAtDomainModifier.NodeCompletionAdviser getNodeCompletionAdviser() {
        return null;
    }

    protected String getNodeParameterDescription(String indent) {
        return this.isMnode ? "\n   at node" + indent + " - Executes the command in the specified managed node." : "";
    }

    protected String getNodeExamples() {
        return "";
    }

    public static class AbstractDefinition
    extends AbstractSLStatement {
        String nodeName;
        String logFilename;

        protected AbstractDefinition(String name, DSLStatement statement) {
            super(name);
            this.nodeName = AtNodeOrAtDomainModifier.getValue(statement);
            if (statement.existsParameter("LogFilename")) {
                this.logFilename = statement.getParameter("LogFilename").getValue();
            }
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

