/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.trace.AbstractTraceOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.parameter.EnumParameter;

public class EnableTraceOperation
extends AbstractTraceOperation<RuntimeContext> {
    public static final String NAME = "enable trace";

    public EnableTraceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ENABLE TRACE");
        ChoiceModifier choice = (ChoiceModifier)((ChoiceModifier)new ChoiceModifier().addModifier(this.createBroadcastModifier())).addModifier(new CompoundModifier().addParameter(this.createClassesParameter("LevelClasses", false)).addParameter(new EnumParameter("TraceLevel").addPossibleValues("ERROR", "INFO", "DEBUG")));
        this.syntax.addModifier((AbstractModifier)choice.setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Enables either trace broadcast or the specified Trace level (ERROR or INFO or DEBUG) for the specified classes or packages.\nNames of classes or packages must be fully qualified (e.g. com.streamscape.sef.container.Container).\nPackages can be also specified in special format: <PackageName>.* (e.g. com.streamscape.sef.container.*).\nIf no classes or packages are specified, the specified level will be enabled for all classes.\nBROADCAST and Log Level directives cannot be specified simultaneously.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   at node <NodeName> - Executes the command in the specified node.\n   at domain          - Executes the command in all nodes of the sysplex.");
        this.syntax.setExamples("enable trace error\nenable trace (com.streamscape.*) info\nenable trace (com.streamscape.*) info at domain\nenable trace broadcast\nenable trace broadcast (com.streamscape.*)\nenable trace broadcast at node TestNode1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Object parameters = statement.getParameter("BroadcastClasses").getValue();
        if (parameters != null) {
            parameters = "(" + (String)parameters + ")";
        } else {
            parameters = statement.getParameter("LevelClasses").getValue();
            if (parameters != null) {
                parameters = "(" + (String)parameters + ")";
            }
        }
        if (statement.existsParameter("TraceLevel")) {
            if (parameters == null) {
                parameters = "";
            }
            parameters = (String)parameters + " " + statement.getParameter("TraceLevel").getValue();
        }
        return new Definition(statement, (String)parameters, statement.existsModifier("BROADCAST"));
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.isBroadcast()) {
            if (definition.getParameters() != null) {
                TraceConfigurator.getInstance().setBroadcast(definition.getParameters(), true);
            } else {
                TraceConfigurator.getInstance().setBroadcastAll(true);
            }
        } else {
            TraceConfigurator.getInstance().enable(definition.getParameters());
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractTraceOperation.AbstractDefinition {
        private String parameters;
        private boolean broadcast = false;

        public Definition(DSLStatement statement, String parameters, boolean broadcast) {
            super(EnableTraceOperation.NAME, statement);
            this.parameters = parameters;
            this.broadcast = broadcast;
        }

        public String getParameters() {
            return this.parameters;
        }

        public boolean isBroadcast() {
            return this.broadcast;
        }
    }
}

