/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.trace.AbstractTraceOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class DisableTraceOperation
extends AbstractTraceOperation<RuntimeContext> {
    public static final String NAME = "disable trace";

    public DisableTraceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DISABLE TRACE");
        ChoiceModifier choice = (ChoiceModifier)((ChoiceModifier)new ChoiceModifier(false).addModifier(this.createBroadcastModifier())).addParameter(this.createClassesParameter("LevelClasses", true));
        this.syntax.addModifier((AbstractModifier)choice.setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Disables either traces broadcasting or traces for the specified classes or packages.\nNames of classes or packages must be fully qualified (e.g. com.streamscape.sef.container.Container).\nPackages can be also specified in special format: <PackageName>.* (e.g. com.streamscape.sef.container.*).\nIf no parameters are specified, traces will be disabled for all classes.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   at node <NodeName> - Executes the command in the specified node.\n   at domain          - Executes the command in all nodes of the sysplex.");
        this.syntax.setExamples("disable trace\ndisable trace (com.streamscape.*)\ndisable trace at domain\ndisable trace broadcast\ndisable trace broadcast (com.streamscape.*)\ndisable trace broadcast (com.streamscape.*) at node TestNode1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Object parameters = statement.getParameter("BroadcastClasses").getValue();
        if (parameters != null) {
            parameters = "(" + (String)parameters + ")";
        } else {
            parameters = statement.getParameter("LevelClasses").getValue();
            if (parameters != null) {
                parameters = "(" + (String)parameters + ")";
            }
        }
        return new Definition(statement, (String)parameters, statement.existsModifier("BROADCAST"));
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.isBroadcast()) {
            if (definition.getParameters() != null) {
                TraceConfigurator.getInstance().setBroadcast(definition.getParameters(), false);
            } else {
                TraceConfigurator.getInstance().setBroadcastAll(false);
            }
        } else {
            TraceConfigurator.getInstance().disable(definition.getParameters() == null ? "" : definition.getParameters());
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractTraceOperation.AbstractDefinition {
        private String parameters;
        private boolean broadcast = false;

        public Definition(DSLStatement statement, String parameters, boolean broadcast) {
            super(DisableTraceOperation.NAME, statement);
            this.parameters = parameters;
            this.broadcast = broadcast;
        }

        boolean isBroadcast() {
            return this.broadcast;
        }

        public String getParameters() {
            return this.parameters;
        }
    }

    public static class TraceClassesModifier
    extends Modifier {
        TraceClassesModifier() {
            super(false);
            this.addParameter((SyntaxParameter)new ExpressionParameter("<ClassOrPackageName1>,...,<ClassOrPackageNameN>", '(', ')').setName("Classes"));
            this.setSyntaxHint(SyntaxHint.SPACE);
        }
    }

    public static class TraceBroadcastModifier
    extends Modifier {
        TraceBroadcastModifier() {
            super("BROADCAST", false);
            this.setRequired(false);
            this.setSyntaxHint(SyntaxHint.SPACE);
        }
    }
}

