/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.trace.AbstractTraceOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.trace.TraceConfigurator;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.Arrays;
import java.util.List;

public class DescribeTraceOperation
extends AbstractTraceOperation<RuntimeContext> {
    public static final String NAME = "describe trace";

    public DescribeTraceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE TRACE");
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Shows information about global parameters of the traces.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   at node <NodeName> - Executes the command in the specified node.\n   at domain          - Executes the command in all nodes of the sysplex.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        List<String> values = this.getValues();
        boolean atDomain = ((Definition)statement).nodeName != null && ((Definition)statement).nodeName.equals("*");
        RowSet result = new RowSet(DescribeTraceOperation.createResultDescriptor(atDomain));
        if (atDomain) {
            result.addToRowSet(new Object[]{node.getName(), values.get(0), values.get(1), values.get(2)});
        } else {
            result.addToRowSet(new Object[]{values.get(0), values.get(1), values.get(2)});
        }
        return new SLResponse(result);
    }

    private List<String> getValues() throws Exception {
        TraceConfigurator configurator = TraceConfigurator.getInstance();
        return Arrays.asList(Trace.getConfigurationFile() != null ? this.getPathRelativeToWorkingDir(Trace.getConfigurationFile()).toString() : "", configurator.isLogEnabled() ? this.getPathRelativeToWorkingDir(configurator.getLogFile()).toString() : "", DescribeTraceOperation.getStatus(Trace.isBroadcastEnabled("*")));
    }

    static RowMetaData createResultDescriptor(boolean atDomain) {
        RowMetaData result = new RowMetaData();
        if (atDomain) {
            DescribeTraceOperation.addColumn(result, "Node");
        }
        DescribeTraceOperation.addColumn(result, "Config File");
        DescribeTraceOperation.addColumn(result, "Log File");
        DescribeTraceOperation.addColumn(result, "Broadcast");
        return result;
    }

    static String getStatus(boolean status) {
        return status ? "Enabled" : "Disabled";
    }

    public static class Definition
    extends AbstractTraceOperation.AbstractDefinition {
        public Definition(DSLStatement statement) {
            super(DescribeTraceOperation.NAME, statement);
        }
    }
}

