/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.trace;

import com.streamscape.Logger;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.trace.AbstractTraceOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.trace.AbstractComponentLogger;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractLogBroadcastOperation
extends AbstractTraceOperation<RuntimeContext> {
    AbstractLogBroadcastOperation(String operationName, String action) {
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName);
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("FOR").addParameter((SyntaxParameter)((ExpressionParameter)new ExpressionParameter("ComponentName").setCompletionAdviser(new ComponentCompletionAdviser())).setCompactSyntax("<ComponentName> | all | *"))).setSyntaxHintSpace());
        this.syntax.setDescription(action + " log broadcast for the specified component (Service or Dataspace) in the current node.");
        this.syntax.setSyntaxDescription("Component name must be in the following format: <ServiceType>.<ServiceName> or <DataspaceName>.\n\n" + operationName + " all - " + action + " log broadcast for all components (Services and Dataspaces) in the current node.");
        this.syntax.setExamples(operationName + " for TestService.Default\n" + operationName + " for Dataspace1\n" + operationName + " for all\n" + operationName + " for *");
        this.syntax.addTag(OperationTag.log);
    }

    SLResponse doInvoke(SLStatement statement, boolean broadcast) throws Exception {
        AbstractDefinition definition = (AbstractDefinition)statement;
        if (definition.component.equalsIgnoreCase("all") || definition.component.equalsIgnoreCase("*")) {
            for (String serviceName : ((RuntimeContext)this.callable).getServiceManager().listRunningServices()) {
                this.setServiceLogBroadcast(serviceName, broadcast);
            }
            for (DataspaceComponent dataspace : ((RuntimeContext)this.callable).getDataspaceManager().getDataspaces()) {
                this.setDataspaceLogBroadcast(dataspace, broadcast);
            }
        } else if (((RuntimeContext)this.callable).getServiceManager().isServiceRegistered(definition.component)) {
            this.setServiceLogBroadcast(definition.component, broadcast);
        } else {
            DataspaceComponent dataspace = ((RuntimeContext)this.callable).getDataspaceManager().lookup(definition.component);
            if (dataspace != null) {
                this.setDataspaceLogBroadcast(dataspace, broadcast);
            } else {
                throw new Exception("Component not found.");
            }
        }
        return new SLResponse();
    }

    private void setServiceLogBroadcast(String serviceName, boolean broadcast) throws Exception {
        ((RuntimeContext)this.callable).getServiceManager().setServiceLogBroadcast(serviceName, broadcast);
    }

    private void setDataspaceLogBroadcast(DataspaceComponent dataspace, boolean broadcast) throws Exception {
        Logger logger = dataspace.getLogger();
        if (logger instanceof AbstractComponentLogger) {
            ((AbstractComponentLogger)((Object)logger)).setBroadcast(broadcast);
        }
    }

    private class ComponentCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext> {
        private ComponentCompletionAdviser() {
        }

        @Override
        protected List<String> doGetCompletions(String processedScript, MFSession session) {
            ArrayList<String> result = new ArrayList<String>(((RuntimeContext)AbstractLogBroadcastOperation.this.callable).getServiceManager().listRunningServices());
            result.addAll(((RuntimeContext)AbstractLogBroadcastOperation.this.callable).getDataspaceManager().listDataspaces());
            result.add("all");
            result.add("*");
            return result;
        }
    }

    static class AbstractDefinition
    extends AbstractSLStatement {
        private String component;

        AbstractDefinition(String operationName, String component) {
            super(operationName);
            this.component = component;
        }

        String getComponent() {
            return this.component;
        }
    }
}

