/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.thread;

import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.mf.operation.thread.AbstractThreadOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.NumericParameter;
import java.lang.management.ThreadInfo;
import java.sql.SQLException;
import java.util.List;

public class ShowThreadOperation<T extends SLCallable>
extends AbstractThreadOperation<T> {
    public static final String NAME = "show thread";

    public ShowThreadOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW THREAD");
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().addModifier(new Modifier("ALL"))).addParameter(new NumericParameter("ThreadId"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Shows information about the specified thread.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        long threadId = -1L;
        if (statement.existsParameter("ThreadId")) {
            threadId = Long.parseLong(statement.getParameter("ThreadId").getValue());
        }
        return new Definition(threadId);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        long threadId = ((Definition)statement).getThreadId();
        RowSet rowSet = new RowSet(ShowThreadOperation.createResultDescriptor());
        if (threadId != -1L) {
            ThreadInfo threadInfo;
            FabricThread thread = FabricThreadManager.getInstance().lookupThread(threadId);
            ThreadInfo threadInfo2 = threadInfo = thread != null ? thread.getInfo() : FabricThreadManager.getInstance().getThreadBean().getThreadInfo(threadId);
            if (threadInfo == null) {
                return new SLResponse("Thread not found.", false);
            }
            this.appendToRowSet(rowSet, thread, threadInfo);
        } else {
            List<ThreadInfo> threadsInfo = FabricThreadManager.getInstance().getThreadsInfo();
            for (ThreadInfo threadInfo : threadsInfo) {
                FabricThread thread = FabricThreadManager.getInstance().lookupThread(threadInfo.getThreadId());
                this.appendToRowSet(rowSet, thread, threadInfo);
            }
        }
        return new SLResponse(rowSet);
    }

    void appendToRowSet(RowSet rowSet, FabricThread thread, ThreadInfo threadInfo) throws SQLException {
        StackTraceElement[] stackTrace;
        if (rowSet.getRowCount() > 0) {
            rowSet.addToRowSet(new Object[]{"-----------", "-------------------------------"});
        }
        rowSet.addToRowSet(new Object[]{"ID", threadInfo.getThreadId()});
        rowSet.addToRowSet(new Object[]{"Name", threadInfo.getThreadName()});
        rowSet.addToRowSet(new Object[]{"State", threadInfo.getThreadState().name()});
        if (threadInfo.getLockOwnerId() != -1L) {
            rowSet.addToRowSet(new Object[]{"Blocked by", threadInfo.getLockOwnerId()});
        }
        if (thread != null) {
            rowSet.addToRowSet(new Object[]{"Uptime", Utils.toTimeString(System.currentTimeMillis() - thread.getStartTime())});
            rowSet.addToRowSet(new Object[]{"Daemon", Boolean.toString(thread.isDaemon())});
            if (thread.getDescription() != null) {
                rowSet.addToRowSet(new Object[]{"Description", thread.getDescription()});
            }
        }
        StackTraceElement[] stackTraceElementArray = stackTrace = thread != null ? thread.getStackTrace() : threadInfo.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            ShowThreadOperation.addRow(stackTrace, rowSet);
        }
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(8);
        ShowThreadOperation.addColumn(result, "Property");
        ShowThreadOperation.addColumn(result, "Value");
        return result;
    }

    static void addRow(StackTraceElement[] stackTrace, RowSet result) throws SQLException {
        for (int i = 0; i < stackTrace.length; ++i) {
            result.addToRowSet(new Object[]{i == 0 ? "Stack" : "", stackTrace[i].toString()});
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        private long threadId;

        public Definition(long threadId) {
            super(ShowThreadOperation.NAME);
            this.threadId = threadId;
        }

        public long getThreadId() {
            return this.threadId;
        }
    }
}

