/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.thread;

import com.streamscape.lib.concurrent.FabricThread;
import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.mf.operation.thread.AbstractThreadOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.lang.management.ThreadInfo;
import java.util.List;

public class ListThreadsOperation<T extends SLCallable>
extends AbstractThreadOperation<T> {
    public static final String NAME = "list threads";

    public ListThreadsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST THREADS");
        this.syntax.setDescription("Returns a list of threads currently running in the node.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListThreadsOperation.createResultDescriptor());
        List<ThreadInfo> threadsInfo = FabricThreadManager.getInstance().getThreadsInfo();
        for (ThreadInfo info : threadsInfo) {
            result.addToRowSet(new Object[]{info.getThreadId(), info.getThreadName(), info.getThreadState().name(), info.getLockOwnerId() != -1L ? Long.valueOf(info.getLockOwnerId()) : "", ListThreadsOperation.getUptime(info)});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(15);
        ListThreadsOperation.addColumn(result, "ID");
        ListThreadsOperation.addColumn(result, "Name");
        ListThreadsOperation.addColumn(result, "State");
        ListThreadsOperation.addColumn(result, "Blocked By");
        ListThreadsOperation.addColumn(result, "Uptime");
        return result;
    }

    static String getUptime(ThreadInfo info) {
        FabricThread thread = FabricThreadManager.getInstance().lookupThread(info.getThreadId());
        if (thread != null) {
            return Utils.toTimeString(System.currentTimeMillis() - thread.getStartTime());
        }
        return "";
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListThreadsOperation.NAME);
        }
    }
}

