/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.thread;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.thread.AbstractThreadOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.NumericParameter;

public class InterruptThreadOperation
extends AbstractThreadOperation<RuntimeContext> {
    public static final String NAME = "interrupt thread";

    public InterruptThreadOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("INTERRUPT THREAD").addActionParameter(new NumericParameter("ThreadId"));
        this.syntax.setDescription("Interrupts the specified thread.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ThreadId").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        if (FabricThreadManager.getInstance().interruptThread(Long.parseLong(((Definition)definition).getThreadId()))) {
            return new SLResponse();
        }
        return new SLResponse("Thread not found.", false);
    }

    public static class Definition
    extends AbstractSLStatement {
        private String threadId;

        public Definition(String threadId) {
            super(InterruptThreadOperation.NAME);
            this.threadId = threadId;
        }

        public String getThreadId() {
            return this.threadId;
        }
    }
}

