/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.stats.AbstractShowUsageOperation;
import com.streamscape.runtime.mf.operation.stats.ShowCpuUsageOperation;
import com.streamscape.runtime.mf.operation.stats.ShowDiskUsageOperation;
import com.streamscape.runtime.mf.operation.stats.ShowMemoryUsageOperation;
import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import java.util.List;

public class ShowStatsOperation
extends AbstractShowUsageOperation {
    public static final String NAME = "show stats";

    public ShowStatsOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW STATS");
        this.syntax.addModifier((AbstractModifier)new Modifier("CPU", false).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("MEMORY", false).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)new Modifier("DISK", false).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("show stats                    - Shows the specified stats (CPU, memory, disk) for the current node.\nshow stats at node <NodeName> - Shows the specified stats (CPU, memory, disk) for the specified node.\nshow stats at domain          - Shows the specified stats (CPU, memory, disk) for all nodes in the sysplex.");
    }

    @Override
    public boolean isVisible(MFSession session) {
        return false;
    }

    @Override
    public boolean isVisible(MFSession session, SLStatement statement) {
        return super.isVisible(session);
    }

    @Override
    public boolean isVisibleForExecution(MFSession session) {
        return super.isVisible(session);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        Definition result = new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.existsModifier("CPU"), statement.existsModifier("MEMORY"), statement.existsModifier("DISK"));
        if (!(result.cpu || result.memory || result.disk)) {
            throw new ParsingException("At least one parameter must be specified (cpu, memory or disk).");
        }
        return result;
    }

    @Override
    RowMetaData createResultDescriptorForShowUsage(boolean atDomain, AbstractShowUsageOperation.Definition statement) {
        Definition definition = (Definition)statement;
        return ShowStatsOperation.createResultDescriptor(atDomain || definition.isSystem, definition.cpu, definition.memory, definition.disk);
    }

    public static RowMetaData createResultDescriptor() {
        return ShowStatsOperation.createResultDescriptor(true, true, true, true);
    }

    private static RowMetaData createResultDescriptor(boolean addNode, boolean cpu, boolean memory, boolean disk) {
        RowMetaData result = new RowMetaData();
        if (addNode) {
            ShowStatsOperation.addColumn(result, "Node");
        }
        if (cpu) {
            ShowCpuUsageOperation.doCreateResultDescriptor(result);
        }
        if (memory) {
            ShowMemoryUsageOperation.doCreateResultDescriptor(result);
        }
        if (disk) {
            ShowDiskUsageOperation.doCreateResultDescriptor(result);
        }
        return result;
    }

    @Override
    void fillShowUsageResult(AbstractShowUsageOperation.Definition definition, RuntimeStats stats, List<String> values) {
        if (((Definition)definition).cpu) {
            ShowCpuUsageOperation.doFillShowUsageResult(stats, values);
        }
        if (((Definition)definition).memory) {
            ((ShowMemoryUsageOperation)this.getOperation("show memory usage")).doFillShowUsageResult(stats, AbstractOperation.Scale.KB, values);
        }
        if (((Definition)definition).disk) {
            ShowDiskUsageOperation.doFillShowUsageResult(stats, AbstractOperation.Scale.MB, values);
        }
    }

    public static class Definition
    extends AbstractShowUsageOperation.Definition {
        private boolean cpu = false;
        private boolean memory = false;
        private boolean disk = false;

        public Definition(String nodeName, boolean cpu, boolean memory, boolean disk) {
            super(ShowStatsOperation.NAME, nodeName);
            this.cpu = cpu;
            this.memory = memory;
            this.disk = disk;
        }

        public Definition() {
            this(null, true, true, true);
            this.isSystem = true;
        }

        public boolean isCpu() {
            return this.cpu;
        }

        public boolean isMemory() {
            return this.memory;
        }

        public boolean isDisk() {
            return this.disk;
        }
    }
}

