/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.stats.AbstractShowUsageOperation;
import com.streamscape.runtime.stats.MemoryPoolStats;
import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.runtime.stats.StatsListener;
import com.streamscape.runtime.stats.StatsMonitorException;
import com.streamscape.runtime.stats.SystemEnvironment;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import java.lang.management.MemoryType;
import java.util.List;

public class ShowMemoryUsageOperation
extends AbstractShowUsageOperation {
    public static final String NAME = "show memory usage";
    private long peakMemory = 0L;
    private boolean listenersInitialized = false;

    public ShowMemoryUsageOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW MEMORY USAGE").addModifier((AbstractModifier)((Modifier)new Modifier("ALL", false).setAlias("*")).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("IN", false).addParameter(new EnumParameter("Scale", AbstractOperation.Scale.class).setDefaultValue(AbstractOperation.Scale.KB.name()))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Shows stats for JVM memory usage.");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all                - Shows stats for JVM memory usage divided by pools.\n   in <Scale>         - Specifies a scale for output values (in bytes, kilobytes, megabytes or gigabytes).\n                        If this parameter is not specified the output values are displayed in kilobytes.\n   at node <NodeName> - Shows stats for JVM memory usage in the specified node.\n   at domain          - Shows stats for JVM memory usage for all nodes in the sysplex.");
        this.syntax.setExamples("show memory usage\nshow memory usage all\nshow memory usage in mb\nshow memory usage all in bytes\nshow memory usage at node TestNode\nshow memory usage at domain\nshow memory usage at domain in mb");
        this.syntax.addTag(OperationTag.memory);
    }

    @Override
    public void activate(RuntimeContext callable) {
        super.activate(callable);
        this.initializeListeners();
    }

    private void initializeListeners() {
        try {
            if (!this.listenersInitialized && ((RuntimeContext)this.callable).getStatsMonitor() != null) {
                ((RuntimeContext)this.callable).getStatsMonitor().addListener("SYS$PeakMemoryListener", new PeakMemoryListener());
                this.listenersInitialized = true;
            }
        }
        catch (StatsMonitorException exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Adding SYS$PeakMemoryListener failed.");
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.existsModifier("ALL"), statement.existsParameter("Scale") ? AbstractOperation.Scale.valueOf(statement.getParameter("Scale").getValue()) : AbstractOperation.Scale.KB);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        this.initializeListeners();
        return super.invoke(statement, session, timeout);
    }

    @Override
    RowMetaData createResultDescriptorForShowUsage(boolean atDomain, AbstractShowUsageOperation.Definition definition) {
        RowMetaData result = new RowMetaData();
        if (atDomain) {
            ShowMemoryUsageOperation.addColumn(result, "Node");
        }
        if (((Definition)definition).isAll) {
            ShowMemoryUsageOperation.addColumn(result, "Pool Name");
            ShowMemoryUsageOperation.addColumn(result, "Pool Type");
            ShowMemoryUsageOperation.addColumn(result, "Used");
            ShowMemoryUsageOperation.addColumn(result, "Peak");
            ShowMemoryUsageOperation.addColumn(result, "Init");
            ShowMemoryUsageOperation.addColumn(result, "Committed");
            ShowMemoryUsageOperation.addColumn(result, "Max");
        } else {
            ShowMemoryUsageOperation.doCreateResultDescriptor(result);
        }
        return result;
    }

    static void doCreateResultDescriptor(RowMetaData result) {
        ShowMemoryUsageOperation.addColumn(result, "Non-Heap");
        ShowMemoryUsageOperation.addColumn(result, "Heap");
        ShowMemoryUsageOperation.addColumn(result, "Total");
        ShowMemoryUsageOperation.addColumn(result, "Peak");
        ShowMemoryUsageOperation.addColumn(result, "Max Heap");
        ShowMemoryUsageOperation.addColumn(result, "Total System");
        ShowMemoryUsageOperation.addColumn(result, "Free System");
    }

    @Override
    void fillShowUsageResult(AbstractShowUsageOperation.Definition definition, RuntimeStats stats, List<String> values) {
        this.doFillShowUsageResult(stats, ((Definition)definition).scale, values);
    }

    void doFillShowUsageResult(RuntimeStats stats, AbstractOperation.Scale scale, List<String> values) {
        this.initializeListeners();
        values.add(scale.format(stats.getNonHeapUsedMemorySize()));
        values.add(scale.format(stats.getHeapUsedMemorySize()));
        values.add(scale.format(stats.getUsedMemorySize()));
        values.add(scale.format(this.peakMemory));
        values.add(scale.format(ShowMemoryUsageOperation.getMaxMemory(stats)));
        values.add(scale.format(((RuntimeContext)this.callable).getStatsMonitor().getTotalSystemMemorySize()));
        values.add(scale.format(stats.getFreePhysicalMemorySize()));
    }

    @Override
    void fillShowUsageResultForAll(AbstractShowUsageOperation.Definition definition, RuntimeStats stats, boolean atDomain, RowSet result) throws Exception {
        AbstractOperation.Scale scale = ((Definition)definition).scale;
        for (MemoryPoolStats pool : stats.getMemoryPoolsStats()) {
            List<String> values = this.makeValues(atDomain);
            values.add(pool.getName());
            values.add(pool.getType().name());
            values.add(scale.format(pool.getUsage().getUsed()));
            values.add(scale.format(pool.getPeakUsage().getUsed()));
            values.add(scale.format(pool.getUsage().getInit()));
            values.add(scale.format(pool.getUsage().getCommitted()));
            values.add(scale.format(pool.getUsage().getMax()));
            result.addToRowSet(values.toArray());
        }
    }

    private static long getMaxMemory(RuntimeStats stats) {
        long result = 0L;
        for (MemoryPoolStats pool : stats.getMemoryPoolsStats()) {
            if (pool.getType() != MemoryType.HEAP) continue;
            result += pool.getUsage().getMax();
        }
        return result;
    }

    private class PeakMemoryListener
    implements StatsListener {
        private PeakMemoryListener() {
        }

        @Override
        public void onSystemEnvironment(SystemEnvironment environment) {
        }

        @Override
        public void onStats(RuntimeStats stats) {
            if (ShowMemoryUsageOperation.this.peakMemory < stats.getUsedMemorySize()) {
                ShowMemoryUsageOperation.this.peakMemory = stats.getUsedMemorySize();
            }
        }
    }

    public static class Definition
    extends AbstractShowUsageOperation.Definition {
        private boolean isAll;
        private AbstractOperation.Scale scale;

        public Definition(String nodeName, boolean isAll, AbstractOperation.Scale scale) {
            super(ShowMemoryUsageOperation.NAME, nodeName);
            this.isAll = isAll;
            this.scale = scale;
        }

        @Override
        public boolean isAll() {
            return this.isAll;
        }

        public AbstractOperation.Scale getScale() {
            return this.scale;
        }
    }
}

