/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.mf.operation.stats.AbstractMemoryOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.lang.management.ManagementFactory;

public class ShowJvmOptionsOperation
extends AbstractMemoryOperation {
    public static final String NAME = "show jvm options";

    public ShowJvmOptionsOperation() {
        super(false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW JVM OPTIONS");
        this.syntax.setDescription("Shows a list of JVM options.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public synchronized SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ShowJvmOptionsOperation.createResultDescriptor());
        for (String option : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            result.addToRowSet(new Object[]{option});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ShowJvmOptionsOperation.addColumn(result, "Option");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ShowJvmOptionsOperation.NAME);
        }
    }
}

