/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.stats.AbstractShowUsageOperation;
import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.EnumParameter;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.Callable;

public class ShowDiskUsageOperation
extends AbstractShowUsageOperation {
    public static final String NAME = "show disk usage";

    public ShowDiskUsageOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW DISK USAGE").addModifier((AbstractModifier)((Modifier)new Modifier("ALL", false).setAlias("*")).setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("IN", false).addParameter(new EnumParameter("Scale", AbstractOperation.Scale.class).setDefaultValue(AbstractOperation.Scale.MB.name()))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("Shows disk usage (in percent).");
        this.syntax.setSyntaxDescription("Optional parameters:\n\n   all                - Shows usage of all disks in OS.\n   in <Scale>         - Specifies a scale for output values (in bytes, kilobytes, megabytes or gigabytes).\n                        If this parameter is not specified the output values are displayed in megabytes.\n   at node <NodeName> - Shows disk usage in the specified node.\n   at domain          - Shows disk usage for all nodes in the sysplex.");
        this.syntax.setExamples("show disk usage\nshow disk usage in kb\nshow disk usage all\nshow disk usage all in kb\nshow disk usage at node TestNode\nshow disk usage at domain\nshow disk usage all at domain in gb");
        this.syntax.addTag(OperationTag.disk);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.existsModifier("ALL"), statement.existsParameter("Scale") ? AbstractOperation.Scale.valueOf(statement.getParameter("Scale").getValue()) : AbstractOperation.Scale.MB);
    }

    @Override
    RowMetaData createResultDescriptorForShowUsage(boolean atDomain, AbstractShowUsageOperation.Definition definition) {
        RowMetaData result = new RowMetaData();
        if (atDomain) {
            ShowDiskUsageOperation.addColumn(result, "Node");
        }
        ShowDiskUsageOperation.doCreateResultDescriptor(result);
        return result;
    }

    static void doCreateResultDescriptor(RowMetaData result) {
        ShowDiskUsageOperation.addColumn(result, "Storage");
        ShowDiskUsageOperation.addColumn(result, "Total Space");
        ShowDiskUsageOperation.addColumn(result, "Used Space");
        ShowDiskUsageOperation.addColumn(result, "Free Space");
        ShowDiskUsageOperation.addColumn(result, "Usage");
    }

    @Override
    void fillShowUsageResult(AbstractShowUsageOperation.Definition definition, RuntimeStats stats, List<String> values) {
        ShowDiskUsageOperation.doFillShowUsageResult(stats, ((Definition)definition).scale, values);
    }

    static void doFillShowUsageResult(RuntimeStats stats, AbstractOperation.Scale scale, List<String> values) {
        values.add(ShowDiskUsageOperation.getStorage());
        values.add(scale.format(stats.getTotalDiskSpace()));
        values.add(scale.format(stats.getUsedDiskSpace()));
        values.add(scale.format(stats.getFreeDiskSpace()));
        values.add(ShowDiskUsageOperation.format(stats.getDiskUsage()));
    }

    @Override
    void fillShowUsageResultForAll(AbstractShowUsageOperation.Definition definition, RuntimeStats stats, boolean atDomain, RowSet result) throws Exception {
        AbstractOperation.Scale scale = ((Definition)definition).scale;
        FileSystem fs = FileSystems.getDefault();
        for (FileStore store : fs.getFileStores()) {
            long totalSpace = ShowDiskUsageOperation.getValue(store::getTotalSpace);
            long freeSpace = ShowDiskUsageOperation.getValue(store::getUsableSpace);
            long usedSpace = totalSpace - freeSpace;
            if (totalSpace <= 0L) continue;
            List<String> values = this.makeValues(atDomain);
            values.add(store.toString());
            values.add(scale.format(totalSpace));
            values.add(scale.format(usedSpace));
            values.add(scale.format(freeSpace));
            values.add(ShowDiskUsageOperation.format((double)usedSpace / (double)totalSpace));
            result.addToRowSet(values.toArray());
        }
    }

    private static String getStorage() {
        try {
            return Files.getFileStore(Paths.get(".", new String[0]).toAbsolutePath()).toString();
        }
        catch (Throwable exception) {
            return "n/a";
        }
    }

    private static long getValue(Callable<Long> getter) {
        try {
            return getter.call();
        }
        catch (Throwable exception) {
            return -1L;
        }
    }

    private static String format(double usage) {
        return usage >= 0.0 ? String.format("%1$.2f", Math.abs(usage) * 100.0) + "%" : "n/a";
    }

    public static class Definition
    extends AbstractShowUsageOperation.Definition {
        private boolean all = false;
        private AbstractOperation.Scale scale;

        public Definition(String nodeName, boolean all, AbstractOperation.Scale scale) {
            super(ShowDiskUsageOperation.NAME, nodeName);
            this.all = all;
            this.scale = scale;
        }

        @Override
        public boolean isAll() {
            return this.all;
        }

        public AbstractOperation.Scale getScale() {
            return this.scale;
        }
    }
}

