/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.stats.AbstractShowUsageOperation;
import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import java.util.List;

public class ShowCpuUsageOperation
extends AbstractShowUsageOperation {
    public static final String NAME = "show cpu usage";

    public ShowCpuUsageOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW CPU USAGE");
        this.syntax.addModifier(new AtNodeOrAtDomainModifier());
        this.syntax.setDescription("show cpu usage                    - Shows CPU usage (in percent) for the JVM and whole OS.\nshow cpu usage at node <NodeName> - Shows CPU usage (in percent) for the JVM and whole OS in the specified node.\nshow cpu usage at domain          - Shows CPU usage (in percent) for the JVM and whole OS for all nodes in the sysplex.");
        this.syntax.addTag(OperationTag.cpu);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement));
    }

    @Override
    RowMetaData createResultDescriptorForShowUsage(boolean atDomain, AbstractShowUsageOperation.Definition definition) {
        RowMetaData result = new RowMetaData();
        if (atDomain) {
            ShowCpuUsageOperation.addColumn(result, "Node");
        }
        ShowCpuUsageOperation.doCreateResultDescriptor(result);
        return result;
    }

    static void doCreateResultDescriptor(RowMetaData result) {
        ShowCpuUsageOperation.addColumn(result, "JVM");
        ShowCpuUsageOperation.addColumn(result, "System");
    }

    @Override
    void fillShowUsageResult(AbstractShowUsageOperation.Definition definition, RuntimeStats stats, List<String> values) {
        ShowCpuUsageOperation.doFillShowUsageResult(stats, values);
    }

    static void doFillShowUsageResult(RuntimeStats stats, List<String> values) {
        values.add(ShowCpuUsageOperation.format(stats.getJvmCpuUsage()));
        values.add(ShowCpuUsageOperation.format(stats.getSystemCpuUsage()));
    }

    static String format(double usage) {
        return String.format("%1$.2f", Math.abs(usage) * 100.0) + "%";
    }

    public static class Definition
    extends AbstractShowUsageOperation.Definition {
        public Definition(String nodeName) {
            super(ShowCpuUsageOperation.NAME, nodeName);
        }
    }
}

