/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.stats.AbstractCpuOperation;
import com.streamscape.runtime.mf.operation.stats.AddCpuThresholdOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.modifier.Subject;

public class SetCpuThresholdIntervalOperation
extends AbstractCpuOperation {
    public static final String NAME = "set cpu threshold interval";

    public SetCpuThresholdIntervalOperation() {
        super(false);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET CPU THRESHOLD");
        this.syntax.addActionParameter(this.makeThresholdParameter(100, true, true));
        this.syntax.setSubject(new Subject("INTERVAL"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("").addParameter(AddCpuThresholdOperation.makeIntervalParameter())).setSyntaxHintSpace());
        this.syntax.addModifier(this.makeKeyModifier(false));
        this.syntax.setDescription("Sets the specified exceeding interval (in seconds) for the CPU threshold listener.");
        this.syntax.setSyntaxDescription(this.getAddThresholdSyntaxDescription());
        this.syntax.setExamples("set cpu threshold 80 interval 3\nset cpu threshold 80 interval 3 key 'Bob'");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getThresholdParameter(statement), this.getKeyParameter(statement), Integer.parseInt(statement.getParameter("Interval").getValue()));
    }

    @Override
    public synchronized SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ((RuntimeContext)this.callable).getStatsMonitor().setCpuThresholdListenerInterval(definition.threshold, definition.key, definition.interval);
        return new SLResponse();
    }

    public static class Definition
    extends AddCpuThresholdOperation.Definition {
        public Definition(int threshold, String key, int interval) {
            super(SetCpuThresholdIntervalOperation.NAME, threshold, key, interval);
        }
    }
}

