/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.stats.AbstractMemoryOperation;
import com.streamscape.runtime.mf.operation.stats.AbstractStatsOperation;
import com.streamscape.runtime.stats.StatsMonitor;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class RemoveMemoryThresholdOperation
extends AbstractMemoryOperation {
    public static final String NAME = "remove memory threshold";

    public RemoveMemoryThresholdOperation() {
        super(false);
        this.initRemoveThresholdOperation(NAME, Integer.MAX_VALUE);
        this.syntax.setDescription("Removes a listener that checks if a memory usage of the JVM exceeds the specified threshold (in megabytes).");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseRemoveThresholdOperation(statement);
    }

    @Override
    public synchronized SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        StatsMonitor monitor = ((RuntimeContext)this.callable).getStatsMonitor();
        this.doInvoke((Definition)statement, monitor::getMemoryThresholds, monitor::removeMemoryThresholdListener, monitor::clearMemoryThresholdListeners);
        return new SLResponse();
    }

    @Override
    AbstractStatsOperation.RemoveThresholdDefinition createRemoveThresholdDefinition(int threshold, String key, boolean all) {
        return new Definition(threshold, key, all);
    }

    public static class Definition
    extends AbstractStatsOperation.RemoveThresholdDefinition {
        public Definition(int threshold, String key, boolean all) {
            super(RemoveMemoryThresholdOperation.NAME, threshold, key, all);
        }

        public int getThreshold() {
            return this.threshold;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isAll() {
            return this.all;
        }
    }
}

