/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.stats.AbstractCpuOperation;
import com.streamscape.runtime.mf.operation.stats.AbstractStatsOperation;
import com.streamscape.runtime.stats.StatsMonitor;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class RemoveCpuThresholdOperation
extends AbstractCpuOperation {
    public static final String NAME = "remove cpu threshold";

    public RemoveCpuThresholdOperation() {
        super(false);
        this.initRemoveThresholdOperation(NAME, 100);
        this.syntax.setDescription("Removes a listener that checks if a CPU load of the JVM exceeds the specified threshold (in percents).");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseRemoveThresholdOperation(statement);
    }

    @Override
    public synchronized SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        StatsMonitor monitor = ((RuntimeContext)this.callable).getStatsMonitor();
        this.doInvoke((Definition)statement, monitor::getCpuThresholds, monitor::removeCpuThresholdListener, monitor::clearCpuThresholdListeners);
        return new SLResponse();
    }

    @Override
    AbstractStatsOperation.RemoveThresholdDefinition createRemoveThresholdDefinition(int threshold, String key, boolean all) {
        return new Definition(threshold, key, all);
    }

    public static class Definition
    extends AbstractStatsOperation.RemoveThresholdDefinition {
        public Definition(int threshold, String key, boolean all) {
            super(RemoveCpuThresholdOperation.NAME, threshold, key, all);
        }

        public int getThreshold() {
            return this.threshold;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isAll() {
            return this.all;
        }
    }
}

