/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.stats.AbstractStatsOperation;
import com.streamscape.runtime.stats.threshold.CpuThreshold;
import com.streamscape.runtime.stats.threshold.Threshold;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.List;

public class ListStatsThresholdsOperation
extends AbstractStatsOperation {
    public static final String NAME = "list stats thresholds";

    public ListStatsThresholdsOperation() {
        super(false);
        this.initListThresholdsOperation(NAME);
        this.syntax.setDescription("Returns a list of monitored stats thresholds (cpu, disk, memory).");
    }

    @Override
    String getAddThresholdKeyIndent() {
        return this.doGetAddThresholdKeyIndent();
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), this.getKeyParameter(statement));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, true, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(this.createListThresholdsResultDescriptor(definition));
        this.doInvoke(node, definition.setType(AbstractStatsOperation.ThresholdType.CPU), ((RuntimeContext)this.callable).getStatsMonitor().getCpuThresholds(), result);
        this.doInvoke(node, definition.setType(AbstractStatsOperation.ThresholdType.Disk), ((RuntimeContext)this.callable).getStatsMonitor().getDiskThresholds(), result);
        this.doInvoke(node, definition.setType(AbstractStatsOperation.ThresholdType.Memory), ((RuntimeContext)this.callable).getStatsMonitor().getMemoryThresholds(), result);
        return new SLResponse(result);
    }

    @Override
    RowMetaData createListThresholdsResultDescriptor(AbstractStatsOperation.ListThresholdsDefinition definition) {
        RowMetaData result = new RowMetaData();
        if (this.atDomain(definition)) {
            ListStatsThresholdsOperation.addColumn(result, "Node");
        }
        ListStatsThresholdsOperation.addColumn(result, "Type");
        this.createListThresholdsResultDescriptor(definition, result);
        ListStatsThresholdsOperation.addColumn(result, "Interval");
        return result;
    }

    @Override
    List<String> getListThresholdsValues(FabricNodeReference node, AbstractStatsOperation.ListThresholdsDefinition definition, Threshold threshold) {
        List<String> result = super.getListThresholdsValues(node, definition, threshold);
        result.add(this.atDomain(definition) ? 1 : 0, definition.type.name());
        result.add((String)(definition.type == AbstractStatsOperation.ThresholdType.CPU ? ((CpuThreshold)threshold).getInterval() + " seconds" : ""));
        return result;
    }

    public static class Definition
    extends AbstractStatsOperation.ListThresholdsDefinition {
        public Definition(String nodeName, String key) {
            super(ListStatsThresholdsOperation.NAME, nodeName, key);
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getKey() {
            return this.key;
        }
    }
}

