/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.stats.AbstractMemoryOperation;
import com.streamscape.runtime.mf.operation.stats.AbstractStatsOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class AddMemoryThresholdOperation
extends AbstractMemoryOperation {
    public static final String NAME = "add memory threshold";

    public AddMemoryThresholdOperation() {
        super(false);
        this.initAddThresholdOperation(NAME, Integer.MAX_VALUE);
        this.syntax.setDescription("Adds a listener that checks if a memory usage of the JVM exceeds the specified threshold (in megabytes).");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseAddThresholdOperation(statement);
    }

    @Override
    public synchronized SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ((RuntimeContext)this.callable).getStatsMonitor().addMemoryThresholdListener(definition.threshold, definition.key);
        return new SLResponse();
    }

    @Override
    AbstractStatsOperation.ThresholdDefinition createAddThresholdDefinition(int threshold, String key) {
        return new Definition(threshold, key);
    }

    public static class Definition
    extends AbstractStatsOperation.ThresholdDefinition {
        public Definition(int threshold, String key) {
            super(AddMemoryThresholdOperation.NAME, threshold, key);
        }

        public int getThreshold() {
            return this.threshold;
        }

        public String getKey() {
            return this.key;
        }
    }
}

