/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.stats.AbstractDiskOperation;
import com.streamscape.runtime.mf.operation.stats.AbstractStatsOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class AddDiskThresholdOperation
extends AbstractDiskOperation {
    public static final String NAME = "add disk threshold";

    public AddDiskThresholdOperation() {
        super(false);
        this.createDSLSyntax(NAME);
        this.initAddThresholdOperation(NAME, 100);
        this.syntax.setDescription("Adds a listener that checks if a disk usage exceeds the specified threshold (in percent).");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseAddThresholdOperation(statement);
    }

    @Override
    public synchronized SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ((RuntimeContext)this.callable).getStatsMonitor().addDiskThresholdListener(definition.threshold, definition.key);
        return new SLResponse();
    }

    @Override
    AbstractStatsOperation.ThresholdDefinition createAddThresholdDefinition(int threshold, String key) {
        return new Definition(threshold, key);
    }

    public static class Definition
    extends AbstractStatsOperation.ThresholdDefinition {
        public Definition(int threshold, String key) {
            super(AddDiskThresholdOperation.NAME, threshold, key);
        }

        public int getThreshold() {
            return this.threshold;
        }

        public String getKey() {
            return this.key;
        }
    }
}

