/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.stats.AbstractCpuOperation;
import com.streamscape.runtime.mf.operation.stats.AbstractStatsOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IntegerParameter;

public class AddCpuThresholdOperation
extends AbstractCpuOperation {
    public static final String NAME = "add cpu threshold";

    public AddCpuThresholdOperation() {
        super(false);
        this.initAddThresholdOperation(NAME, 100);
        this.syntax.addModifier((AbstractModifier)new Modifier("INTERVAL", false).addParameter(AddCpuThresholdOperation.makeIntervalParameter()));
        this.syntax.setDescription("Adds a listener that checks if a CPU load of the JVM exceeds the specified threshold (in percent).");
    }

    static IntegerParameter makeIntervalParameter() {
        return new IntegerParameter("Interval").setRange(1, Integer.MAX_VALUE);
    }

    @Override
    String getAddThresholdSyntaxDescription() {
        return super.getAddThresholdSyntaxDescription() + "\n   interval - the exceeding time (in seconds) for the threshold.\n              If the threshold is exceeded within the specified interval, the corresponding advisory will be raised.\n              Default value is 5 seconds.";
    }

    @Override
    String getAddThresholdKeyIndent() {
        return "     ";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getThresholdParameter(statement), this.getKeyParameter(statement), statement.existsParameter("Interval") ? Integer.parseInt(statement.getParameter("Interval").getValue()) : -1);
    }

    @Override
    public synchronized SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (definition.interval > 0) {
            ((RuntimeContext)this.callable).getStatsMonitor().addCpuThresholdListener(definition.threshold, definition.key, definition.interval);
        } else {
            ((RuntimeContext)this.callable).getStatsMonitor().addCpuThresholdListener(definition.threshold, definition.key);
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractStatsOperation.ThresholdDefinition {
        int interval;

        public Definition(int threshold, String key, int interval) {
            this(AddCpuThresholdOperation.NAME, threshold, key, interval);
        }

        Definition(String operationName, int threshold, String key, int interval) {
            super(operationName, threshold, key);
            this.interval = interval;
        }

        public int getThreshold() {
            return this.threshold;
        }

        public String getKey() {
            return this.key;
        }

        public int getInterval() {
            return this.interval;
        }
    }
}

