/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.stats;

import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.runtime.mf.operation.stats.AbstractShowUsageOperation;
import com.streamscape.runtime.stats.RuntimeStats;
import com.streamscape.runtime.stats.threshold.Threshold;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IntegerParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

abstract class AbstractStatsOperation
extends AbstractOperation<RuntimeContext> {
    AbstractStatsOperation(boolean isDiagnostic) {
        super(false, isDiagnostic);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.stats);
    }

    SLResponse doInvokeShowUsage(String nodeName, AbstractShowUsageOperation.Definition definition) throws Exception {
        boolean atDomain = nodeName != null && nodeName.equals("*");
        RowSet result = new RowSet(this.createResultDescriptorForShowUsage(atDomain, definition));
        RuntimeStats stats = ((RuntimeContext)this.callable).getStatsMonitor().getRuntimeStats();
        if (!definition.isAll()) {
            List<String> values = this.makeValues(definition.isSystem || atDomain);
            this.fillShowUsageResult(definition, stats, values);
            result.addToRowSet(values.toArray());
        } else {
            this.fillShowUsageResultForAll(definition, stats, atDomain, result);
        }
        return new SLResponse(result);
    }

    RowMetaData createResultDescriptorForShowUsage(boolean atDomain, AbstractShowUsageOperation.Definition definition) {
        return null;
    }

    List<String> makeValues(boolean atDomain) {
        ArrayList<String> values = new ArrayList<String>();
        if (atDomain) {
            values.add(((RuntimeContext)this.callable).getName());
        }
        return values;
    }

    void fillShowUsageResult(AbstractShowUsageOperation.Definition definition, RuntimeStats stats, List<String> values) {
    }

    void fillShowUsageResultForAll(AbstractShowUsageOperation.Definition definition, RuntimeStats stats, boolean atDomain, RowSet result) throws Exception {
    }

    void initAddThresholdOperation(String operationName, int maxBoundary) {
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName).addActionParameter(this.makeThresholdParameter(maxBoundary, true, false));
        this.syntax.addModifier((AbstractModifier)this.makeKeyModifier(false).setSyntaxHintSpace());
        this.syntax.setSyntaxDescription(this.getAddThresholdSyntaxDescription());
        this.syntax.setExamples(this.getName() + " " + this.getThresholdExamplesValue() + "\n" + this.getName() + " " + this.getThresholdExamplesValue() + " key 'Bob'");
    }

    String getAddThresholdSyntaxDescription() {
        return "Optional parameters:\n\n   key" + this.getAddThresholdKeyIndent() + " - the key associated with the threshold.\n" + this.getAddThresholdKeyIndent() + "         This key is assigned to 'eventKey' property of the corresponding advisory.";
    }

    String getAddThresholdKeyIndent() {
        return "";
    }

    ThresholdDefinition parseAddThresholdOperation(DSLStatement statement) throws ParsingException {
        return this.createAddThresholdDefinition(this.getThresholdParameter(statement), this.getKeyParameter(statement));
    }

    ThresholdDefinition createAddThresholdDefinition(int threshold, String key) {
        return null;
    }

    int getThresholdParameter(DSLStatement statement) {
        return statement.existsParameter("Threshold") ? Integer.parseInt(statement.getParameter("Threshold").getValue()) : -1;
    }

    String getKeyParameter(DSLStatement statement) {
        return statement.existsParameter("Key") ? statement.getParameter("Key").getValue() : null;
    }

    void initRemoveThresholdOperation(String operationName, int maxBoundary) {
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName);
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().addModifier(new CompoundModifier("option1", false).addParameter(this.makeThresholdParameter(maxBoundary, true, true)).addModifier(this.makeKeyModifier(false, false, "key1")).addModifier(new Modifier("ALL", "all1", false)))).addModifier(new CompoundModifier("option2", false).addModifier(this.makeKeyModifier(true, true, "key2")).addModifier(new Modifier("ALL", "all2")))).addModifier(new Modifier("ALL", "all3")));
        this.syntax.setSyntaxDescription("At least one parameter must be specified.\nThe following combinations are allowed:\n\n   " + operationName + " all                   - removes all listeners.\n   " + operationName + " <Threshold>           - removes a listener matching the specified threshold (without a key).\n   " + operationName + " <Threshold> all       - removes all listeners matching the specified threshold and any key.\n   " + operationName + " <Threshold> key <Key> - removes a listener matching the specified threshold and key.\n   " + operationName + " key <Key> all         - removes all listeners matching the specified key.");
        this.syntax.setExamples(this.getName() + " " + this.getThresholdExamplesValue() + "\n" + this.getName() + " " + this.getThresholdExamplesValue() + " key 'Bob'\n" + this.getName() + " *\n" + this.getName() + " " + this.getThresholdExamplesValue() + " all\n" + this.getName() + " key 'Bob' *");
    }

    ThresholdDefinition parseRemoveThresholdOperation(DSLStatement statement) throws ParsingException {
        if (statement.getValuesCount() == 2 && !statement.getValue(1).isPresent()) {
            throw new ParsingException(this.getSyntaxErrorMessage("At least one parameter must be specified."));
        }
        RemoveThresholdDefinition result = this.createRemoveThresholdDefinition(this.getThresholdParameter(statement), statement.existsParameter("key1") ? statement.getParameter("key1").getValue() : (statement.existsParameter("key2") ? statement.getParameter("key2").getValue() : null), statement.existsModifier("all1") || statement.existsModifier("all2") || statement.existsModifier("all3"));
        if (result.threshold == -1 && result.key != null && !result.all || result.threshold != -1 && result.key != null && result.all) {
            throw new ParsingException(this.getSyntaxErrorMessage("Such combination of parameters is not allowed."));
        }
        return result;
    }

    RemoveThresholdDefinition createRemoveThresholdDefinition(int threshold, String key, boolean all) {
        return null;
    }

    void doInvoke(RemoveThresholdDefinition definition, Supplier<List<? extends Threshold>> getter, BiFunction<Integer, String, Boolean> remover, Runnable cleaner) throws Exception {
        if (definition.threshold != -1 && !definition.all) {
            if (!remover.apply(definition.threshold, definition.key).booleanValue()) {
                throw new Exception("Threshold not found.");
            }
        } else if (definition.threshold != -1 && definition.key == null && definition.all) {
            getter.get().stream().filter(threshold -> threshold.getValue() == definition.threshold).forEach(threshold -> remover.apply(threshold.getValue(), threshold.getKey()));
        } else if (definition.threshold == -1 && definition.key != null && definition.all) {
            getter.get().stream().filter(threshold -> Utils.equalsNullSafe(threshold.getKey(), definition.key)).forEach(threshold -> remover.apply(threshold.getValue(), threshold.getKey()));
        } else if (definition.threshold == -1 && definition.key == null && definition.all) {
            cleaner.run();
        }
    }

    IntegerParameter makeThresholdParameter(int maxBoundary, boolean required, boolean withCompletionAdviser) {
        IntegerParameter result = (IntegerParameter)new IntegerParameter("Threshold").setRange(1, maxBoundary).setRequired(required);
        if (withCompletionAdviser) {
            result.setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser(){

                @Override
                public List<String> doGetCompletions(String processedScript, MFSession session) {
                    return AbstractStatsOperation.this.getThresholdsForCompletion().stream().map(t -> Integer.toString(t.getValue())).collect(Collectors.toList());
                }
            });
        }
        return result;
    }

    Modifier makeKeyModifier(boolean withCompletionAdviser) {
        return this.makeKeyModifier(false, withCompletionAdviser, null);
    }

    Modifier makeKeyModifier(boolean required, boolean withCompletionAdviser, String uniqueName) {
        StringParameter key = new StringParameter("Key");
        if (uniqueName != null) {
            key.setName(uniqueName);
        }
        if (withCompletionAdviser) {
            key.setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser(){

                @Override
                public List<String> doGetCompletions(String processedScript, MFSession session) {
                    return AbstractStatsOperation.this.getThresholdsForCompletion().stream().filter(t -> t.getKey() != null).map(t -> "'" + t.getKey() + "'").sorted().collect(Collectors.toList());
                }
            });
        }
        Modifier result = (Modifier)new Modifier("KEY", required).addParameter(key);
        return uniqueName != null ? (Modifier)result.setName("Modifier_" + uniqueName) : result;
    }

    int getThresholdExamplesValue() {
        return -1;
    }

    void initListThresholdsOperation(String operationName) {
        this.createDSLSyntax(operationName);
        this.syntax.setAction(operationName);
        this.syntax.addModifier((AbstractModifier)this.makeKeyModifier(true).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(true));
        this.syntax.setSyntaxDescription(this.getAddThresholdSyntaxDescription() + "\n   at node <NodeName> - Executes the command at the specified node.\n   at domain          - Executes the command at all nodes of the sysplex.");
        this.syntax.setExamples(this.getName() + "\n" + this.getName() + " key 'Bob'\n" + this.getName() + " at node TestNode1\n" + this.getName() + " key 'Bob' at domain");
    }

    String doGetAddThresholdKeyIndent() {
        return "               ";
    }

    SLResponse doInvoke(FabricNodeReference node, ListThresholdsDefinition definition, List<? extends Threshold> thresholds) throws Exception {
        RowSet result = new RowSet(this.createListThresholdsResultDescriptor(definition));
        this.doInvoke(node, definition, thresholds, result);
        return new SLResponse(result);
    }

    void doInvoke(FabricNodeReference node, ListThresholdsDefinition definition, List<? extends Threshold> thresholds, RowSet result) throws Exception {
        thresholds.sort(Comparator.comparingInt(Threshold::getValue));
        for (Threshold threshold : thresholds) {
            if (definition.key != null && !definition.key.equals(threshold.getKey())) continue;
            result.addToRowSet(this.getListThresholdsValues(node, definition, threshold).toArray());
        }
    }

    RowMetaData createListThresholdsResultDescriptor(ListThresholdsDefinition definition) {
        RowMetaData result = new RowMetaData();
        if (this.atDomain(definition)) {
            AbstractStatsOperation.addColumn(result, "Node");
        }
        this.createListThresholdsResultDescriptor(definition, result);
        return result;
    }

    void createListThresholdsResultDescriptor(ListThresholdsDefinition definition, RowMetaData result) {
        AbstractStatsOperation.addColumn(result, "Threshold");
        AbstractStatsOperation.addColumn(result, "Key");
    }

    List<String> getListThresholdsValues(FabricNodeReference node, ListThresholdsDefinition definition, Threshold threshold) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.atDomain(definition)) {
            result.add(node.getName());
        }
        result.add(Integer.toString(threshold.getValue()));
        result.add(AbstractStatsOperation.skipNull(threshold.getKey()));
        return result;
    }

    boolean atDomain(ListThresholdsDefinition definition) {
        return definition.nodeName != null && definition.nodeName.equals("*");
    }

    List<? extends Threshold> getThresholdsForCompletion() {
        return null;
    }

    static class ThresholdDefinition
    extends AbstractSLStatement {
        int threshold = -1;
        String key;

        ThresholdDefinition(String operationName, int threshold, String key) {
            super(operationName);
            this.threshold = threshold;
            this.key = key;
        }
    }

    static class RemoveThresholdDefinition
    extends ThresholdDefinition {
        boolean all;

        RemoveThresholdDefinition(String operationName, int threshold, String key, boolean all) {
            super(operationName, threshold, key);
            this.all = all;
        }
    }

    static abstract class ListThresholdsDefinition
    extends AbstractSLStatement {
        String nodeName;
        String key;
        transient ThresholdType type;

        ListThresholdsDefinition(String operationName, String nodeName, String key) {
            super(operationName);
            this.nodeName = nodeName;
            this.key = key;
        }

        ListThresholdsDefinition setType(ThresholdType type) {
            this.type = type;
            return this;
        }

        ThresholdType getType() {
            return this.type;
        }
    }

    static enum ThresholdType {
        CPU,
        Disk,
        Memory;

    }
}

