/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.sqlquery;

import com.streamscape.Trace;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.sqlquery.AbstractSQLQueryOperation;
import com.streamscape.runtime.mf.operation.sqlquery.ListSQLQueriesOperation;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sdo.sql.enums.SQLQueryParameterMode;
import com.streamscape.sdo.sql.enums.SQLQueryType;
import com.streamscape.sdo.sql.enums.SQLTypeToken;
import com.streamscape.sef.utils.RepositoryUtils;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.Iterator;
import java.util.List;

public class DescribeSQLQueryOperation
extends AbstractSQLQueryOperation {
    public static final String NAME = "describe sql query";
    public static String COLUMN_PARAMETER_NAME = "Name";
    public static String COLUMN_PARAMETER_TYPE = "Type";
    public static String COLUMN_PARAMETER_NULLABLE = "Nullable";
    public static String COLUMN_PARAMETER_SEARCHABLE = "Searchable";
    public static String COLUMN_PARAMETER_RETURN_CODE = "Return Code";
    public static String COLUMN_PARAMETER_VALUE = "Value";
    public static String COLUMN_PARAMETER_LENGTH = "Length";
    public static String COLUMN_PARAMETER_PRECISION = "Precision";
    public static String COLUMN_PARAMETER_SCALE = "Scale";
    public static String COLUMN_PARAMETER_ORDINAL = "Ordinal";
    public static String COLUMN_PARAMETER_MODE = "Mode";

    public DescribeSQLQueryOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SQL QUERY").addActionParameter(new IdentifierParameter("QueryName"));
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("PARAMETERS").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Shows information about the specified SQL query.");
        this.syntax.setSyntaxDescription("describe sql query <QueryName>            - Shows all information about sql query except parameters.\ndescribe sql query <QueryName> parameters - Shows sql query parameters.\n");
        this.syntax.setExamples("describe sql query Example");
        this.syntax.addCompletionCommand("list sql queries");
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        try {
            completions.addAll(ListSQLQueriesOperation.listSQLQueries((RuntimeContext)this.callable));
        }
        catch (Exception exception) {
            Trace.logException(this, exception, false);
        }
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("QueryName").getValue(), statement.getModifier("PARAMETERS").isPresent());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet result;
        Definition definition = (Definition)statement;
        SQLQuery query = DescribeSQLQueryOperation.getSQLQuery(definition.queryName);
        if (query == null) {
            throw new Exception("SQL query doesn't exist.");
        }
        if (!definition.parameters) {
            result = new RowSet(DescribeSQLQueryOperation.createResultDescriptor());
            result.addToRowSet(new Object[]{"Name", definition.queryName});
            result.addToRowSet(new Object[]{"Description", query.getDescription()});
            result.addToRowSet(new Object[]{"Query Type", SQLQueryType.getTypeById(query.getQueryType())});
            result.addToRowSet(new Object[]{"Is Callable", query.isCallable()});
            result.addToRowSet(new Object[]{"SQL Script", query.getSqlScript()});
        } else {
            result = DescribeSQLQueryOperation.getSQLQueryParametersTable(query);
        }
        return new SLResponse(result);
    }

    public static SQLQuery getSQLQuery(String queryName) throws Exception {
        ReferenceContext queryContext = new ReferenceContext(ReferenceContext.NULL, SQLQuery.SQL_QUERY_OBJECTS_NAMESPACE);
        return (SQLQuery)RepositoryUtils.lookupObject(queryContext, queryName, null);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeSQLQueryOperation.addColumn(result, "Property");
        DescribeSQLQueryOperation.addColumn(result, "Value");
        return result;
    }

    public static RowSet getSQLQueryParametersTable(SQLQuery query) throws Exception {
        RowSet result = new RowSet(DescribeSQLQueryOperation.createResultDescriptorParameters());
        Iterator<SQLQueryParameter> iterator = query.getParameterIterator();
        while (iterator.hasNext()) {
            SQLQueryParameter parameter = iterator.next();
            Row row = result.newRow();
            row.setColumn(COLUMN_PARAMETER_NAME, (Object)parameter.getName());
            row.setColumn(COLUMN_PARAMETER_TYPE, (Object)SQLTypeToken.getTypeById(parameter.getType()));
            row.setColumn(COLUMN_PARAMETER_NULLABLE, (Object)parameter.isNullable());
            row.setColumn(COLUMN_PARAMETER_SEARCHABLE, (Object)parameter.isSearchable());
            row.setColumn(COLUMN_PARAMETER_RETURN_CODE, (Object)parameter.isReturnCode());
            row.setColumn(COLUMN_PARAMETER_VALUE, (Object)parameter.getValue());
            row.setColumn(COLUMN_PARAMETER_LENGTH, (Object)parameter.getLength());
            row.setColumn(COLUMN_PARAMETER_PRECISION, (Object)parameter.getPrecision());
            row.setColumn(COLUMN_PARAMETER_SCALE, (Object)parameter.getScale());
            row.setColumn(COLUMN_PARAMETER_ORDINAL, (Object)parameter.getOrdinal());
            row.setColumn(COLUMN_PARAMETER_MODE, (Object)SQLQueryParameterMode.getMode(parameter.getMode()));
            result.addToRowSet(row);
        }
        return result;
    }

    private static RowMetaData createResultDescriptorParameters() {
        RowMetaData result = new RowMetaData();
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_NAME);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_TYPE);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_NULLABLE);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_SEARCHABLE);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_RETURN_CODE);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_VALUE);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_LENGTH);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_PRECISION);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_SCALE);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_ORDINAL);
        DescribeSQLQueryOperation.addColumn(result, COLUMN_PARAMETER_MODE);
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        String queryName;
        boolean parameters;

        public Definition(String queryName, boolean parameters) {
            super(DescribeSQLQueryOperation.NAME);
            this.queryName = queryName;
            this.parameters = parameters;
        }
    }
}

