/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.runtime.mf.operation.service.redsquare;

import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.service.redsquare.AbstractRedSquareOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.SLFilePathParameter;

public class RegisterOperatorManagerOperation
extends AbstractRedSquareOperation {
    static final String MANAGER_SERVICE_TYPE = "RedSquareManager";
    private static final String MANAGER_SERVICE_NAME = "RedSquareProcessTypesManager";
    private static final String MANAGER_SCO_PATH = "resources/RedSquareManager.RedSquareProcessTypesManager.sco";
    public static final String NAME = "register operator manager";

    public RegisterOperatorManagerOperation() {
        super.createDSLSyntax(NAME);
        this.syntax.addTag(OperationTag.service);
        this.syntax.addTag(OperationTag.red_square);
        this.syntax.setAction("REGISTER OPERATOR MANAGER").addModifier((AbstractModifier)((Modifier)((Modifier)new Modifier("FROM").addParameter(new SLFilePathParameter("Location"))).setSyntaxHint(SyntaxHint.SPACE)).setRequired(false));
        this.syntax.setAlias("register ops manager");
        this.syntax.setDescription("Creates and register a RedSquare manager service");
        this.syntax.setExamples("register operator manager\nregister operator manager from 'C:\\StreamScape\\Temp\\stredsquare.jar'");
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        AbstractRedSquareOperation.Definition definition = (AbstractRedSquareOperation.Definition)statement;
        RepositoryAccessor repository = ((RuntimeContext)this.callable).getRepositoryAccessor();
        if (repository.listServicesByType("RedSquareAgent").size() > 0) {
            throw new Exception("RedSquare Agent service already registered. Agent and Manager services cannot be registered in one node.");
        }
        if (repository.existsServiceConfiguration(MANAGER_SERVICE_NAME, MANAGER_SERVICE_TYPE)) {
            throw new Exception("RedSquare Manager service already exists.");
        }
        this.importArchive(session, definition, MANAGER_SCO_PATH);
        ServiceConfigurationObject sco = this.getServiceSco(MANAGER_SCO_PATH);
        repository.saveServiceConfiguration(sco);
        this.registerService(MANAGER_SERVICE_TYPE, MANAGER_SERVICE_NAME);
        return new SLResponse("RedSquare Manager service created.");
    }
}

